package com.ejianc.business.cost.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.budget.vo.CostAmountVO;
import com.ejianc.business.cost.vo.CostStatisticDetailVO;
import com.ejianc.business.cost.vo.CostStatisticVO;
import com.ejianc.business.cost.vo.SubjectVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.cost.bean.SubjectEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 成本设置科目明细
 * 
 * @author generator
 * 
 */
@Mapper
public interface SubjectMapper extends BaseCrudMapper<SubjectEntity> {

    List<SubjectVO> geSubjects(@Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<CostStatisticDetailVO> queryCostStatist(String subjectCode,String subjectName,Long projectId,Integer costType);

    List<CostAmountVO> queryCostList(Long projectId);

    CostAmountVO queryCostSumMny(Long projectId);

    CostStatisticVO queryBudgetSumMny(Long projectId);
}
