package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.ApprovmentEntity;
import com.ejianc.business.cost.bean.ClaimEntity;
import com.ejianc.business.cost.mapper.ApprovmentMapper;
import com.ejianc.business.cost.service.IApprovmentService;
import com.ejianc.business.cost.service.IClaimService;
import com.ejianc.business.cost.vo.ApprovmentVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 甲方批复
 *
 * @author generator
 *
 */
@Service("approvmentService")
public class ApprovmentServiceImpl extends BaseServiceImpl<ApprovmentMapper, ApprovmentEntity> implements IApprovmentService{

    private static final String BILL_CODE = "COST_APPROVMENT";

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public ApprovmentVO queryByAdd(Long claimId) {
        ClaimEntity claimEntity = claimService.selectById(claimId);
        LambdaQueryWrapper<ApprovmentEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ApprovmentEntity::getClaimId, claimId);
        queryWrapper.in(ApprovmentEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.orderByDesc(ApprovmentEntity::getOccurDate);
        queryWrapper.last("limit 1");
        ApprovmentEntity entity = getOne(queryWrapper);
        ApprovmentVO vo = null;
        if (null != entity) {
            vo = BeanMapper.map(entity, ApprovmentVO.class);
            vo.setId(IdWorker.getId());
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()),"BT240611000000004","linkFile", String.valueOf(vo.getId()), "BT240611000000004","linkFile");
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()),"BT240611000000004","imageFile", String.valueOf(vo.getId()), "BT240611000000004","imageFile");
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()),"BT240611000000004","signFile", String.valueOf(vo.getId()), "BT240611000000004","signFile");
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()),"BT240611000000004","priceFile", String.valueOf(vo.getId()), "BT240611000000004","priceFile");
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()),"BT240611000000004","qualityFile", String.valueOf(vo.getId()), "BT240611000000004","qualityFile");
        }else {
            vo = BeanMapper.map(claimEntity, ApprovmentVO.class);
            vo.setId(IdWorker.getId());
        }
        vo.setBillCode(null);
        vo.setClaimId(claimId);
        vo.setClaimCode(claimEntity.getBillCode());
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setVersion(null);
        vo.setMemo(null);
        vo.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        return vo;
    }

    @Override
    public ApprovmentVO saveOrUpdate(ApprovmentVO saveOrUpdateVO) {
        LambdaQueryWrapper<ApprovmentEntity> qry = new LambdaQueryWrapper<>();
        qry.ne(null != saveOrUpdateVO.getId(), ApprovmentEntity::getId, saveOrUpdateVO.getId());
        qry.eq(ApprovmentEntity::getClaimId, saveOrUpdateVO.getClaimId());
        qry.notIn(ApprovmentEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        ApprovmentEntity proEntity = getOne(qry, false);
        if (null != proEntity) {
            throw new BusinessException("存在未生效的批复单" + proEntity.getBillCode() + ",不允许再次新增!");
        }
        ApprovmentEntity entity = BeanMapper.map(saveOrUpdateVO, ApprovmentEntity.class);
        if (StringUtils.isEmpty(entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        saveOrUpdate(entity, false);
        ApprovmentVO vo = BeanMapper.map(entity, ApprovmentVO.class);
        if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(entity.getBillState())) {
            Integer lockState = null;
            CommonResponse<List<AttachmentVO>> response = attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
            if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                Set<String> stringSet = response.getData().stream().map(AttachmentVO::getSourceType).collect(Collectors.toSet());
                if(stringSet.contains("linkFile") && stringSet.contains("imageFile") && stringSet.contains("signFile") && stringSet.contains("priceFile") && stringSet.contains("qualityFile")){
                    lockState = 2;
                }else if(stringSet.contains("linkFile") && stringSet.contains("imageFile") && stringSet.contains("signFile")){
                    lockState = 1;
                }
            }
            LambdaUpdateWrapper<ApprovmentEntity> update = Wrappers.lambdaUpdate();
            update.eq(ApprovmentEntity::getId, entity.getId());
            update.set(ApprovmentEntity::getLockState, lockState);
            update(update);
            vo.setLockState(lockState);
        }
        return vo;
    }
}
