package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.cost.bean.CostDetailEntity;
import com.ejianc.business.cost.mapper.CostDetailMapper;
import com.ejianc.business.cost.service.ICostDetailService;
import com.ejianc.business.cost.vo.CostSquareChartVO;
import com.ejianc.business.cost.vo.ProjectReportVo;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

/**
 * 数据明细表
 * 
 * @author generator
 * 
 */
@Service("costDetailService")
public class CostDetailServiceImpl extends BaseServiceImpl<CostDetailMapper, CostDetailEntity> implements ICostDetailService{
  @Resource private IBudgetProjectProService budgetProjectProService;
  @Resource private IIncomeContractApi incomeContractApi;

    @Override
    public boolean deleteCostDetail(Long id) {
        return baseMapper.deleteCostDetail(id);
    }

    @Override
    public List<ProjectReportVo> getCostMonth(Long projectId) {
        return baseMapper.getCostMonth(projectId);
    }

  @Override
  public LinkedHashMap<String, BigDecimal> costSquareChart(Long projectId) {
    Assert.notNull(projectId, "项目id不能为空");

    BigDecimal sumRgfCostMny = BigDecimal.ZERO; // 人工费
    BigDecimal sumJxfCostMny = BigDecimal.ZERO; // 机械费
    BigDecimal sumClfCostMny = BigDecimal.ZERO; // 材料费
    BigDecimal sumZyfbfCostMny = BigDecimal.ZERO; // 专业分包费
    BigDecimal sumOtherCostMny = BigDecimal.ZERO; // 其它费用

    BigDecimal sumContractMny; // 项目合同造价
    BigDecimal targetCostMny; // 项目目标成本
    BigDecimal sumAllCostMny; // 项目实际成本
    BigDecimal sumSettleMny; // 项目结算总价

    CostSquareChartVO costSquareChartVO = baseMapper.getSumClfCostMny(projectId);
    sumRgfCostMny = costSquareChartVO.getLaborTaxMnyCost();
    sumClfCostMny = costSquareChartVO.getMaterialTaxMnyCost();
    sumZyfbfCostMny = costSquareChartVO.getMajorTaxMnyCost();
    sumJxfCostMny = costSquareChartVO.getMechanicalTaxMnyCost();
    sumOtherCostMny = costSquareChartVO.getIndirectionTaxMnyCost();

    // 项目目标预算
    QueryWrapper<BudgetProjectProEntity> wrapper1 = Wrappers.query();
    wrapper1
        .select("ifnull(sum(budget_tax_mny), 0) as mny")
        .eq("dr", 0)
        .in("bill_state", 1, 3)
        .eq("project_id", projectId);
    Map<String, Object> map = budgetProjectProService.getMap(wrapper1);
    targetCostMny = new BigDecimal(map.get("mny").toString());

    // 项目实际成本
    sumAllCostMny = ComputeUtil.safeAdd(sumRgfCostMny, sumClfCostMny, sumZyfbfCostMny, sumJxfCostMny, sumOtherCostMny);

    // 项目合同造价
    // 工程结算总价
    CommonResponse<Map<String, BigDecimal>> response = incomeContractApi.costSquareChart(projectId);
    if (!response.isSuccess()) {
      throw new BusinessException("获取项目合同造价、工程结算总价失败");
    }
    Map<String, BigDecimal> data = response.getData();
    sumContractMny = data.get("sumContractMny");
    sumSettleMny = data.get("sumSettleMny");

    BigDecimal jjxyMny = ComputeUtil.safeSub(sumContractMny, targetCostMny); // 经营效益
    BigDecimal glxyMny = ComputeUtil.safeSub(targetCostMny, sumAllCostMny); // 管理效益
    BigDecimal jsxyMny = ComputeUtil.safeSub(sumSettleMny, sumContractMny); // 结算效益

    LinkedHashMap<String, BigDecimal> linkedHashMap = new LinkedHashMap<>();
    linkedHashMap.put("sumRgfCostTaxMny", sumRgfCostMny); // 人工费
    linkedHashMap.put("sumJxfCostTaxMny", sumJxfCostMny); // 机械费
    linkedHashMap.put("sumClfCostTaxMny", sumClfCostMny); // 材料费
    linkedHashMap.put("sumZyfbfCostTaxMny", sumZyfbfCostMny); // 专业分包费用
    linkedHashMap.put("sumOtherCostTaxMny", sumOtherCostMny); // 其他费
    linkedHashMap.put("sumContractTaxMny", sumContractMny); // 项目合同造价
    linkedHashMap.put("targetCostTaxMny", targetCostMny); // 项目目标成本
    linkedHashMap.put("sumAllCostTaxMny", sumAllCostMny); // 项目实际成本
    linkedHashMap.put("sumSettleTaxMny", sumSettleMny); // 项目结算总价
    linkedHashMap.put("jjxyTaxMny", jjxyMny); // 经营效益
    linkedHashMap.put("glxyTaxMny", glxyMny); // 管理效益
    linkedHashMap.put("jsxyTaxMny", jsxyMny); // 结算效益
    return linkedHashMap;
  }
}
