package com.ejianc.business.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.bean.CostDocumentsDetailEntity;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.CostDocumentsMapper;
import com.ejianc.business.cost.bean.CostDocumentsEntity;
import com.ejianc.business.cost.service.ICostDocumentsService;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

/**
 * 成本单据
 * 
 * @author generator
 * 
 */
@Service("costDocumentsService")
public class CostDocumentsServiceImpl extends BaseServiceImpl<CostDocumentsMapper, CostDocumentsEntity> implements ICostDocumentsService{
    @Autowired
    private SessionManager sessionManager;

    private static Logger logger = LoggerFactory.getLogger(CostDocumentsServiceImpl.class.getName());

    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Override
    public void processCost(CostDocumentsEntity entity) {
        if(ListUtil.isNotEmpty(entity.getCostDocumentsDetailList())){
            List<CostDetailVO> list = new ArrayList<>();
            boolean canPush = true;
            for (int i = 0;i<entity.getCostDocumentsDetailList().size();i++){
                CostDocumentsDetailEntity sub = entity.getCostDocumentsDetailList().get(i);
                if (null == sub.getSubjectId()) {
                    canPush = false;
                }
                CostDetailVO c = new CostDetailVO();
                c.setSubjectId(sub.getSubjectId());
                c.setSourceId(entity.getId());
                c.setSourceDetailId(sub.getId());
                c.setProjectId(entity.getProjectId());
                c.setHappenTaxMny(sub.getMny() == null ? new BigDecimal("0.00") : sub.getMny());
                c.setHappenMny(sub.getMny() == null ? new BigDecimal("0.00") : sub.getMny());
                c.setHappenDate(entity.getCostDate());
                c.setMemo(sub.getRemark());
                c.setCreateUserName(sessionManager.getUserContext().getUserName());
                c.setSourceType("COST_DOC");
                c.setSourceTabType("COST_DOC_DETAIL");
                String period = "";
                if(entity.getCostDate() != null){
                    SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM");
                    period = ft.format(entity.getCostDate());
                }
                // 费用类型 说明：依据自定义档案费用类型属性来传01间接费02其他费
                if ("01".equals(sub.getCostAttributeCode())) {
                    c.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
                    c.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName());
                } else if ("02".equals(sub.getCostAttributeCode())) {
                    c.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
                    c.setCostTypeName(CostTypeEnum.MECHANICAL_COST_TYPE.getName());
                }

                c.setPeriod(period); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
                c.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
                // c.setShareId(); // 归集单据id 说明：不用传
                c.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
                c.setSourceBillName("成本单据"); // 来源单据名称 说明：材料验收单
                c.setSourceBillUrl("/ejc-cost-frontend/#/costDocuments/card?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
                //c.setNum(sub.getInstoreNumber() == null ? BigDecimal.ZERO : sub.getInstoreNumber()); // 发生数量 说明：子表有数量的都传，包含分包清单工程量

                // 以下信息物资、设备、周转材档案类传
                //c.setMaterialId(sub.getMaterialId()); // 物资主键
                // c.setMaterialCode(sub.getMaterialCode()); // 物料编码
                //c.setMaterialName(sub.getMaterialName()); // 物资名称
                //c.setMaterialTypeId(sub.getMaterialCategoryId()); // 物资类别
                //c.setMaterialTypeName(sub.getMaterialCategoryName()); // 物资类别名称
                //c.setUnit(sub.getMaterialUnit()); // 单位名称
                // c.setUnitId(); // 单位主键
                //c.setSpec(sub.getMaterialSpec()); // 规格型号

                list.add(c);
            }
            logger.info("list=============>："+JSONObject.toJSONString(list));
            CommonResponse<String> response = iCostDetailApi.saveSubject(list);
            logger.info("推送成本成本单据结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            entity.setRelationFlag(canPush ? "1" : "0");
            // if(canPush){
            //     CommonResponse<String> response = iCostDetailApi.saveSubject(list);
            //     logger.info("推送成本"+MaterialStoreType.getStoreTypeNameByCode(entity.getInstoreType())+"结果:"+response.isSuccess()+" msg:"+response.getMsg()+" billId="+entity.getId());
            //     entity.setRelationFlag("1");
            // }else {
            //     CommonResponse<String> response = iCostDetailApi.deleteSubject(entity.getId());
            //     logger.info("删除成本"+MaterialStoreType.getStoreTypeNameByCode(entity.getInstoreType())+"结果:"+response.isSuccess()+" msg:"+response.getMsg()+" billId="+entity.getId());
            //     entity.setRelationFlag("0");
            // }
        }else {
            iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }

}
