package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

import com.ejianc.business.budget.vo.CostAmountVO;
import com.ejianc.business.cost.vo.CostStatisticDetailVO;
import com.ejianc.business.cost.vo.CostStatisticVO;
import com.ejianc.business.cost.vo.SubjectVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.SubjectMapper;
import com.ejianc.business.cost.bean.SubjectEntity;
import com.ejianc.business.cost.service.ISubjectService;

import java.util.List;

/**
 * 成本设置科目明细
 * 
 * @author generator
 * 
 */
@Service("subjectService")
public class SubjectServiceImpl extends BaseServiceImpl<SubjectMapper, SubjectEntity> implements ISubjectService{

    @Override
    public List<SubjectVO> geSubjects(QueryWrapper queryWrapper) {
        return baseMapper.geSubjects(queryWrapper);
    }

    @Override
    public List<CostStatisticDetailVO> queryCostStatist(String subjectCode,String subjectName,Long projectId,Integer costType) {
        return baseMapper.queryCostStatist(subjectCode,subjectName,projectId,costType);
    }

    @Override
    public List<CostAmountVO> queryCostList(Long projectId) {
        return baseMapper.queryCostList(projectId);
    }

    @Override
    public CostAmountVO queryCostSumMny(Long projectId) {
        return baseMapper.queryCostSumMny(projectId);
    }

    @Override
    public CostStatisticVO queryBudgetSumMny(Long projectId) {
        return baseMapper.queryBudgetSumMny(projectId);
    }
}
