/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetEntity;
import com.ejianc.business.budget.bean.BudgetSetTypeEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetSetDetailService;
import com.ejianc.business.budget.service.IBudgetSetService;
import com.ejianc.business.budget.service.IBudgetSetTypeService;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.business.budget.vo.BudgetSetTypeVO;
import com.ejianc.business.budget.vo.BudgetSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetSet"})
public class BudgetSetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IBudgetSetService service;
    @Autowired
    private IBudgetSetDetailService budgetSetDetailService;
    @Autowired
    private IBudgetProjectDetailService budgetProjectDetailService;
    @Autowired
    private IBudgetSetTypeService budgetSetTypeService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetSetVO> saveOrUpdate(@RequestBody BudgetSetVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveOrUpdateVO));
    }

    @RequestMapping(value={"/copySave"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetSetVO> copySave(@RequestBody BudgetSetVO budgetSetVO) {
        return CommonResponse.success((String)"\u590d\u5236\u5355\u636e\u6210\u529f\uff01", (Object)this.service.copySave(budgetSetVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetSetVO> queryDetail(Long id) {
        BudgetSetEntity entity = (BudgetSetEntity)((Object)this.service.selectById(id));
        BudgetSetVO vo = (BudgetSetVO)BeanMapper.map((Object)((Object)entity), BudgetSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetSetVO> vos) {
        List mainIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper qry = new LambdaQueryWrapper();
        qry.in(BudgetSetDetailEntity::getSetId, mainIds);
        List detailIds = null;
        List list = this.budgetSetDetailService.list((Wrapper)qry);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            detailIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(BudgetProjectDetailEntity::getSetDetailId, detailIds);
            if (this.budgetProjectDetailService.count((Wrapper)queryWrapper) > 0) {
                throw new BusinessException("\u6240\u9009\u6e05\u5355\u5b9a\u989d\u5173\u7cfb\u8bbe\u7f6e\u88ab[\u9879\u76ee\u9884\u7b97\u4e66]\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!");
            }
        }
        this.service.removeByIds(mainIds, true);
        if (CollectionUtils.isNotEmpty(detailIds)) {
            this.budgetSetDetailService.removeByIds(detailIds, true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetSetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetSet-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBudgetSetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetSetVO>> refBudgetSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateEnable"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateEnable(Long id, Boolean enableState) {
        if (enableState.booleanValue()) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            queryWrapper.ne(BaseEntity::getId, (Object)id);
            queryWrapper.eq(BudgetSetEntity::getEnableState, (Object)1);
            BudgetSetEntity budgetSetEntity = (BudgetSetEntity)((Object)this.service.getOne((Wrapper)queryWrapper, false));
            if (null != budgetSetEntity) {
                budgetSetEntity.setEnableState(0);
                this.service.saveOrUpdate((Object)budgetSetEntity);
            }
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(BudgetSetEntity::getEnableState, (Object)enableState);
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u66f4\u65b0\u542f\u7528\u505c\u7528\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/refBudgetSetType"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BudgetSetTypeVO> refBudgetSetType(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        List typeList = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BudgetSetEntity::getEnableState, (Object)1);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        BudgetSetEntity setEntity = (BudgetSetEntity)((Object)this.service.getOne((Wrapper)queryWrapper, false));
        if (null != setEntity) {
            List resList;
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BudgetSetTypeEntity::getSetId, (Object)setEntity.getId());
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                lambda.like(BudgetSetTypeEntity::getTypeName, (Object)searchText);
            }
            if (CollectionUtils.isNotEmpty((Collection)(resList = this.budgetSetTypeService.list((Wrapper)lambda)))) {
                typeList = BeanMapper.mapList((Iterable)resList, BudgetSetTypeVO.class);
                typeList.forEach(e -> {
                    e.setCode(e.getTypeCode());
                    e.setName(e.getTypeName());
                });
            }
        }
        return typeList;
    }

    @RequestMapping(value={"/refBudgetSetDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetSetDetailVO>> refQuotaDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(required=false) String relyCondition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.getFuzzyFields().addAll(Arrays.asList("detailCode", "detailName", "description"));
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BudgetSetEntity::getEnableState, (Object)1);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        BudgetSetEntity setEntity = (BudgetSetEntity)((Object)this.service.getOne((Wrapper)queryWrapper, false));
        Long setId = 1L;
        if (null != setEntity) {
            setId = setEntity.getId();
        }
        param.getParams().put("setId", new Parameter("eq", (Object)setId));
        Long setTypeId = null;
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            setTypeId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("setTypeId", new Parameter("eq", (Object)setTypeId));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"setTypeId")) {
            setTypeId = Long.valueOf(String.valueOf(_con.get((Object)"setTypeId")));
            param.getParams().put("setTypeId", new Parameter("eq", (Object)setTypeId));
        }
        IPage page = this.budgetSetDetailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List detailVOS = BeanMapper.mapList((Iterable)page.getRecords(), BudgetSetDetailVO.class);
        pageData.setRecords(detailVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

