/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectChangeProEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailChangeProEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailHistoryProEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectHistoryProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.bean.QuotaDetailTemporaryEntity;
import com.ejianc.business.budget.mapper.BudgetProjectChangeProMapper;
import com.ejianc.business.budget.mapper.BudgetProjectProMapper;
import com.ejianc.business.budget.service.IBudgetProjectChangeProService;
import com.ejianc.business.budget.service.IBudgetProjectDetailChangeProService;
import com.ejianc.business.budget.service.IBudgetProjectDetailHistoryProService;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectHistoryProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.service.IQuotaDetailTemporaryService;
import com.ejianc.business.budget.vo.BudgetProjectHistoryProVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectChangePro")
public class BudgetProjectChangeProBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private BudgetProjectChangeProMapper changeMapper;
    @Autowired
    private IBudgetProjectProService budgetProjectProService;
    @Autowired
    private BudgetProjectProMapper budgetMapper;
    @Autowired
    private IBudgetProjectHistoryProService historyProService;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;
    @Autowired
    private IBudgetProjectChangeProService changeProService;
    @Autowired
    private IBudgetProjectDetailHistoryProService budgetProjectDetailHistoryProService;
    @Autowired
    private IBudgetProjectProService budgetProService;
    @Autowired
    private IBudgetProjectDetailChangeProService budgetProjectDetailChangeProService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IQuotaDetailTemporaryService quotaDetailTemporaryService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PARAM_TEMP_LBOR_CODE = "P-7d32tl03";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return this.beforeSubmitCheck(billId);
    }

    private CommonResponse<String> beforeSubmitCheck(Long billId) {
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BudgetProjectDetailChangeProEntity::getBudgetChangeId, (Object)billId);
        lambdaQuery.eq(BudgetProjectDetailChangeProEntity::getLeafFlag, (Object)1);
        lambdaQuery.and(t -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.isNull(BudgetProjectDetailChangeProEntity::getNum)).or()).isNull(BudgetProjectDetailChangeProEntity::getPrice));
        List list = this.budgetProjectDetailChangeProService.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BudgetProjectDetailChangeProEntity detailProEntity = (BudgetProjectDetailChangeProEntity)((Object)list.get(0));
            return CommonResponse.error((String)("\u6210\u672c\u6e05\u5355\u3010\u7f16\u7801\uff1a" + detailProEntity.getCode() + "\uff0c\u540d\u79f0\uff1a" + detailProEntity.getName() + "\u3011\u7684\u5de5\u7a0b\u91cf\u548c\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        CommonResponse byCodeLabor = this.paramConfigApi.getByCode(PARAM_TEMP_LBOR_CODE);
        if (byCodeLabor.isSuccess() && null != byCodeLabor.getData() && StringUtils.isNotEmpty((CharSequence)(valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCodeLabor.getData()).getValueData())) && valueData.equals("\u5426")) {
            LambdaQueryWrapper detailProEntityLambdaQueryWrapper = new LambdaQueryWrapper();
            detailProEntityLambdaQueryWrapper.eq(BudgetProjectDetailChangeProEntity::getBudgetId, (Object)billId);
            detailProEntityLambdaQueryWrapper.eq(BudgetProjectDetailChangeProEntity::getCostType, (Object)CostTypeEnum.LABOR_COST_TYPE.getType());
            detailProEntityLambdaQueryWrapper.isNull(BudgetProjectDetailChangeProEntity::getSourceId);
            List matchList = this.budgetProjectDetailChangeProService.list((Wrapper)detailProEntityLambdaQueryWrapper);
            ArrayList<String> detailIndexList = new ArrayList<String>();
            for (BudgetProjectDetailChangeProEntity detailProEntity : matchList) {
                detailIndexList.add(detailProEntity.getDetailIndex());
            }
            if (!detailIndexList.isEmpty()) {
                String detailIndexStr = String.join((CharSequence)",", detailIndexList);
                return CommonResponse.error((String)("\u6821\u9a8c\u5931\u8d25(\u6709" + detailIndexList.size() + "\u6761\u65b0\u589e\u4eba\u5de5\u8d39\u4e34\u65f6\u5b9a\u989d)\uff0c\u5e8f\u53f7\u4e3a[ " + detailIndexStr + " ]\uff0c\u53c2\u6570\u3010\u4e34\u65f6\u5b9a\u989d\u5e93\u662f\u5426\u5f00\u542f\u3011\u672a\u5f00\u542f\uff0c\u8bf7\u5c06\u65b0\u589e\u4e34\u65f6\u5b9a\u989d\u5904\u7406\u540e\u91cd\u65b0\u64cd\u4f5c\uff01"));
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (0 == state) {
            return this.beforeSubmitCheck(billId);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        Date effectiveDate = new Date();
        BudgetProjectChangeProEntity changeEntity = (BudgetProjectChangeProEntity)((Object)this.changeProService.selectById(billId));
        LambdaUpdateWrapper projectChangeProEntityLambdaUpdateWrapper = new LambdaUpdateWrapper();
        projectChangeProEntityLambdaUpdateWrapper.eq(BaseEntity::getId, (Object)billId);
        projectChangeProEntityLambdaUpdateWrapper.set(BudgetProjectChangeProEntity::getEffectiveDate, (Object)effectiveDate);
        this.changeProService.update((Wrapper)projectChangeProEntityLambdaUpdateWrapper);
        BudgetProjectProEntity budgetEntity = (BudgetProjectProEntity)((Object)this.budgetProjectProService.selectById(changeEntity.getBudgetId()));
        BudgetProjectHistoryProEntity historyEntity = (BudgetProjectHistoryProEntity)((Object)BeanMapper.map((Object)((Object)budgetEntity), BudgetProjectHistoryProEntity.class));
        BudgetProjectHistoryProVO projectHistoryProVO = (BudgetProjectHistoryProVO)BeanMapper.map((Object)((Object)historyEntity), BudgetProjectHistoryProVO.class);
        BillCodeParam billCodeParam = BillCodeParam.build((String)"PROJECT_BUDGET_PRO_HIS_CODE", (Long)InvocationInfoProxy.getTenantid(), (BaseVO)projectHistoryProVO);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (billCode.isSuccess()) {
            historyEntity.setBillCode((String)billCode.getData());
        }
        historyEntity.setBudgetId(changeEntity.getBudgetId());
        historyEntity.setId(null);
        historyEntity.setCreateUserCode(null);
        historyEntity.setCreateTime(changeEntity.getCreateTime());
        historyEntity.setVersion(null);
        historyEntity.setUpdateTime(null);
        historyEntity.setUpdateUserCode(null);
        historyEntity.setChangeCode(changeEntity.getBillCode());
        historyEntity.setChangeReason(changeEntity.getChangeReason());
        historyEntity.setEffectiveDate(effectiveDate);
        List<BudgetProjectDetailHistoryProEntity> historyDetailList = historyEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(historyDetailList)) {
            for (BudgetProjectDetailHistoryProEntity historyProEntity : historyDetailList) {
                historyProEntity.setBudgetId(budgetEntity.getId());
                historyProEntity.setBudgetDetailId(historyProEntity.getId());
                historyProEntity.setId(null);
            }
        }
        this.historyProService.saveOrUpdate((Object)historyEntity, false);
        List<BudgetProjectDetailHistoryProEntity> historyProDetailList = historyEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(historyProDetailList)) {
            Map<Long, BudgetProjectDetailHistoryProEntity> historyDetailMap = historyProDetailList.stream().collect(Collectors.toMap(k -> k.getBudgetDetailId(), k -> k));
            for (BudgetProjectDetailHistoryProEntity historyProEntity : historyProDetailList) {
                if (historyProEntity.getParentId() == null || historyDetailMap.get(historyProEntity.getParentId()) == null) continue;
                historyProEntity.setParentId(historyDetailMap.get(historyProEntity.getParentId()).getId());
            }
            this.budgetProjectDetailHistoryProService.saveOrUpdateBatch(historyProDetailList, historyProDetailList.size());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getBudgetId());
        updateWrapper.set(BudgetProjectProEntity::getBudgetTaxMny, (Object)changeEntity.getBudgetTaxMny());
        updateWrapper.set(BudgetProjectProEntity::getBudgetMny, (Object)changeEntity.getBudgetMny());
        updateWrapper.set(BudgetProjectProEntity::getIndirectionTaxMny, (Object)changeEntity.getIndirectionTaxMny());
        updateWrapper.set(BudgetProjectProEntity::getIndirectionMny, (Object)changeEntity.getIndirectionMny());
        updateWrapper.set(BudgetProjectProEntity::getLaborTaxMny, (Object)changeEntity.getLaborTaxMny());
        updateWrapper.set(BudgetProjectProEntity::getLaborMny, (Object)changeEntity.getLaborMny());
        updateWrapper.set(BudgetProjectProEntity::getMajorTaxMny, (Object)changeEntity.getMajorTaxMny());
        updateWrapper.set(BudgetProjectProEntity::getMajorMny, (Object)changeEntity.getMajorMny());
        updateWrapper.set(BudgetProjectProEntity::getMaterialTaxMny, (Object)changeEntity.getMaterialTaxMny());
        updateWrapper.set(BudgetProjectProEntity::getMaterialMny, (Object)changeEntity.getMaterialMny());
        updateWrapper.set(BudgetProjectProEntity::getChangeId, (Object)changeEntity.getId());
        updateWrapper.set(BudgetProjectProEntity::getChangeStatus, (Object)3);
        updateWrapper.set(BudgetProjectProEntity::getChangeCode, (Object)changeEntity.getBillCode());
        updateWrapper.set(BudgetProjectProEntity::getChangeReason, (Object)changeEntity.getChangeReason());
        updateWrapper.set(BudgetProjectProEntity::getChangeVersion, (Object)changeEntity.getVersion());
        updateWrapper.set(BudgetProjectProEntity::getMechanicalTaxMny, (Object)changeEntity.getMechanicalTaxMny());
        updateWrapper.set(BudgetProjectProEntity::getMechanicalMny, (Object)changeEntity.getMechanicalMny());
        updateWrapper.set(BudgetProjectProEntity::getSporadicMaterialMny, (Object)changeEntity.getSporadicMaterialMny());
        this.budgetProjectProService.update((Wrapper)updateWrapper);
        List<BudgetProjectDetailChangeProEntity> changeDetailList = changeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            ArrayList<QuotaDetailTemporaryEntity> quotaDetailTemporaryEntities = new ArrayList<QuotaDetailTemporaryEntity>();
            for (BudgetProjectDetailChangeProEntity budgetProjectDetailChangeProEntity : changeDetailList) {
                if (!CostTypeEnum.LABOR_COST_TYPE.getType().equals(budgetProjectDetailChangeProEntity.getCostType()) || budgetProjectDetailChangeProEntity.getSourceId() != null) continue;
                QuotaDetailTemporaryEntity quotaDetailTemporaryEntity = new QuotaDetailTemporaryEntity();
                quotaDetailTemporaryEntity.setCreateTime(effectiveDate);
                quotaDetailTemporaryEntity.setPushFlag(0);
                quotaDetailTemporaryEntity.setSourceProjectId(changeEntity.getProjectId());
                quotaDetailTemporaryEntity.setSourceProjectName(changeEntity.getProjectName());
                quotaDetailTemporaryEntity.setSourceBillId(changeEntity.getId());
                quotaDetailTemporaryEntity.setSourceBillDetailId(budgetProjectDetailChangeProEntity.getId());
                quotaDetailTemporaryEntity.setSourceBillCode(changeEntity.getBillCode());
                quotaDetailTemporaryEntity.setSourceBillName("\u76ee\u6807\u6210\u672c\u53d8\u66f4");
                quotaDetailTemporaryEntity.setDetailCode(StringUtils.trim((String)budgetProjectDetailChangeProEntity.getCode()));
                quotaDetailTemporaryEntity.setDetailName(StringUtils.trim((String)budgetProjectDetailChangeProEntity.getName()));
                quotaDetailTemporaryEntity.setDetailUnit(budgetProjectDetailChangeProEntity.getUnit());
                quotaDetailTemporaryEntity.setDescription(budgetProjectDetailChangeProEntity.getSpec());
                quotaDetailTemporaryEntity.setLaborPrice(budgetProjectDetailChangeProEntity.getPrice());
                quotaDetailTemporaryEntities.add(quotaDetailTemporaryEntity);
            }
            if (CollectionUtils.isNotEmpty(quotaDetailTemporaryEntities)) {
                this.quotaDetailTemporaryService.saveOrUpdateBatch(quotaDetailTemporaryEntities);
                Map<Long, QuotaDetailTemporaryEntity> tempMap = quotaDetailTemporaryEntities.stream().collect(Collectors.toMap(QuotaDetailTemporaryEntity::getSourceBillDetailId, person -> person));
                for (BudgetProjectDetailChangeProEntity detailChangeProEntity : changeDetailList) {
                    Long id;
                    QuotaDetailTemporaryEntity temporaryEntity;
                    if (!tempMap.containsKey(detailChangeProEntity.getId()) || !CostTypeEnum.LABOR_COST_TYPE.getType().equals(detailChangeProEntity.getCostType()) || detailChangeProEntity.getSourceId() != null || (temporaryEntity = tempMap.get(id = detailChangeProEntity.getId())) == null) continue;
                    detailChangeProEntity.setSourceId(temporaryEntity.getId());
                }
                this.budgetProjectDetailChangeProService.saveOrUpdateBatch(changeDetailList);
            }
            ArrayList<BudgetProjectDetailProEntity> addOrUpdateList = new ArrayList<BudgetProjectDetailProEntity>();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            List<BudgetProjectDetailProEntity> detailList = budgetEntity.getDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                Map<Long, BudgetProjectDetailProEntity> detailMap = detailList.stream().collect(Collectors.toMap(k -> k.getId(), k -> k));
                Map<Long, BudgetProjectDetailChangeProEntity> changeDetailMap = changeDetailList.stream().collect(Collectors.toMap(k -> k.getId(), k -> k));
                for (BudgetProjectDetailChangeProEntity detailChangeProEntity : changeDetailList) {
                    if (detailMap.containsKey(detailChangeProEntity.getBudgetDetailId())) {
                        BudgetProjectDetailProEntity detailProEntity = detailMap.get(detailChangeProEntity.getBudgetDetailId());
                        if (detailProEntity == null) continue;
                        BudgetProjectDetailProEntity entity = (BudgetProjectDetailProEntity)((Object)BeanMapper.map((Object)((Object)detailChangeProEntity), BudgetProjectDetailProEntity.class));
                        entity.setChangeId(changeEntity.getId());
                        entity.setChangeBid(detailChangeProEntity.getId());
                        entity.setId(detailProEntity.getId());
                        entity.setParentId(detailProEntity.getParentId());
                        entity.setVersion(detailProEntity.getVersion());
                        addOrUpdateList.add(entity);
                        detailMap.remove(detailChangeProEntity.getBudgetDetailId());
                        continue;
                    }
                    BudgetProjectDetailProEntity entity = (BudgetProjectDetailProEntity)((Object)BeanMapper.map((Object)((Object)detailChangeProEntity), BudgetProjectDetailProEntity.class));
                    if (entity.getParentId() != null && changeDetailMap.get(entity.getParentId()) != null && changeDetailMap.get(entity.getParentId()).getBudgetDetailId() != null) {
                        entity.setParentId(changeDetailMap.get(entity.getParentId()).getBudgetDetailId());
                    }
                    entity.setChangeId(changeEntity.getId());
                    entity.setChangeBid(detailChangeProEntity.getId());
                    entity.setVersion(0);
                    entity.setBudgetId(budgetEntity.getId());
                    addOrUpdateList.add(entity);
                }
                if (!detailMap.isEmpty()) {
                    arrayList.addAll(detailMap.keySet());
                }
                if (CollectionUtils.isNotEmpty(arrayList)) {
                    this.budgetProjectDetailProService.removeByIds(arrayList, true);
                }
                if (CollectionUtils.isNotEmpty(addOrUpdateList)) {
                    this.budgetProjectDetailProService.saveOrUpdateBatch(addOrUpdateList, addOrUpdateList.size());
                }
            } else {
                List detailProEntityList = BeanMapper.mapList(changeDetailList, BudgetProjectDetailProEntity.class);
                for (BudgetProjectDetailProEntity budgetProjectDetailProEntity : detailProEntityList) {
                    budgetProjectDetailProEntity.setChangeId(changeEntity.getId());
                    budgetProjectDetailProEntity.setChangeBid(changeEntity.getId());
                    budgetProjectDetailProEntity.setBudgetId(budgetEntity.getId());
                    budgetProjectDetailProEntity.setId(null);
                    budgetProjectDetailProEntity.setVersion(0);
                }
                this.budgetProjectDetailProService.saveOrUpdateBatch(detailProEntityList);
            }
        } else {
            List<BudgetProjectDetailProEntity> detailList = budgetEntity.getDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                this.budgetProjectDetailProService.removeByIds(detailList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
            }
        }
        Long budgetId = budgetEntity.getId();
        this.budgetProService.pushCostSetting(budgetId);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u53d8\u66f4\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

