/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.budget.bean.BudgetSetDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetFeaturesEntity;
import com.ejianc.business.budget.bean.BudgetSetQuotaEntity;
import com.ejianc.business.budget.bean.QuotaDetailEntity;
import com.ejianc.business.budget.mapper.BudgetSetDetailMapper;
import com.ejianc.business.budget.service.IBudgetSetDetailService;
import com.ejianc.business.budget.service.IBudgetSetFeaturesService;
import com.ejianc.business.budget.service.IBudgetSetQuotaService;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.business.budget.vo.BudgetSetFeaturesVO;
import com.ejianc.business.budget.vo.BudgetSetImportVO;
import com.ejianc.business.budget.vo.BudgetSetQuotaVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="budgetSetDetailService")
public class BudgetSetDetailServiceImpl
extends BaseServiceImpl<BudgetSetDetailMapper, BudgetSetDetailEntity>
implements IBudgetSetDetailService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IQuotaDetailService quotaDetailService;
    @Autowired
    private IBudgetSetQuotaService budgetSetQuotaService;
    @Autowired
    private IBudgetSetFeaturesService budgetSetFeaturesService;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        Long setId = Long.valueOf(request.getParameter("setId"));
        Long setTypeId = Long.valueOf(request.getParameter("setTypeId"));
        this.logger.info("\u5f00\u59cb\u5bfc\u5165--" + setId);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<BudgetSetImportVO> allSuccessList = new ArrayList<BudgetSetImportVO>();
        ArrayList<BudgetSetImportVO> successList = new ArrayList<BudgetSetImportVO>();
        ArrayList<BudgetSetImportVO> errorList = new ArrayList<BudgetSetImportVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList quotaCodeList = new ArrayList();
            Map<Object, Object> map = new HashMap();
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(6)))) continue;
                quotaCodeList.add(datas.get(6));
            }
            if (CollectionUtils.isNotEmpty(quotaCodeList)) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.in(QuotaDetailEntity::getDetailCode, quotaCodeList);
                List quotaList = this.quotaDetailService.list((Wrapper)queryWrapper);
                map = quotaList.stream().collect(Collectors.toMap(QuotaDetailEntity::getDetailCode, Function.identity(), (oldValue, newValue) -> newValue));
                this.logger.info("\u6750\u6599map\u4fe1\u606f--" + JSONObject.toJSONString(map));
            }
            Long lastDetailId = null;
            for (int i = 1; i < result.size(); ++i) {
                Iterator errMsg = new StringBuffer();
                boolean errflag = false;
                List datas = (List)result.get(i);
                BudgetSetImportVO importVO = new BudgetSetImportVO();
                importVO.setMatFlag(Boolean.valueOf(false));
                importVO.setId(Long.valueOf(IdWorker.getId()));
                importVO.setSetId(setId);
                importVO.setSetTypeId(setTypeId);
                String detailCode = (String)datas.get(0);
                if (StringUtils.isEmpty((CharSequence)detailCode)) {
                    if (lastDetailId == null) {
                        ((StringBuffer)((Object)errMsg)).append("\u6e05\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,");
                        errflag = true;
                    } else {
                        importVO.setMatFlag(Boolean.valueOf(true));
                    }
                } else {
                    importVO.setDetailCode(detailCode);
                }
                if (BooleanUtils.isFalse((Boolean)importVO.getMatFlag())) {
                    String detailName = (String)datas.get(1);
                    if (StringUtils.isEmpty((CharSequence)detailName)) {
                        ((StringBuffer)((Object)errMsg)).append("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a,");
                        errflag = true;
                    } else {
                        importVO.setDetailName(detailName);
                    }
                    String description = (String)datas.get(2);
                    if (StringUtils.isEmpty((CharSequence)description)) {
                        ((StringBuffer)((Object)errMsg)).append("\u7279\u5f81\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a,");
                        errflag = true;
                    } else {
                        importVO.setDescription(description);
                    }
                    importVO.setFeatures((String)datas.get(3));
                    importVO.setDetailUnit((String)datas.get(4));
                    String detailNum = (String)datas.get(5);
                    if (StringUtils.isEmpty((CharSequence)detailNum)) {
                        ((StringBuffer)((Object)errMsg)).append("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a,");
                        errflag = true;
                    } else {
                        try {
                            importVO.setDetailNum(StringUtils.isNotBlank((CharSequence)detailNum) ? new BigDecimal(detailNum) : null);
                        }
                        catch (Exception e) {
                            ((StringBuffer)((Object)errMsg)).append("\u5de5\u7a0b\u91cf\u683c\u5f0f\u9519\u8bef,");
                            errflag = true;
                        }
                    }
                }
                BudgetSetImportVO importSetVO = null;
                String quotaCode = (String)datas.get(6);
                if (BooleanUtils.isTrue((Boolean)importVO.getMatFlag()) && StringUtils.isBlank((CharSequence)quotaCode)) {
                    ((StringBuffer)((Object)errMsg)).append("\u5b9a\u989d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,");
                    errflag = true;
                } else if (StringUtils.isNotBlank((CharSequence)quotaCode)) {
                    String quotaNum;
                    QuotaDetailEntity detailEntity = (QuotaDetailEntity)((Object)map.get(quotaCode));
                    if (BooleanUtils.isFalse((Boolean)importVO.getMatFlag())) {
                        importSetVO = new BudgetSetImportVO();
                        importSetVO.setMatFlag(Boolean.valueOf(true));
                        importSetVO.setId(Long.valueOf(IdWorker.getId()));
                        importSetVO.setSetId(setId);
                        importSetVO.setSetTypeId(setTypeId);
                        if (detailEntity != null) {
                            importSetVO.setSetDetailId(importVO.getId());
                            importSetVO.setQuotaId(detailEntity.getId());
                            importSetVO.setQuotaCode(detailEntity.getDetailCode());
                            importSetVO.setQuotaName(detailEntity.getDetailName());
                            importSetVO.setQuotaDescription(detailEntity.getDescription());
                            importSetVO.setQuotaMatName(detailEntity.getMatName());
                            importSetVO.setQuotaUnit(detailEntity.getDetailUnit());
                        } else {
                            ((StringBuffer)((Object)errMsg)).append("\u5b9a\u989d\u7f16\u7801\u672a\u5339\u914d\u5230\u5b9a\u989d\u5e93,");
                            errflag = true;
                        }
                        quotaNum = (String)datas.get(10);
                        if (StringUtils.isBlank((CharSequence)quotaNum)) {
                            ((StringBuffer)((Object)errMsg)).append("\u5b9a\u989d\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a,");
                            errflag = true;
                        } else {
                            try {
                                importSetVO.setQuotaNum(StringUtils.isNotBlank((CharSequence)quotaNum) ? new BigDecimal(quotaNum) : null);
                            }
                            catch (Exception e) {
                                ((StringBuffer)((Object)errMsg)).append("\u5b9a\u989d\u5de5\u7a0b\u91cf\u683c\u5f0f\u9519\u8bef,");
                                errflag = true;
                            }
                        }
                    } else {
                        if (detailEntity != null) {
                            importVO.setSetDetailId(lastDetailId);
                            importVO.setQuotaId(detailEntity.getId());
                            importVO.setQuotaCode(detailEntity.getDetailCode());
                            importVO.setQuotaName(detailEntity.getDetailName());
                            importVO.setQuotaDescription(detailEntity.getDescription());
                            importVO.setQuotaMatName(detailEntity.getMatName());
                            importVO.setQuotaUnit(detailEntity.getDetailUnit());
                        } else {
                            ((StringBuffer)((Object)errMsg)).append("\u5b9a\u989d\u7f16\u7801\u672a\u5339\u914d\u5230\u5b9a\u989d\u5e93,");
                            errflag = true;
                        }
                        quotaNum = (String)datas.get(10);
                        if (StringUtils.isBlank((CharSequence)quotaNum)) {
                            ((StringBuffer)((Object)errMsg)).append("\u5b9a\u989d\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a,");
                            errflag = true;
                        } else {
                            try {
                                importVO.setQuotaNum(StringUtils.isNotBlank((CharSequence)quotaNum) ? new BigDecimal(quotaNum) : null);
                            }
                            catch (Exception e) {
                                ((StringBuffer)((Object)errMsg)).append("\u5b9a\u989d\u5de5\u7a0b\u91cf\u683c\u5f0f\u9519\u8bef,");
                                errflag = true;
                            }
                        }
                    }
                }
                if (errflag) {
                    importVO.setErrorMsg(((StringBuffer)((Object)errMsg)).substring(0, ((StringBuffer)((Object)errMsg)).length() - 1));
                    errorList.add(importVO);
                } else {
                    successList.add(importVO);
                    allSuccessList.add(importVO);
                    if (null != importSetVO) {
                        allSuccessList.add(importSetVO);
                    }
                }
                if (!BooleanUtils.isFalse((Boolean)importVO.getMatFlag())) continue;
                lastDetailId = importVO.getId();
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        if (CollectionUtils.isEmpty(errorList)) {
            ArrayList<BudgetSetDetailVO> detailVOS = new ArrayList<BudgetSetDetailVO>();
            ArrayList<BudgetSetQuotaVO> quotaVOS = new ArrayList<BudgetSetQuotaVO>();
            ArrayList<BudgetSetFeaturesVO> featuresVOS = new ArrayList<BudgetSetFeaturesVO>();
            HashMap quotaNameMap = new HashMap();
            for (BudgetSetImportVO importVO : allSuccessList) {
                if (BooleanUtils.isFalse((Boolean)importVO.getMatFlag())) {
                    BudgetSetDetailVO detailVO = (BudgetSetDetailVO)BeanMapper.map((Object)importVO, BudgetSetDetailVO.class);
                    detailVOS.add(detailVO);
                    continue;
                }
                BudgetSetQuotaVO setQuotaVO = (BudgetSetQuotaVO)BeanMapper.map((Object)importVO, BudgetSetQuotaVO.class);
                quotaVOS.add(setQuotaVO);
                ArrayList<String> matStrList = quotaNameMap.containsKey(setQuotaVO.getSetDetailId()) ? (List)quotaNameMap.get(setQuotaVO.getSetDetailId()) : new ArrayList<String>();
                matStrList.add(setQuotaVO.getQuotaName());
                quotaNameMap.put(setQuotaVO.getSetDetailId(), matStrList);
            }
            for (BudgetSetDetailVO detailVO : detailVOS) {
                String[] strings;
                if (quotaNameMap.containsKey(detailVO.getId())) {
                    List stringList = (List)quotaNameMap.get(detailVO.getId());
                    detailVO.setQuotaName(StringUtils.join((Iterable)stringList, (String)","));
                }
                if (!StringUtils.isNotBlank((CharSequence)detailVO.getFeatures())) continue;
                for (String str : strings = detailVO.getFeatures().split(";")) {
                    BudgetSetFeaturesVO featuresVO = new BudgetSetFeaturesVO();
                    featuresVO.setId(Long.valueOf(IdWorker.getId()));
                    featuresVO.setSetId(setId);
                    featuresVO.setSetTypeId(setTypeId);
                    featuresVO.setSetDetailId(detailVO.getId());
                    featuresVO.setFeaturesName(str);
                    featuresVOS.add(featuresVO);
                }
            }
            List resList = BeanMapper.mapList(detailVOS, BudgetSetDetailEntity.class);
            this.saveBatch(resList);
            List quotaEntities = BeanMapper.mapList(quotaVOS, BudgetSetQuotaEntity.class);
            this.budgetSetQuotaService.saveBatch(quotaEntities);
            List featuresEntities = BeanMapper.mapList(featuresVOS, BudgetSetFeaturesEntity.class);
            this.budgetSetFeaturesService.saveBatch(featuresEntities);
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f\uff01", (Object)json);
    }

    @Override
    public Integer countByNames(Long setId, List<String> names) {
        return ((BudgetSetDetailMapper)this.baseMapper).countByNames(setId, names);
    }

    @Override
    public List<BudgetSetDetailVO> queryByNames(Long setId, List<String> names) {
        return ((BudgetSetDetailMapper)this.baseMapper).queryByNames(setId, names);
    }
}

