/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public class HKDateUtil {
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));

    public static Date getExcelDate(String dateStr) {
        if (dateStr == null || dateStr.trim().isEmpty()) {
            throw new IllegalArgumentException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date date = null;
        boolean isNumeric = HKDateUtil.isDouble(dateStr);
        try {
            date = isNumeric ? HSSFDateUtil.getJavaDate((double)Double.parseDouble(dateStr)) : HKDateUtil.parseAndValidateDate(dateStr);
        }
        catch (Exception e) {
            throw new RuntimeException("\u9519\u8bef\u5904\u7406\u65e5\u671f: " + dateStr, e);
        }
        return date;
    }

    private static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static Date parseAndValidateDate(String s) throws ParseException {
        SimpleDateFormat dateFormat = DATE_FORMAT_THREAD_LOCAL.get();
        dateFormat.setLenient(false);
        return dateFormat.parse(s);
    }
}

