/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.CostDocumentsDetailEntity;
import com.ejianc.business.cost.bean.CostDocumentsEntity;
import com.ejianc.business.cost.service.ICostDocumentsDetailService;
import com.ejianc.business.cost.service.ICostDocumentsService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/costDocuments/"})
public class CostDocumentsApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDocumentsService costDocumentsService;
    @Autowired
    private ICostDocumentsDetailService documentsDetailService;

    @GetMapping(value={"queryFeeMny"})
    public CommonResponse<BigDecimal> queryFeeMny(@RequestParam(value="projectId") Long projectId, @RequestParam(value="feeTypeId") Long feeTypeId) {
        BigDecimal result = BigDecimal.ZERO;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(CostDocumentsEntity::getProjectId, (Object)projectId);
        queryWrapper.in(CostDocumentsEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = this.costDocumentsService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            List idList = entities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper query = Wrappers.lambdaQuery();
            query.eq(CostDocumentsDetailEntity::getCostType, (Object)feeTypeId);
            query.in(CostDocumentsDetailEntity::getDocumentsId, idList);
            List infoEntities = this.documentsDetailService.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)infoEntities)) {
                result = infoEntities.stream().map(CostDocumentsDetailEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", (Object)result);
    }
}

