/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.enums.ConvertResultEnum;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetProjectVO;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetProject"})
public class BudgetProjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBudgetProjectService service;
    @Autowired
    private IBudgetProjectDetailService detailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetProjectVO> saveOrUpdate(@RequestBody BudgetProjectVO saveorUpdateVO) {
        CommonResponse<BudgetProjectVO> response = this.service.saveOrUpdate(saveorUpdateVO);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectVO> queryDetail(Long id) {
        BudgetProjectVO vo = this.service.queryDetail(id);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetProjectVO> pushCost(@RequestBody BudgetProjectVO pushVO) {
        CommonResponse<BudgetProjectVO> response = this.service.pushCost(pushVO);
        return response;
    }

    @RequestMapping(value={"/convertToPro"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> convertToPro(@RequestBody BudgetProjectVO budgetProjectVO) {
        if (2 != budgetProjectVO.getBudgetType() && 4 != budgetProjectVO.getBudgetType()) {
            throw new BusinessException("\u53ea\u6709\u7c7b\u578b\u4e3a[\u65bd\u5de5\u56fe\u9884\u7b97]\u548c[\u7b7e\u8bc1]\u7684\u9884\u7b97\u4e66\u5141\u8bb8\u8f6c\u6362\u6210\u76ee\u6807\u6210\u672c!");
        }
        if (budgetProjectVO.getConvertState() != null && budgetProjectVO.getConvertState() == 1) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BudgetProjectDetailEntity::getBudgetId, (Object)budgetProjectVO.getId());
            queryWrapper.in(BudgetProjectDetailEntity::getResultState, Arrays.asList(ConvertResultEnum.\u5b58\u5728\u76f8\u4f3c\u6e05\u5355.getCode(), ConvertResultEnum.\u65e0\u76f8\u4f3c\u6e05\u5355.getCode()));
            List list = this.detailService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new BusinessException("\u4e0d\u5b58\u5728\u5339\u914d\u7ed3\u679c\u4e3a\u5b58\u5728\u76f8\u4f3c\u6e05\u5355\u6216\u65e0\u76f8\u4f3c\u6e05\u5355\u7684\u6570\u636e\uff0c\u65e0\u9700\u518d\u6b21\u8f6c\u6362\uff01");
            }
            List budgetProjectDetailVOS = BeanMapper.mapList((Iterable)list, BudgetProjectDetailVO.class);
            for (BudgetProjectDetailVO budgetProjectDetailVO : budgetProjectDetailVOS) {
                budgetProjectDetailVO.setResultState(null);
                budgetProjectDetailVO.setBaseResultState(null);
                budgetProjectDetailVO.setSetDetailId(null);
                budgetProjectDetailVO.setMatchTime(null);
            }
            budgetProjectVO.setCheckList(budgetProjectDetailVOS);
        }
        return this.service.convertToPro(budgetProjectVO);
    }

    @RequestMapping(value={"/pushToPro"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> pushToPro(Long budgetId) {
        return this.service.pushToPro(budgetId);
    }

    @RequestMapping(value={"/checkBeforePush"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> checkBeforePush(Long budgetId) {
        return this.service.checkBeforePush(budgetId);
    }

    @RequestMapping(value={"/refBudgetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectVO>> refBudgetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"projectId") != null) {
            param.getParams().put("projectId", new Parameter("eq", (Object)_con.getLong("projectId")));
        }
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("budgetType", new Parameter("in", (Object)"4,5"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List budgetDataList = page.getRecords();
        if (!ObjectUtils.isEmpty((Object)budgetDataList)) {
            List idList = budgetDataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List budgetProjectDetailList = ((LambdaQueryChainWrapper)this.detailService.lambdaQuery().in(BudgetProjectDetailEntity::getBudgetId, idList)).list();
            budgetDataList.forEach(budgetProjectEntity -> budgetProjectDetailList.forEach(budgetProjectDetailEntity -> {
                if (Objects.equals(budgetProjectDetailEntity.getBudgetId(), budgetProjectEntity.getId())) {
                    budgetProjectEntity.getCheckList().add((BudgetProjectDetailEntity)((Object)((Object)budgetProjectDetailEntity)));
                }
            }));
            pageData.setRecords(BeanMapper.mapList((Iterable)budgetDataList, BudgetProjectVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refBudgetInventoryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailVO>> refBudgetInventoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"projectId") != null) {
                param.getParams().put("projectId", new Parameter("eq", (Object)_con.getLong("projectId")));
            }
            if (_con.get((Object)"budgetType") != null) {
                param.getParams().put("budgetType", new Parameter("in", _con.get((Object)"budgetType")));
            }
        }
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List budgetProjectEntityList = this.service.queryList(param, false);
        Page pageData = new Page();
        if (!ObjectUtils.isEmpty((Object)budgetProjectEntityList)) {
            QueryParam param2 = new QueryParam();
            param2.setPageSize(pageSize.intValue());
            param2.setPageIndex(pageNumber.intValue());
            param2.getParams().put("budget_id", new Parameter("in", budgetProjectEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList())));
            param2.getParams().put("leaf_flag", new Parameter("eq", (Object)1));
            IPage page = this.detailService.queryPage(param2, false);
            List list = page.getRecords();
            if (!ObjectUtils.isEmpty((Object)list)) {
                List<BudgetProjectDetailEntity> parentList = new ArrayList<BudgetProjectDetailEntity>();
                parentList = this.getParent(list, parentList);
                list.addAll(parentList);
                for (BudgetProjectDetailEntity entity : list) {
                    entity.setTid(entity.getId().toString());
                    entity.setTpid(entity.getParentId() != null && entity.getParentId() > 0L ? entity.getParentId().toString() : "");
                }
                Collections.sort(list, (o1, o2) -> {
                    String[] sufArrs;
                    String[] preArrs = o1.getDetailIndex().split("\\.");
                    int len = preArrs.length > (sufArrs = o2.getDetailIndex().split("\\.")).length ? preArrs.length : sufArrs.length;
                    for (int i = 0; i < len; ++i) {
                        int preNum = 0;
                        int sufNum = 0;
                        if (i < preArrs.length) {
                            preNum = Integer.parseInt(preArrs[i]);
                        }
                        if (i < sufArrs.length) {
                            sufNum = Integer.parseInt(sufArrs[i]);
                        }
                        if (preNum > sufNum) {
                            return 1;
                        }
                        if (preNum >= sufNum) continue;
                        return -1;
                    }
                    return 0;
                });
                List budgetProjectDetailVOS = BeanMapper.mapList((Iterable)list, BudgetProjectDetailVO.class);
                List budgetProjectDetailTree = TreeNodeBUtil.buildTree((List)budgetProjectDetailVOS);
                pageData.setCurrent(page.getCurrent());
                pageData.setSize(page.getSize());
                pageData.setPages(page.getPages());
                pageData.setTotal(page.getTotal());
                pageData.setRecords(budgetProjectDetailTree);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private List<BudgetProjectDetailEntity> getParent(List<BudgetProjectDetailEntity> list, List<BudgetProjectDetailEntity> parentList) {
        List ids = list.stream().filter(s -> s.getParentId() != null).map(BudgetProjectDetailEntity::getParentId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryWrapper objectQueryWrapper = new QueryWrapper();
            objectQueryWrapper.in((Object)"id", ids);
            List parentDetailEntities = this.detailService.list((Wrapper)objectQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)parentDetailEntities)) {
                parentList.addAll(parentDetailEntities);
                this.getParent(parentDetailEntities, parentList);
            }
        }
        parentList = parentList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BudgetProjectDetailEntity>(Comparator.comparing(BaseEntity::getId))), ArrayList::new));
        return parentList;
    }
}

