/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/budgetProjectPro/"})
public class BudgetProjectProApi {
    @Resource
    private IBudgetProjectProService service;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;

    @PostMapping(value={"/fetchQuantityAndMny"})
    public CommonResponse<BudgetProjectProQuantityAndMnyVO> fetchQuantityAndMny(@Validated @RequestBody BudgetProjectProParamControlVO paramControlVO) {
        return CommonResponse.success((String)"\u8bf7\u6c42\u6210\u529f\uff01", (Object)this.service.fetchQuantityAndMny(paramControlVO));
    }

    @GetMapping(value={"getBudgetProjectProQuantityByProjectId"})
    public CommonResponse<Map<Long, BigDecimal>> getBudgetProjectProQuantityByProjectId(@RequestParam(value="projectId", required=true) Long projectId) {
        return CommonResponse.success((String)"\u8bf7\u6c42\u6210\u529f\uff01", this.service.getBudgetProjectProQuantityByProjectId(projectId));
    }

    @GetMapping(value={"queryFeeMny"})
    public CommonResponse<BigDecimal> queryFeeMny(@RequestParam(value="projectId") Long projectId, @RequestParam(value="feeTypeId") Long feeTypeId) {
        BigDecimal result = BigDecimal.ZERO;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BudgetProjectProEntity::getProjectId, (Object)projectId);
        queryWrapper.in(BudgetProjectProEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            List idList = entities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper query = Wrappers.lambdaQuery();
            query.eq(BudgetProjectDetailProEntity::getLeafFlag, (Object)1);
            query.eq(BudgetProjectDetailProEntity::getSourceId, (Object)feeTypeId);
            query.eq(BudgetProjectDetailProEntity::getSourceType, (Object)1);
            query.in(BudgetProjectDetailProEntity::getBudgetId, idList);
            List infoEntities = this.budgetProjectDetailProService.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)infoEntities)) {
                result = infoEntities.stream().map(BudgetProjectDetailProEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", (Object)result);
    }
}

