package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.*;
import com.ejianc.business.budget.service.*;
import com.ejianc.business.budget.vo.QuotaDetailVO;
import com.ejianc.business.budget.vo.QuotaMatVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 定额库明细表
 *
 * @author generator
 */
@Controller
@RequestMapping("quotaDetail")
public class QuotaDetailController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private IQuotaDetailService service;
    @Autowired
    private IQuotaMatService quotaMatService;
    @Autowired
    private IBudgetSetQuotaService budgetSetQuotaService;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;

    @Autowired
    private IQuotaService quotaService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuotaDetailVO> saveOrUpdate(@RequestBody QuotaDetailVO saveOrUpdateVO) {
        LambdaQueryWrapper<QuotaDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(QuotaDetailEntity::getQuotaId, saveOrUpdateVO.getQuotaId());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), QuotaDetailEntity::getId, saveOrUpdateVO.getId());
        queryWrapper.eq(QuotaDetailEntity::getDetailCode, StringUtils.trim(saveOrUpdateVO.getDetailCode()));
        if (service.count(queryWrapper) > 0) {
            throw new BusinessException("编码重复,不允许保存!");
        }
        QuotaDetailEntity entity = BeanMapper.map(saveOrUpdateVO, QuotaDetailEntity.class);
        if (CollectionUtils.isNotEmpty(entity.getMatList())) {
            List<String> nameList = entity.getMatList().stream().filter(x -> !"del".equals(x.getRowState())).map(QuotaMatEntity::getMaterialName).collect(Collectors.toList());
            entity.setMatName(StringUtils.join(nameList, ","));
        }
        service.saveOrUpdate(entity, false);
        QuotaDetailVO vo = BeanMapper.map(entity, QuotaDetailVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuotaDetailVO> queryDetail(Long id) {
        QuotaDetailEntity entity = service.selectById(id);
        QuotaDetailVO vo = BeanMapper.map(entity, QuotaDetailVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotaDetailVO> vos) {
        List<Long> longs = vos.stream().map(QuotaDetailVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<BudgetSetQuotaEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(BudgetSetQuotaEntity::getQuotaId, longs);
        if (budgetSetQuotaService.count(queryWrapper) > 0) {
            throw new BusinessException("所选定额库被[清单定额关系设置]引用，不允许删除!");
        }
        LambdaQueryWrapper<BudgetProjectDetailProEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(BudgetProjectDetailProEntity::getSourceId, longs);
        if (budgetProjectDetailProService.count(wrapper) > 0) {
            throw new BusinessException("所选定额库被[目标成本]引用，不允许删除!");
        }
        service.removeByIds(longs, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QuotaDetailVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<QuotaDetailEntity> page = service.queryPage(param, false);
        IPage<QuotaDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotaDetailVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<QuotaDetailVO> list = service.queryDetailList(wrapper);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("QuotaDetail-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refQuotaDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<QuotaDetailVO>> refQuotaDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   @RequestParam(required = false) String relyCondition,
                                                                   String searchObject,
                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().addAll(Arrays.asList("detailCode", "detailName", "description"));
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long quotaTypeId = null;
        if (StringUtils.isNotEmpty(relyCondition)) {
            /** 处理condition */
            quotaTypeId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("quotaTypeId", new Parameter(QueryParam.EQ, quotaTypeId));
        }
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("quotaTypeId")) {
                quotaTypeId = Long.valueOf(String.valueOf(_con.get("quotaTypeId")));
                param.getParams().put("quotaTypeId", new Parameter(QueryParam.EQ, quotaTypeId));
            }
        }

        LambdaQueryWrapper<QuotaEntity> quotaEntityLambdaQueryWrapper = Wrappers.<QuotaEntity>lambdaQuery();
        quotaEntityLambdaQueryWrapper.eq(QuotaEntity::getEnableState, 1);
        quotaEntityLambdaQueryWrapper.eq(QuotaEntity::getTenantId, InvocationInfoProxy.getTenantid());
        QuotaEntity quotaEntity = quotaService.getOne(quotaEntityLambdaQueryWrapper, false);
        if (null == quotaEntity) {
            throw new BusinessException("未查询到启用的定额库！");
        }
        param.getParams().put("quotaId", new Parameter(QueryParam.EQ, quotaEntity.getId()));
        IPage<QuotaDetailEntity> page = service.queryPage(param, false);
        IPage<QuotaDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<QuotaDetailVO> detailVOS = BeanMapper.mapList(page.getRecords(), QuotaDetailVO.class);
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            List<Long> detailIds = detailVOS.stream().map(QuotaDetailVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<QuotaMatEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(QuotaMatEntity::getQuotaDetailId, detailIds);
            List<QuotaMatEntity> matEntities = quotaMatService.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(matEntities)) {
                Map<Long, List<QuotaMatEntity>> map = matEntities.stream().collect(Collectors.groupingBy(QuotaMatEntity::getQuotaDetailId));
                for (QuotaDetailVO detailVO : detailVOS) {
                    detailVO.setMatList(map.containsKey(detailVO.getId()) ? BeanMapper.mapList(map.get(detailVO.getId()), QuotaMatVO.class) : null);
                }
            }
        }
        pageData.setRecords(detailVOS);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "QuotaDetail-import.xlsx", "明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.execlImport(request);
    }
}
