package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.*;
import com.ejianc.business.budget.service.IBudgetProjectDetailHistoryProService;
import com.ejianc.business.budget.service.IBudgetProjectProTagService;
import com.ejianc.business.budget.vo.*;
import com.ejianc.business.budget.vo.comparator.BudgetDetailHistoryComparatoeVo;
import com.ejianc.business.budget.vo.comparator.BudgetDetailHistoryProComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.budget.mapper.BudgetProjectHistoryProMapper;
import com.ejianc.business.budget.service.IBudgetProjectHistoryProService;

import java.util.*;

/**
 * 项目预算记录表主实体
 * 
 * @author generator
 * 
 */
@Service("budgetProjectHistoryProService")
public class BudgetProjectHistoryProServiceImpl extends BaseServiceImpl<BudgetProjectHistoryProMapper, BudgetProjectHistoryProEntity> implements IBudgetProjectHistoryProService{

    @Autowired
    private IBudgetProjectDetailHistoryProService historyDetailService;

    @Autowired
    private IBudgetProjectProTagService budgetProjectProTagService;


    @Override
    public BudgetProjectHistoryProVO queryDetailByChangeId(Long id) {
        BudgetProjectHistoryProEntity historyEntity = baseMapper.selectOne(new QueryWrapper<BudgetProjectHistoryProEntity>().eq("id", id));
        if(historyEntity !=null){
            BudgetProjectHistoryProVO historyVo = BeanMapper.map(historyEntity, BudgetProjectHistoryProVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_history_id", new Parameter(QueryParam.EQ, historyEntity.getId()));
            List<BudgetProjectDetailHistoryProEntity> historyDetailEntities = historyDetailService.queryList(queryParam, false);
            if(historyDetailEntities != null && historyDetailEntities.size() > 0) {
                List<BudgetProjectDetailHistoryProVO> detailVos = BeanMapper.mapList(historyDetailEntities, BudgetProjectDetailHistoryProVO.class);
                //实现排序
                 Collections.sort(detailVos,new BudgetDetailHistoryProComparatoeVo());
                for(BudgetProjectDetailHistoryProVO cdEntity:detailVos){
                    cdEntity.setTid(cdEntity.getTid()!=null ? cdEntity.getTid().toString() :null);
                    cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                }
                historyVo.setDetailList(TreeNodeBUtil.buildTree(detailVos));
            }
            return historyVo;
        }
        return null;
    }

    @Override
    public List<BudgetProjectHistoryProVO> queryChangeHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<BudgetProjectHistoryProEntity> changeEntities = baseMapper.selectList(new QueryWrapper<BudgetProjectHistoryProEntity>()
                .eq("budget_id", id)
                .in("bill_state", billStatus).orderByDesc("create_time"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List<BudgetProjectHistoryProVO> his = BeanMapper.mapList(changeEntities, BudgetProjectHistoryProVO.class);
            LambdaQueryWrapper<BudgetProjectProTagEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(BudgetProjectProTagEntity::getProjectId, changeEntities.get(0).getProjectId());
            BudgetProjectProTagEntity existEntity = budgetProjectProTagService.getOne(queryWrapper);
            for (BudgetProjectHistoryProVO historyVO : his) {
                historyVO.setInitVersion(Objects.equals(historyVO.getId(), existEntity.getTagId()));
            }
            return his;
        }
        return null;
    }
}
