/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.bean.BudgetProjectHistoryEntity;
import com.ejianc.business.budget.mapper.BudgetProjectHistoryMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailHistoryService;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetProjectHistoryService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.BudgetProjectChangeVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailHistoryVO;
import com.ejianc.business.budget.vo.BudgetProjectHistoryVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailHistoryComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectHistoryService")
public class BudgetProjectHistoryServiceImpl
extends BaseServiceImpl<BudgetProjectHistoryMapper, BudgetProjectHistoryEntity>
implements IBudgetProjectHistoryService {
    @Autowired
    private IBudgetProjectDetailHistoryService historyDetailService;
    @Autowired
    private IBudgetProjectService budgetService;
    @Autowired
    private IBudgetProjectDetailService budgetProjectDetailService;

    @Override
    public BudgetProjectHistoryVO queryDetailByChangeId(Long id) {
        BudgetProjectHistoryEntity historyEntity = (BudgetProjectHistoryEntity)((Object)((BudgetProjectHistoryMapper)this.baseMapper).selectOne((Wrapper)new QueryWrapper().eq((Object)"change_id", (Object)id)));
        if (historyEntity != null) {
            BudgetProjectHistoryVO historyVo = (BudgetProjectHistoryVO)BeanMapper.map((Object)((Object)historyEntity), BudgetProjectHistoryVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_history_id", new Parameter("eq", (Object)historyEntity.getId()));
            queryParam.getParams().put("change_type", new Parameter("ne", (Object)5));
            List historyDetailEntities = this.historyDetailService.queryList(queryParam, false);
            if (historyDetailEntities != null && historyDetailEntities.size() > 0) {
                List detailVos = BeanMapper.mapList((Iterable)historyDetailEntities, BudgetProjectDetailHistoryVO.class);
                Collections.sort(detailVos, new BudgetDetailHistoryComparatoeVo());
                for (BudgetProjectDetailHistoryVO cdEntity : detailVos) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                }
                historyVo.setCheckList(TreeNodeBUtil.buildTree((List)detailVos));
            }
            return historyVo;
        }
        return null;
    }

    @Override
    public BudgetProjectChangeVO queryChange(Long budgetId, Boolean compareFirst) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"budget_id", (Object)budgetId)).in((Object)"bill_state", billStatus);
        if (compareFirst.booleanValue()) {
            wrapper.orderByAsc((Object)"change_version");
        } else {
            wrapper.orderByDesc((Object)"change_version");
        }
        wrapper.last("limit 1");
        BudgetProjectHistoryEntity historyEntity = (BudgetProjectHistoryEntity)((Object)((BudgetProjectHistoryMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        if (null != historyEntity) {
            List historyEntityList = ((BudgetProjectHistoryEntity)((Object)this.selectById(historyEntity.getId()))).getCheckList().stream().filter(t -> t.getChangeType() == null || t.getChangeType() != 5).collect(Collectors.toList());
            List detailHistoryVOS = BeanMapper.mapList(historyEntityList, BudgetProjectDetailHistoryVO.class);
            BudgetProjectEntity entity = (BudgetProjectEntity)((Object)this.budgetService.getById(budgetId));
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_id", new Parameter("eq", (Object)budgetId));
            queryParam.getParams().put("change_type", new Parameter("ne", (Object)5));
            List purchaseDetailss = this.budgetProjectDetailService.queryList(queryParam, false);
            entity.setCheckList(purchaseDetailss);
            BudgetProjectChangeVO changeVO = (BudgetProjectChangeVO)BeanMapper.map((Object)((Object)entity), BudgetProjectChangeVO.class);
            changeVO.setBeforeChangeBudgetMny(historyEntity.getBudgetMny());
            List checkList = changeVO.getCheckList();
            CompareDifferenceUtil.compareList((List)detailHistoryVOS, (List)checkList, (boolean)true);
            changeVO.setCheckList(TreeNodeBUtil.buildTree((List)checkList));
            return changeVO;
        }
        return null;
    }

    private String nullToTrim(String source) {
        if (null == source) {
            return "";
        }
        return source;
    }
}

