package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.budget.bean.BudgetSetDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetFeaturesEntity;
import com.ejianc.business.budget.bean.BudgetSetQuotaEntity;
import com.ejianc.business.budget.bean.QuotaDetailEntity;
import com.ejianc.business.budget.mapper.BudgetSetDetailMapper;
import com.ejianc.business.budget.service.IBudgetSetDetailService;
import com.ejianc.business.budget.service.IBudgetSetFeaturesService;
import com.ejianc.business.budget.service.IBudgetSetQuotaService;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.business.budget.vo.BudgetSetFeaturesVO;
import com.ejianc.business.budget.vo.BudgetSetImportVO;
import com.ejianc.business.budget.vo.BudgetSetQuotaVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 清单定额关系明细
 *
 * @author generator
 */
@Service("budgetSetDetailService")
public class BudgetSetDetailServiceImpl extends BaseServiceImpl<BudgetSetDetailMapper, BudgetSetDetailEntity> implements IBudgetSetDetailService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IQuotaDetailService quotaDetailService;
    @Autowired
    private IBudgetSetQuotaService budgetSetQuotaService;
    @Autowired
    private IBudgetSetFeaturesService budgetSetFeaturesService;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        Long setId = Long.valueOf(request.getParameter("setId"));
        Long setTypeId = Long.valueOf(request.getParameter("setTypeId"));
        logger.info("开始导入--" + setId);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<BudgetSetImportVO> allSuccessList = new ArrayList<>();
        List<BudgetSetImportVO> successList = new ArrayList<>();
        List<BudgetSetImportVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                List<String> quotaCodeList = new ArrayList<>();
                Map<String, QuotaDetailEntity> map = new HashMap<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    if (StringUtils.isNotEmpty(datas.get(6))) {
                        quotaCodeList.add(datas.get(6));//取定额编码
                    }
                }
                if (CollectionUtils.isNotEmpty(quotaCodeList)) {
                    LambdaQueryWrapper<QuotaDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
                    queryWrapper.in(QuotaDetailEntity::getDetailCode, quotaCodeList);
                    List<QuotaDetailEntity> quotaList = quotaDetailService.list(queryWrapper);
                    map = quotaList.stream().collect(Collectors.toMap(QuotaDetailEntity::getDetailCode, Function.identity(), (oldValue, newValue) -> newValue));
                    logger.info("材料map信息--" + JSONObject.toJSONString(map));
                }

                Long lastDetailId = null;
                for (int i = 1; i < result.size(); i++) {
                    StringBuffer errMsg = new StringBuffer();
                    boolean errflag = false;
                    List<String> datas = result.get(i);
                    BudgetSetImportVO importVO = new BudgetSetImportVO();
                    importVO.setMatFlag(false);
                    importVO.setId(IdWorker.getId());
                    importVO.setSetId(setId);
                    importVO.setSetTypeId(setTypeId);
                    String detailCode = datas.get(0);
                    //编码为空
                    if (StringUtils.isEmpty(detailCode)) {
                        //没有读取到清单
                        if (lastDetailId == null) {
                            errMsg.append("清单编码不能为空,");
                            errflag = true;
                        }
                        //有清单说明是定额，放到最近的定额子表
                        else {
                            importVO.setMatFlag(true);
                        }
                    } else {
                        importVO.setDetailCode(detailCode);
                    }

                    if (BooleanUtils.isFalse(importVO.getMatFlag())) {
                        String detailName = datas.get(1);
                        if (StringUtils.isEmpty(detailName)) {
                            errMsg.append("清单名称不能为空,");
                            errflag = true;
                        } else {
                            importVO.setDetailName(detailName);
                        }

                        String description = datas.get(2);
                        if (StringUtils.isEmpty(description)) {
                            errMsg.append("特征描述不能为空,");
                            errflag = true;
                        } else {
                            importVO.setDescription(description);
                        }

                        //关键特征值
                        importVO.setFeatures(datas.get(3));
                        //单位
                        importVO.setDetailUnit(datas.get(4));

                        String detailNum = datas.get(5);
                        if (StringUtils.isEmpty(detailNum)) {
                            errMsg.append("工程量不能为空,");
                            errflag = true;
                        } else {
                            try {
                                importVO.setDetailNum(StringUtils.isNotBlank(detailNum) ? new BigDecimal(detailNum) : null);
                            } catch (Exception e) {
                                errMsg.append("工程量格式错误,");
                                errflag = true;
                            }
                        }
                    }


                    BudgetSetImportVO importSetVO = null;
                    String quotaCode = datas.get(6);
                    if (BooleanUtils.isTrue(importVO.getMatFlag()) && StringUtils.isBlank(quotaCode)) {
                        errMsg.append("定额编码不能为空,");
                        errflag = true;
                    } else if (StringUtils.isNotBlank(quotaCode)) {
                        QuotaDetailEntity detailEntity = map.get(quotaCode);
                        if (BooleanUtils.isFalse(importVO.getMatFlag())) {
                            importSetVO = new BudgetSetImportVO();
                            importSetVO.setMatFlag(true);
                            importSetVO.setId(IdWorker.getId());
                            importSetVO.setSetId(setId);
                            importSetVO.setSetTypeId(setTypeId);
                            if (detailEntity != null) {
                                importSetVO.setSetDetailId(importVO.getId());
                                importSetVO.setQuotaId(detailEntity.getId());
                                importSetVO.setQuotaCode(detailEntity.getDetailCode());
                                importSetVO.setQuotaName(detailEntity.getDetailName());
                                importSetVO.setQuotaDescription(detailEntity.getDescription());
                                importSetVO.setQuotaMatName(detailEntity.getMatName());
                                importSetVO.setQuotaUnit(detailEntity.getDetailUnit());
                            } else {
                                errMsg.append("定额编码未匹配到定额库,");
                                errflag = true;
                            }

                            String quotaNum = datas.get(10);
                            if (StringUtils.isBlank(quotaNum)) {
                                errMsg.append("定额工程量不能为空,");
                                errflag = true;
                            } else {
                                try {
                                    importSetVO.setQuotaNum(StringUtils.isNotBlank(quotaNum) ? new BigDecimal(quotaNum) : null);
                                } catch (Exception e) {
                                    errMsg.append("定额工程量格式错误,");
                                    errflag = true;
                                }
                            }
                        }else {
                            if (detailEntity != null) {
                                importVO.setSetDetailId(lastDetailId);
                                importVO.setQuotaId(detailEntity.getId());
                                importVO.setQuotaCode(detailEntity.getDetailCode());
                                importVO.setQuotaName(detailEntity.getDetailName());
                                importVO.setQuotaDescription(detailEntity.getDescription());
                                importVO.setQuotaMatName(detailEntity.getMatName());
                                importVO.setQuotaUnit(detailEntity.getDetailUnit());
                            } else {
                                errMsg.append("定额编码未匹配到定额库,");
                                errflag = true;
                            }

                            String quotaNum = datas.get(10);
                            if (StringUtils.isBlank(quotaNum)) {
                                errMsg.append("定额工程量不能为空,");
                                errflag = true;
                            } else {
                                try {
                                    importVO.setQuotaNum(StringUtils.isNotBlank(quotaNum) ? new BigDecimal(quotaNum) : null);
                                } catch (Exception e) {
                                    errMsg.append("定额工程量格式错误,");
                                    errflag = true;
                                }
                            }
                        }

                    }

                    if (errflag) {
                        importVO.setErrorMsg(errMsg.substring(0, errMsg.length() - 1));
                        errorList.add(importVO);
                    } else {
                        successList.add(importVO);
                        allSuccessList.add(importVO);
                        if (null != importSetVO) {
                            allSuccessList.add(importSetVO);
                        }
                    }
                    if (BooleanUtils.isFalse(importVO.getMatFlag())) {
                        lastDetailId = importVO.getId();
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        if (CollectionUtils.isEmpty(errorList)) {
            List<BudgetSetDetailVO> detailVOS = new ArrayList<>();
            List<BudgetSetQuotaVO> quotaVOS = new ArrayList<>();
            List<BudgetSetFeaturesVO> featuresVOS = new ArrayList<>();
            Map<Long, List<String>> quotaNameMap = new HashMap<>();
            for (BudgetSetImportVO importVO : allSuccessList) {
                if (BooleanUtils.isFalse(importVO.getMatFlag())) {
                    BudgetSetDetailVO detailVO = BeanMapper.map(importVO, BudgetSetDetailVO.class);
                    detailVOS.add(detailVO);
                } else {
                    BudgetSetQuotaVO setQuotaVO = BeanMapper.map(importVO, BudgetSetQuotaVO.class);
                    quotaVOS.add(setQuotaVO);

                    List<String> matStrList = quotaNameMap.containsKey(setQuotaVO.getSetDetailId()) ? quotaNameMap.get(setQuotaVO.getSetDetailId()) : new ArrayList<>();
                    matStrList.add(setQuotaVO.getQuotaName());
                    quotaNameMap.put(setQuotaVO.getSetDetailId(), matStrList);
                }
            }
            for (BudgetSetDetailVO detailVO : detailVOS) {
                if (quotaNameMap.containsKey(detailVO.getId())) {
                    List<String> stringList = quotaNameMap.get(detailVO.getId());
                    detailVO.setQuotaName(StringUtils.join(stringList, ","));
                }
                if (StringUtils.isNotBlank(detailVO.getFeatures())) {
                    String[] strings = detailVO.getFeatures().split(";");
                    for (String str : strings) {
                        BudgetSetFeaturesVO featuresVO = new BudgetSetFeaturesVO();
                        featuresVO.setId(IdWorker.getId());
                        featuresVO.setSetId(setId);
                        featuresVO.setSetTypeId(setTypeId);
                        featuresVO.setSetDetailId(detailVO.getId());
                        featuresVO.setFeaturesName(str);
                        featuresVOS.add(featuresVO);
                    }
                }
            }
            List<BudgetSetDetailEntity> resList = BeanMapper.mapList(detailVOS, BudgetSetDetailEntity.class);
            saveBatch(resList);
            List<BudgetSetQuotaEntity> quotaEntities = BeanMapper.mapList(quotaVOS, BudgetSetQuotaEntity.class);
            budgetSetQuotaService.saveBatch(quotaEntities);
            List<BudgetSetFeaturesEntity> featuresEntities = BeanMapper.mapList(featuresVOS, BudgetSetFeaturesEntity.class);
            budgetSetFeaturesService.saveBatch(featuresEntities);

        }
        return CommonResponse.success("导入成功！", json);
    }

    @Override
    public Integer countByNames(Long setId, List<String> names) {
        return baseMapper.countByNames(setId, names);
    }

    @Override
    public List<BudgetSetDetailVO> queryByNames(Long setId, List<String> names) {
        return baseMapper.queryByNames(setId, names);
    }
}
