package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.cost.bean.AdjustmentDetailEntity;
/**
 * 预算量调整申请单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_cost_adjustment")
public class AdjustmentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="theme")
    private String theme; // 主题
    @TableField(value="change_type")
    private Integer changeType; // 变更类型 0-清单内,1-清单外
    @TableField(value="apply_time")
    private Date applyTime; // 申请日期
    @TableField(value="memo")
    private String memo; // 具体说明
    @TableField(value="adjustment_reason")
    private String adjustmentReason; // 调整原因
    @TableField(value="adjustment_normal")
    private Integer adjustmentNormal; // 正常调量
    @TableField(value="project_reason")
    private Integer projectReason; // 项目原因
    @TableField(value="sum")
    private BigDecimal sum; // 累计
    @TableField(value="project_person")
    private String projectPerson; // 项目责任人
    @TableField(value="budget_reason")
    private Integer budgetReason; // 预算量
    @TableField(value="budget_person")
    private String budgetPerson; // 预算责任人
    @TableField(value="drawing_reason")
    private Integer drawingReason; // 图纸原因
    @TableField(value="drawing_person")
    private String drawingPerson; // 图纸责任人
    @TableField(value="gifts")
    private Integer gifts; // 赠送
    @TableField(value="gifts_sum")
    private BigDecimal giftsSum; // 累计赠送
    @TableField(value="gifts_already")
    private BigDecimal giftsAlready; // 已赠送
    @TableField(value="gifts_this")
    private BigDecimal giftsThis; // 本次赠送
    @TableField(value="gifts_reason")
    private String giftsReason; // 赠送原因
    @TableField(value="labor_memo")
    private String laborMemo; // 对应的劳务标段
    @TableField(value="is_auditing")
    private Integer isAuditing; // 是否需要总经理审核
    @TableField(value="is_visa")
    private Integer isVisa; // 是否需要办理对外签证
    @TableField(value="is_reason")
    private Integer isReason; // 是否项目原因
    @TableField(value="deduction_mny")
    private BigDecimal deductionMny; // 扣款金额
    @TableField(value="visa_memo")
    private String visaMemo; // 对外签证办理事项
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 申请人
    @TableField(value="employee_name")
    private String employeeName; // 申请人名称
    @TableField(value="department_id")
    private Long departmentId; // 申请部门
    @TableField(value="department_name")
    private String departmentName; // 申请部门名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id（区域名称）
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态

    // 2025-03-06 添加字段
    @TableField(value="adjustment_normal_mny")
    private BigDecimal adjustmentNormalMny; // 正常调量金额
    @TableField(value="project_reason_mny")
    private BigDecimal projectReasonMny; // 项目原因金额
    @TableField(value="budget_reason_mny")
    private BigDecimal budgetReasonMny; // 预算量金额
    @TableField(value="drawing_reason_mny")
    private BigDecimal drawingReasonMny; // 图纸原因金额
    @TableField(value="gifts_mny")
    private BigDecimal giftsMny; // 赠送金额
    @TableField(value="gifts_person")
    private String giftsPerson; // 赠送责任人

    // 2025-03-25 添加字段
    @TableField(value="order_reason")
    private Integer orderReason; // 下单错误
    @TableField(value="order_person")
    private String orderPerson; // 下单错误责任人
    @TableField(value="order_mny")
    private BigDecimal orderMny; // 下单错金额



    @TableField(exist=false)
    @SubEntity(serviceName="adjustmentDetailService",pidName = "adjustmentId")
    private List<AdjustmentDetailEntity> adjustmentDetailList = new ArrayList<>(); // 预算量调整申请单-ERP材料调整表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }
    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getAdjustmentReason() {
        return adjustmentReason;
    }

    public void setAdjustmentReason(String adjustmentReason) {
        this.adjustmentReason = adjustmentReason;
    }
    public Integer getAdjustmentNormal() {
        return adjustmentNormal;
    }

    public void setAdjustmentNormal(Integer adjustmentNormal) {
        this.adjustmentNormal = adjustmentNormal;
    }
    public Integer getProjectReason() {
        return projectReason;
    }

    public void setProjectReason(Integer projectReason) {
        this.projectReason = projectReason;
    }
    public BigDecimal getSum() {
        return sum;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum;
    }
    public String getProjectPerson() {
        return projectPerson;
    }

    public void setProjectPerson(String projectPerson) {
        this.projectPerson = projectPerson;
    }
    public Integer getBudgetReason() {
        return budgetReason;
    }

    public void setBudgetReason(Integer budgetReason) {
        this.budgetReason = budgetReason;
    }
    public String getBudgetPerson() {
        return budgetPerson;
    }

    public void setBudgetPerson(String budgetPerson) {
        this.budgetPerson = budgetPerson;
    }
    public Integer getDrawingReason() {
        return drawingReason;
    }

    public void setDrawingReason(Integer drawingReason) {
        this.drawingReason = drawingReason;
    }
    public String getDrawingPerson() {
        return drawingPerson;
    }

    public void setDrawingPerson(String drawingPerson) {
        this.drawingPerson = drawingPerson;
    }
    public Integer getGifts() {
        return gifts;
    }

    public void setGifts(Integer gifts) {
        this.gifts = gifts;
    }
    public BigDecimal getGiftsSum() {
        return giftsSum;
    }

    public void setGiftsSum(BigDecimal giftsSum) {
        this.giftsSum = giftsSum;
    }
    public BigDecimal getGiftsAlready() {
        return giftsAlready;
    }

    public void setGiftsAlready(BigDecimal giftsAlready) {
        this.giftsAlready = giftsAlready;
    }
    public BigDecimal getGiftsThis() {
        return giftsThis;
    }

    public void setGiftsThis(BigDecimal giftsThis) {
        this.giftsThis = giftsThis;
    }

    public String getGiftsReason() {
        return giftsReason;
    }

    public void setGiftsReason(String giftsReason) {
        this.giftsReason = giftsReason;
    }

    public String getLaborMemo() {
        return laborMemo;
    }

    public void setLaborMemo(String laborMemo) {
        this.laborMemo = laborMemo;
    }
    public Integer getIsAuditing() {
        return isAuditing;
    }

    public void setIsAuditing(Integer isAuditing) {
        this.isAuditing = isAuditing;
    }
    public Integer getIsVisa() {
        return isVisa;
    }

    public void setIsVisa(Integer isVisa) {
        this.isVisa = isVisa;
    }
    public Integer getIsReason() {
        return isReason;
    }

    public void setIsReason(Integer isReason) {
        this.isReason = isReason;
    }
    public BigDecimal getDeductionMny() {
        return deductionMny;
    }

    public void setDeductionMny(BigDecimal deductionMny) {
        this.deductionMny = deductionMny;
    }
    public String getVisaMemo() {
        return visaMemo;
    }

    public void setVisaMemo(String visaMemo) {
        this.visaMemo = visaMemo;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<AdjustmentDetailEntity> getAdjustmentDetailList() {
        return adjustmentDetailList;
    }

    public void setAdjustmentDetailList(List<AdjustmentDetailEntity> adjustmentDetailList) {
        this.adjustmentDetailList = adjustmentDetailList;
    }

    public BigDecimal getAdjustmentNormalMny() {
        return adjustmentNormalMny;
    }

    public void setAdjustmentNormalMny(BigDecimal adjustmentNormalMny) {
        this.adjustmentNormalMny = adjustmentNormalMny;
    }

    public BigDecimal getProjectReasonMny() {
        return projectReasonMny;
    }

    public void setProjectReasonMny(BigDecimal projectReasonMny) {
        this.projectReasonMny = projectReasonMny;
    }

    public BigDecimal getBudgetReasonMny() {
        return budgetReasonMny;
    }

    public void setBudgetReasonMny(BigDecimal budgetReasonMny) {
        this.budgetReasonMny = budgetReasonMny;
    }

    public BigDecimal getDrawingReasonMny() {
        return drawingReasonMny;
    }

    public void setDrawingReasonMny(BigDecimal drawingReasonMny) {
        this.drawingReasonMny = drawingReasonMny;
    }

    public BigDecimal getGiftsMny() {
        return giftsMny;
    }

    public void setGiftsMny(BigDecimal giftsMny) {
        this.giftsMny = giftsMny;
    }

    public String getGiftsPerson() {
        return giftsPerson;
    }

    public void setGiftsPerson(String giftsPerson) {
        this.giftsPerson = giftsPerson;
    }

    public Integer getOrderReason(){
        return orderReason;
    }

    public void setOrderReason(Integer orderReason){
        this.orderReason = orderReason;
    }

    public String getOrderPerson(){
        return orderPerson;
    }

    public void setOrderPerson(String orderPerson){
        this.orderPerson = orderPerson;
    }

    public BigDecimal getOrderMny(){
        return orderMny;
    }

    public void setOrderMny(BigDecimal orderMny){
        this.orderMny = orderMny;
    }

}
