/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectProTagEntity;
import com.ejianc.business.budget.service.IBudgetProjectProTagService;
import com.ejianc.business.budget.vo.BudgetProjectProTagVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetProjectProTag"})
public class BudgetProjectProTagController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IBudgetProjectProTagService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetProjectProTagVO> saveOrUpdate(@RequestBody BudgetProjectProTagVO saveOrUpdateVO) {
        BudgetProjectProTagEntity entity = (BudgetProjectProTagEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), BudgetProjectProTagEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        BudgetProjectProTagVO vo = (BudgetProjectProTagVO)((Object)BeanMapper.map((Object)((Object)entity), BudgetProjectProTagVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectProTagVO> queryDetail(Long id) {
        BudgetProjectProTagEntity entity = (BudgetProjectProTagEntity)((Object)this.service.selectById(id));
        BudgetProjectProTagVO vo = (BudgetProjectProTagVO)((Object)BeanMapper.map((Object)((Object)entity), BudgetProjectProTagVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectProTagVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BudgetProjectProTagVO budgetProjectProTagVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectProTagVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectProTagVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetProjectProTag-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBudgetProjectProTagData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectProTagVO>> refBudgetProjectProTagData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectProTagVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveOrUpdateVersionTag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetProjectProTagVO> saveOrUpdateVersionTag(@RequestBody BudgetProjectProTagVO saveOrUpdateVO) {
        BudgetProjectProTagEntity entity = (BudgetProjectProTagEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), BudgetProjectProTagEntity.class));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BudgetProjectProTagEntity::getProjectId, (Object)entity.getProjectId());
        BudgetProjectProTagEntity existEntity = (BudgetProjectProTagEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        if (existEntity != null) {
            existEntity.setTagId(entity.getTagId());
            existEntity.setTagType(entity.getTagType());
            this.service.saveOrUpdate((Object)existEntity, false);
            return CommonResponse.success((String)"\u6dfb\u52a0\u6807\u8bb0\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)existEntity), BudgetProjectProTagVO.class));
        }
        this.service.saveOrUpdate((Object)entity, false);
        BudgetProjectProTagVO vo = (BudgetProjectProTagVO)((Object)BeanMapper.map((Object)((Object)entity), BudgetProjectProTagVO.class));
        return CommonResponse.success((String)"\u6dfb\u52a0\u6807\u8bb0\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/checkVersionTag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> checkVersionTag(@RequestBody BudgetProjectProTagVO saveOrUpdateVO) {
        try {
            BudgetProjectProTagEntity entity = (BudgetProjectProTagEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), BudgetProjectProTagEntity.class));
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BudgetProjectProTagEntity::getProjectId, (Object)entity.getProjectId());
            queryWrapper.eq(BudgetProjectProTagEntity::getTagId, (Object)entity.getTagId());
            queryWrapper.eq(BudgetProjectProTagEntity::getTagType, (Object)entity.getTagType());
            BudgetProjectProTagEntity existEntity = (BudgetProjectProTagEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
            boolean exists = existEntity != null;
            return CommonResponse.success((String)(exists ? "\u5df2\u5b58\u5728\u6807\u8bb0" : "\u672a\u5b58\u5728\u6807\u8bb0"), (Object)exists);
        }
        catch (Exception e) {
            return CommonResponse.success((String)("\u68c0\u67e5\u7248\u672c\u6807\u8bb0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

