/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.vo.CostAmountVO;
import com.ejianc.business.budget.vo.comparator.CostDetailProComparatoeVo;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.bean.SubjectEntity;
import com.ejianc.business.cost.service.ICostDetailService;
import com.ejianc.business.cost.service.ISubjectService;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.business.cost.vo.CostStatisticDetailVO;
import com.ejianc.business.cost.vo.CostStatisticVO;
import com.ejianc.business.cost.vo.SubjectVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subject"})
public class SubjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private ISubjectService service;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;
    @Autowired
    private ICostDetailService costDetailService;
    @Autowired
    private IBudgetProjectProService budgetProjectProService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubjectVO> saveOrUpdate(@RequestBody SubjectVO saveorUpdateVO) {
        SubjectEntity entity = (SubjectEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SubjectEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        SubjectVO vo = (SubjectVO)BeanMapper.map((Object)((Object)entity), SubjectVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubjectVO> queryDetail(Long id) {
        SubjectEntity entity = (SubjectEntity)((Object)this.service.selectById(id));
        SubjectVO vo = (SubjectVO)BeanMapper.map((Object)((Object)entity), SubjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubjectVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubjectVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"subjectRef"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> orderDetailRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("subjectCode");
        queryParam.getFuzzyFields().add("subjectName");
        Long projectId = null;
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("projectId")) {
            projectId = Long.valueOf(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<SubjectVO> list = this.service.geSubjects(wrapper);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (SubjectVO entity : list) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("leafFlag", entity.getLeafFlag());
            map.put("name", entity.getSubjectName());
            map.put("code", entity.getSubjectCode());
            map.put("parentId", entity.getParentId());
            resultMapList.add(map);
        }
        List result = ResultAsTree.createTreeData(resultMapList);
        return result;
    }

    @RequestMapping(value={"/queryCostStatist"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CostStatisticVO> queryCostStatist(@RequestBody QueryParam param) {
        CostStatisticVO budgetVo;
        Map<Integer, List<CostAmountVO>> collect;
        List fuzzyFields = param.getFuzzyFields();
        CostStatisticVO costStatisticVO = new CostStatisticVO();
        Long projectId = null;
        String subjectName = null;
        String subjectCode = null;
        Integer costType = null;
        if (param.getParams().containsKey("projectId")) {
            projectId = Long.parseLong(((Parameter)param.getParams().get("projectId")).getValue().toString());
            param.getParams().remove("projectId");
        }
        if (param.getParams().containsKey("subjectName")) {
            subjectName = ((Parameter)param.getParams().get("subjectName")).getValue().toString();
            param.getParams().remove("subjectName");
        }
        if (param.getParams().containsKey("subjectCode")) {
            subjectCode = ((Parameter)param.getParams().get("subjectCode")).getValue().toString();
            param.getParams().remove("subjectCode");
        }
        if (param.getParams().containsKey("costType")) {
            costType = Integer.parseInt(((Parameter)param.getParams().get("costType")).getValue().toString());
            param.getParams().remove("costType");
        }
        Map<Object, Object> costAmountVOMap = new HashMap();
        List<CostStatisticDetailVO> list = this.service.queryCostStatist(subjectCode, subjectName, projectId, costType);
        ArrayList<CostStatisticDetailVO> noRelationList = new ArrayList<CostStatisticDetailVO>();
        List<CostAmountVO> costAmountVOS = this.service.queryCostList(projectId);
        if (CollectionUtils.isNotEmpty(costAmountVOS)) {
            costAmountVOMap = costAmountVOS.stream().filter(s -> s.getSubjectId() != null).collect(Collectors.groupingBy(CostAmountVO::getSubjectId));
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (CostStatisticDetailVO costStatisticDetailVO : list) {
                if (costStatisticDetailVO.getParentId() == null && !costStatisticDetailVO.getLeafFlag().booleanValue()) {
                    costStatisticDetailVO.setBudgetTaxMny(null);
                    costStatisticDetailVO.setCostTaxMny(null);
                }
                if (costAmountVOMap.containsKey(costStatisticDetailVO.getId())) {
                    costStatisticDetailVO.setCostNum(((List)costAmountVOMap.get(costStatisticDetailVO.getId())).stream().filter(s -> s.getNum() != null).collect(Collectors.reducing(BigDecimal.ZERO, CostAmountVO::getNum, BigDecimal::add)));
                    BigDecimal laborTaxMnyCost = ((List)costAmountVOMap.get(costStatisticDetailVO.getId())).stream().filter(s -> s.getLaborTaxMnyCost() != null).collect(Collectors.reducing(BigDecimal.ZERO, CostAmountVO::getLaborTaxMnyCost, BigDecimal::add));
                    BigDecimal materialTaxMnyCost = ((List)costAmountVOMap.get(costStatisticDetailVO.getId())).stream().filter(s -> s.getMaterialTaxMnyCost() != null).collect(Collectors.reducing(BigDecimal.ZERO, CostAmountVO::getMaterialTaxMnyCost, BigDecimal::add));
                    BigDecimal majorTaxMnyCost = ((List)costAmountVOMap.get(costStatisticDetailVO.getId())).stream().filter(s -> s.getMajorTaxMnyCost() != null).collect(Collectors.reducing(BigDecimal.ZERO, CostAmountVO::getMajorTaxMnyCost, BigDecimal::add));
                    BigDecimal mechanicalTaxMnyCost = ((List)costAmountVOMap.get(costStatisticDetailVO.getId())).stream().filter(s -> s.getMechanicalTaxMnyCost() != null).collect(Collectors.reducing(BigDecimal.ZERO, CostAmountVO::getMechanicalTaxMnyCost, BigDecimal::add));
                    BigDecimal indirectionTaxMnyCost = ((List)costAmountVOMap.get(costStatisticDetailVO.getId())).stream().filter(s -> s.getIndirectionTaxMnyCost() != null).collect(Collectors.reducing(BigDecimal.ZERO, CostAmountVO::getIndirectionTaxMnyCost, BigDecimal::add));
                    costStatisticDetailVO.setCostTaxMny(ComputeUtil.safeAdd((BigDecimal)laborTaxMnyCost, (BigDecimal[])new BigDecimal[]{materialTaxMnyCost, majorTaxMnyCost, mechanicalTaxMnyCost, indirectionTaxMnyCost}));
                }
                if (costStatisticDetailVO.getCostTaxMny() != null) {
                    costStatisticDetailVO.setCostBugetRatio(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)costStatisticDetailVO.getCostTaxMny(), (BigDecimal)costStatisticDetailVO.getBudgetTaxMny()), (BigDecimal)new BigDecimal(100)));
                }
                if (costStatisticDetailVO.getParentId() != null && costStatisticDetailVO.getLeafFlag().booleanValue() && costStatisticDetailVO.getBudgetTaxMny() != null && costStatisticDetailVO.getBudgetNum() != null) {
                    costStatisticDetailVO.setBudgetTaxPrice(ComputeUtil.safeDiv((BigDecimal)costStatisticDetailVO.getBudgetTaxMny(), (BigDecimal)costStatisticDetailVO.getBudgetNum()));
                }
                if (costStatisticDetailVO.getCostTaxMny() != null && costStatisticDetailVO.getCostNum() != null) {
                    costStatisticDetailVO.setCostTaxPrice(ComputeUtil.safeDiv((BigDecimal)costStatisticDetailVO.getCostTaxMny(), (BigDecimal)costStatisticDetailVO.getCostNum()));
                }
                costStatisticDetailVO.setCostTypeName(costStatisticDetailVO.getCostType() != null ? CostTypeEnum.getEnumByType((Integer)costStatisticDetailVO.getCostType()).getName() : null);
            }
        }
        if (CollectionUtils.isNotEmpty(collect = costAmountVOS.stream().filter(s -> s.getSubjectId() == null).collect(Collectors.groupingBy(CostAmountVO::getCostType)))) {
            long noRelationParentId = IdWorker.getId();
            CostStatisticDetailVO costStatisticDetailVO = new CostStatisticDetailVO();
            costStatisticDetailVO.setSubjectName("\u672a\u5173\u8054\u9884\u7b97\u6210\u672c");
            costStatisticDetailVO.setId(Long.valueOf(noRelationParentId));
            costStatisticDetailVO.setLeafFlag(Boolean.valueOf(false));
            Object sumNoRelationTaxMny = null;
            for (Integer type : collect.keySet()) {
                CostStatisticDetailVO costStatisticDetailChildrenVO = new CostStatisticDetailVO();
                costStatisticDetailChildrenVO.setCostTypeName(CostTypeEnum.getEnumByType((Integer)type).getName());
                costStatisticDetailChildrenVO.setId(Long.valueOf(IdWorker.getId()));
                costStatisticDetailChildrenVO.setCostType(type);
                costStatisticDetailChildrenVO.setParentId(Long.valueOf(noRelationParentId));
                BigDecimal costTaxMny = BigDecimal.ZERO;
                if (type == 1) {
                    costTaxMny = collect.get(type).stream().filter(e -> null != e.getLaborTaxMnyCost()).collect(Collectors.reducing(BigDecimal.ZERO, CostAmountVO::getLaborTaxMnyCost, BigDecimal::add));
                }
                if (type == 2) {
                    costTaxMny = collect.get(type).stream().filter(e -> null != e.getMaterialTaxMnyCost()).collect(Collectors.reducing(BigDecimal.ZERO, CostAmountVO::getMaterialTaxMnyCost, BigDecimal::add));
                }
                if (type == 3) {
                    costTaxMny = collect.get(type).stream().filter(e -> null != e.getMajorTaxMnyCost()).collect(Collectors.reducing(BigDecimal.ZERO, CostAmountVO::getMajorTaxMnyCost, BigDecimal::add));
                }
                if (type == 4) {
                    costTaxMny = collect.get(type).stream().filter(e -> null != e.getMechanicalTaxMnyCost()).collect(Collectors.reducing(BigDecimal.ZERO, CostAmountVO::getMechanicalTaxMnyCost, BigDecimal::add));
                }
                if (type == 5) {
                    costTaxMny = collect.get(type).stream().filter(e -> null != e.getIndirectionTaxMnyCost()).collect(Collectors.reducing(BigDecimal.ZERO, CostAmountVO::getIndirectionTaxMnyCost, BigDecimal::add));
                }
                costStatisticDetailChildrenVO.setCostTaxMny(costTaxMny);
                if (costStatisticDetailChildrenVO.getCostTaxMny() != null) {
                    costStatisticDetailChildrenVO.setCostBugetRatio(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)costStatisticDetailChildrenVO.getCostTaxMny(), (BigDecimal)costStatisticDetailChildrenVO.getBudgetTaxMny()), (BigDecimal)new BigDecimal(100)));
                }
                costStatisticDetailChildrenVO.setLeafFlag(Boolean.valueOf(true));
                sumNoRelationTaxMny = ComputeUtil.safeAdd(sumNoRelationTaxMny, (BigDecimal)costTaxMny);
                noRelationList.add(costStatisticDetailChildrenVO);
            }
            costStatisticDetailVO.setCostTaxMny(sumNoRelationTaxMny);
            if (costStatisticDetailVO.getCostTaxMny() != null) {
                costStatisticDetailVO.setCostBugetRatio(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)costStatisticDetailVO.getCostTaxMny(), (BigDecimal)costStatisticDetailVO.getBudgetTaxMny()), (BigDecimal)new BigDecimal(100)));
            }
            noRelationList.add(costStatisticDetailVO);
        }
        Collections.sort(list, new CostDetailProComparatoeVo());
        list = this.setParentMnyAndNUm(list);
        costStatisticVO.setDetailList(TreeNodeBUtil.buildTree(list));
        List detailList = costStatisticVO.getDetailList();
        if (CollectionUtils.isNotEmpty(noRelationList)) {
            Collections.sort(noRelationList, new Comparator<CostStatisticDetailVO>(){

                @Override
                public int compare(CostStatisticDetailVO o1, CostStatisticDetailVO o2) {
                    if (o2.getCostType() == null) {
                        return 100;
                    }
                    if (o1.getCostType() == null) {
                        return 100;
                    }
                    return o1.getCostType().compareTo(o2.getCostType());
                }
            });
            Collections.sort(detailList, new Comparator<CostStatisticDetailVO>(){

                @Override
                public int compare(CostStatisticDetailVO o1, CostStatisticDetailVO o2) {
                    if (o2.getCostType() == null) {
                        return 100;
                    }
                    if (o1.getCostType() == null) {
                        return 100;
                    }
                    return o1.getDetailIndex().compareTo(o2.getDetailIndex());
                }
            });
            Integer detailIndex = null;
            detailIndex = CollectionUtils.isNotEmpty((Collection)detailList) && StringUtils.isNotEmpty((CharSequence)((CostStatisticDetailVO)detailList.get(detailList.size() - 1)).getDetailIndex()) ? Integer.valueOf(((CostStatisticDetailVO)detailList.get(detailList.size() - 1)).getDetailIndex().contains(".") ? Integer.parseInt(((CostStatisticDetailVO)detailList.get(detailList.size() - 1)).getDetailIndex().split("\\.")[0]) + 1 : Integer.parseInt(((CostStatisticDetailVO)detailList.get(detailList.size() - 1)).getDetailIndex()) + 1) : Integer.valueOf(1);
            Integer index = 0;
            for (CostStatisticDetailVO costStatisticDetailVO : noRelationList) {
                String code;
                if (costStatisticDetailVO.getParentId() == null) {
                    costStatisticDetailVO.setDetailIndex(detailIndex + "");
                    code = "0" + detailIndex;
                    costStatisticDetailVO.setSubjectCode(code);
                    continue;
                }
                index = index + 1;
                costStatisticDetailVO.setDetailIndex(detailIndex + "." + index);
                code = "0" + detailIndex + "0" + index;
                costStatisticDetailVO.setSubjectCode(code);
            }
            Collections.sort(noRelationList, new CostDetailProComparatoeVo());
            List costStatisticDetailVOS = TreeNodeBUtil.buildTree(noRelationList);
            detailList.addAll(costStatisticDetailVOS);
        }
        CostAmountVO vo = this.service.queryCostSumMny(projectId);
        CommonResponse commonResponse = this.projectApi.queryProjectDetail(projectId);
        if (commonResponse.isSuccess()) {
            costStatisticVO.setProjectName(((ProjectRegisterVO)commonResponse.getData()).getName());
            costStatisticVO.setProjectId(projectId);
        }
        if (vo != null) {
            costStatisticVO.setLaborTaxMnyCost(vo.getLaborTaxMnyCost());
            costStatisticVO.setMaterialTaxMnyCost(vo.getMaterialTaxMnyCost());
            costStatisticVO.setMajorTaxMnyCost(vo.getMajorTaxMnyCost());
            costStatisticVO.setMechanicalTaxMnyCost(vo.getMechanicalTaxMnyCost());
            costStatisticVO.setIndirectionTaxMnyCost(vo.getIndirectionTaxMnyCost());
            BigDecimal sum = ComputeUtil.safeAdd((BigDecimal)costStatisticVO.getLaborTaxMnyCost(), (BigDecimal[])new BigDecimal[]{costStatisticVO.getMaterialTaxMnyCost(), costStatisticVO.getMajorTaxMnyCost(), costStatisticVO.getMechanicalTaxMnyCost(), costStatisticVO.getIndirectionTaxMnyCost()});
            costStatisticVO.setLastTaxMnyCost(sum);
        }
        if ((budgetVo = this.service.queryBudgetSumMny(projectId)) != null) {
            costStatisticVO.setLaborTaxMny(budgetVo.getLaborTaxMny());
            costStatisticVO.setMaterialTaxMny(budgetVo.getMaterialTaxMny());
            costStatisticVO.setMajorTaxMny(budgetVo.getMajorTaxMny());
            costStatisticVO.setMechanicalTaxMny(budgetVo.getMechanicalTaxMny());
            costStatisticVO.setIndirectionTaxMny(budgetVo.getIndirectionTaxMny());
            BigDecimal sum = ComputeUtil.safeAdd((BigDecimal)costStatisticVO.getLaborTaxMny(), (BigDecimal[])new BigDecimal[]{costStatisticVO.getMaterialTaxMny(), costStatisticVO.getMajorTaxMny(), costStatisticVO.getMechanicalTaxMny(), costStatisticVO.getIndirectionTaxMny()});
            costStatisticVO.setBudgetTaxMny(sum);
        }
        costStatisticVO.setLastTaxMnyCostRatio(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)costStatisticVO.getLastTaxMnyCost(), (BigDecimal)costStatisticVO.getBudgetTaxMny()), (BigDecimal)new BigDecimal(100)));
        costStatisticVO.setLaborTaxMnyCostRatio(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)costStatisticVO.getLaborTaxMnyCost(), (BigDecimal)costStatisticVO.getLaborTaxMny()), (BigDecimal)new BigDecimal(100)));
        costStatisticVO.setMaterialTaxMnyCostRatio(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)costStatisticVO.getMaterialTaxMnyCost(), (BigDecimal)costStatisticVO.getMaterialTaxMny()), (BigDecimal)new BigDecimal(100)));
        costStatisticVO.setMajorTaxMnyCostRatio(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)costStatisticVO.getMajorTaxMnyCost(), (BigDecimal)costStatisticVO.getMajorTaxMny()), (BigDecimal)new BigDecimal(100)));
        costStatisticVO.setMechanicalTaxMnyCostRatio(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)costStatisticVO.getMechanicalTaxMnyCost(), (BigDecimal)costStatisticVO.getMechanicalTaxMny()), (BigDecimal)new BigDecimal(100)));
        costStatisticVO.setIndirectionTaxMnyCostRatio(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)costStatisticVO.getIndirectionTaxMnyCost(), (BigDecimal)costStatisticVO.getIndirectionTaxMny()), (BigDecimal)new BigDecimal(100)));
        costStatisticVO.setDetailList(detailList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)costStatisticVO);
    }

    private List<CostStatisticDetailVO> setParentMnyAndNUm(List<CostStatisticDetailVO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<Long, CostStatisticDetailVO> map = list.stream().collect(Collectors.toMap(k -> k.getId(), k -> k));
            for (CostStatisticDetailVO costStatisticDetailVO : list) {
                if (costStatisticDetailVO.getLeafFlag().booleanValue()) continue;
                List<Long> ids = new ArrayList<Long>();
                Long id = costStatisticDetailVO.getId();
                ids = this.getChildrenIds(id, ids);
                for (Long aLong : ids) {
                    if (!map.containsKey(aLong)) continue;
                    costStatisticDetailVO.setCostTaxMny(ComputeUtil.safeAdd((BigDecimal)costStatisticDetailVO.getCostTaxMny(), (BigDecimal)map.get(aLong).getCostTaxMny()));
                    costStatisticDetailVO.setBudgetTaxMny(ComputeUtil.safeAdd((BigDecimal)costStatisticDetailVO.getBudgetTaxMny(), (BigDecimal)map.get(aLong).getBudgetTaxMny()));
                    if (costStatisticDetailVO.getCostTaxMny() == null) continue;
                    costStatisticDetailVO.setCostBugetRatio(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)costStatisticDetailVO.getCostTaxMny(), (BigDecimal)costStatisticDetailVO.getBudgetTaxMny()), (BigDecimal)new BigDecimal(100)));
                }
            }
        }
        return list;
    }

    private List<Long> getChildrenIds(Long id, List<Long> ids) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"parent_id", (Object)id);
        List list = this.service.list((Wrapper)objectQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (SubjectEntity entity : list) {
                if (entity.getLeafFlag().booleanValue()) {
                    ids.add(entity.getId());
                    continue;
                }
                this.getChildrenIds(entity.getId(), ids);
            }
        }
        return ids;
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        CommonResponse<CostStatisticVO> costStatisticVOCommonResponse = this.queryCostStatist(param);
        List<Object> detailList = new ArrayList();
        if (costStatisticVOCommonResponse.isSuccess()) {
            CostStatisticVO data = (CostStatisticVO)costStatisticVOCommonResponse.getData();
            detailList = this.treeToList(data.getDetailList());
        }
        HashMap beans = new HashMap();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("costStatistic-export.xlsx", beans, response);
    }

    private List<CostStatisticDetailVO> treeToList(List<CostStatisticDetailVO> values) {
        ArrayList<CostStatisticDetailVO> result = new ArrayList<CostStatisticDetailVO>();
        for (CostStatisticDetailVO value : values) {
            result.add(value);
            if (value.getChildren().isEmpty()) continue;
            List child = BeanMapper.mapList((Iterable)value.getChildren(), CostStatisticDetailVO.class);
            List<CostStatisticDetailVO> entityList = this.treeToList(child);
            result.addAll(entityList);
        }
        if (result.size() > 0) {
            for (CostStatisticDetailVO value : result) {
                value.setChildren(null);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(ComputeUtil.safeDiv((BigDecimal)new BigDecimal(5), (BigDecimal)new BigDecimal(0)));
    }
}

