package com.ejianc.business.budget.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 预算类型
 */
public enum BudgetTypeEnum {
    中标预算(1, "中标预算"),
    施工图预算(2, "施工图预算"),
    结算预算(3, "结算预算"),
    签证(4, "签证"),
    其他(5, "其他");

    private Integer code;
    private String description;
    private static Map<Integer, BudgetTypeEnum> enumMap = new HashMap<>();

    BudgetTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(BudgetTypeEnum.class).stream().collect(Collectors.toMap(BudgetTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static BudgetTypeEnum getEnumByCode(Integer code) {
        return enumMap.get(code);
    }

}

