/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.cost.bean.CostDetailEntity;
import com.ejianc.business.cost.mapper.CostDetailMapper;
import com.ejianc.business.cost.service.ICostDetailService;
import com.ejianc.business.cost.vo.CostSquareChartVO;
import com.ejianc.business.cost.vo.ProjectReportVo;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="costDetailService")
public class CostDetailServiceImpl
extends BaseServiceImpl<CostDetailMapper, CostDetailEntity>
implements ICostDetailService {
    @Resource
    private IBudgetProjectProService budgetProjectProService;
    @Resource
    private IIncomeContractApi incomeContractApi;

    @Override
    public boolean deleteCostDetail(Long id) {
        return ((CostDetailMapper)this.baseMapper).deleteCostDetail(id);
    }

    @Override
    public List<ProjectReportVo> getCostMonth(Long projectId) {
        return ((CostDetailMapper)this.baseMapper).getCostMonth(projectId);
    }

    @Override
    public LinkedHashMap<String, BigDecimal> costSquareChart(Long projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal sumRgfCostMny = BigDecimal.ZERO;
        BigDecimal sumJxfCostMny = BigDecimal.ZERO;
        BigDecimal sumClfCostMny = BigDecimal.ZERO;
        BigDecimal sumZyfbfCostMny = BigDecimal.ZERO;
        BigDecimal sumOtherCostMny = BigDecimal.ZERO;
        CostSquareChartVO costSquareChartVO = ((CostDetailMapper)this.baseMapper).getSumClfCostMny(projectId);
        sumRgfCostMny = costSquareChartVO.getLaborTaxMnyCost();
        sumClfCostMny = costSquareChartVO.getMaterialTaxMnyCost();
        sumZyfbfCostMny = costSquareChartVO.getMajorTaxMnyCost();
        sumJxfCostMny = costSquareChartVO.getMechanicalTaxMnyCost();
        sumOtherCostMny = costSquareChartVO.getIndirectionTaxMnyCost();
        QueryWrapper wrapper1 = Wrappers.query();
        ((QueryWrapper)((QueryWrapper)wrapper1.select(new String[]{"ifnull(sum(budget_tax_mny), 0) as mny"}).eq((Object)"dr", (Object)0)).in((Object)"bill_state", new Object[]{1, 3})).eq((Object)"project_id", (Object)projectId);
        Map map = this.budgetProjectProService.getMap((Wrapper)wrapper1);
        BigDecimal targetCostMny = new BigDecimal(map.get("mny").toString());
        BigDecimal sumAllCostMny = ComputeUtil.safeAdd((BigDecimal)sumRgfCostMny, (BigDecimal[])new BigDecimal[]{sumClfCostMny, sumZyfbfCostMny, sumJxfCostMny, sumOtherCostMny});
        CommonResponse response = this.incomeContractApi.costSquareChart(projectId);
        if (!response.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u5408\u540c\u9020\u4ef7\u3001\u5de5\u7a0b\u7ed3\u7b97\u603b\u4ef7\u5931\u8d25");
        }
        Map data = (Map)response.getData();
        BigDecimal sumContractMny = (BigDecimal)data.get("sumContractMny");
        BigDecimal sumSettleMny = (BigDecimal)data.get("sumSettleMny");
        BigDecimal jjxyMny = ComputeUtil.safeSub((BigDecimal)sumContractMny, (BigDecimal)targetCostMny);
        BigDecimal glxyMny = ComputeUtil.safeSub((BigDecimal)targetCostMny, (BigDecimal)sumAllCostMny);
        BigDecimal jsxyMny = ComputeUtil.safeSub((BigDecimal)sumSettleMny, (BigDecimal)sumContractMny);
        LinkedHashMap<String, BigDecimal> linkedHashMap = new LinkedHashMap<String, BigDecimal>();
        linkedHashMap.put("sumRgfCostTaxMny", sumRgfCostMny);
        linkedHashMap.put("sumJxfCostTaxMny", sumJxfCostMny);
        linkedHashMap.put("sumClfCostTaxMny", sumClfCostMny);
        linkedHashMap.put("sumZyfbfCostTaxMny", sumZyfbfCostMny);
        linkedHashMap.put("sumOtherCostTaxMny", sumOtherCostMny);
        linkedHashMap.put("sumContractTaxMny", sumContractMny);
        linkedHashMap.put("targetCostTaxMny", targetCostMny);
        linkedHashMap.put("sumAllCostTaxMny", sumAllCostMny);
        linkedHashMap.put("sumSettleTaxMny", sumSettleMny);
        linkedHashMap.put("jjxyTaxMny", jjxyMny);
        linkedHashMap.put("glxyTaxMny", glxyMny);
        linkedHashMap.put("jsxyTaxMny", jsxyMny);
        return linkedHashMap;
    }
}

