/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.bean.BudgetProjectHistoryProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectHistoryProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.BudgetCostVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailReferenProVO;
import com.ejianc.business.budget.vo.BudgetProjectHistoryProVO;
import com.ejianc.business.budget.vo.BudgetProjectProVO;
import com.ejianc.business.budget.vo.CostSubjectVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailProComparatoeVo;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialInsertArchiveVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetProjectPro"})
public class BudgetProjectProController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PROJECT_BUDGET_PRO_CODE";
    @Autowired
    private IBudgetProjectProService service;
    @Autowired
    private IBudgetProjectDetailProService detailsService;
    @Autowired
    private ICommonBusinessService budgetProjectPro;
    @Autowired
    private ICommonBusinessService budgetProjectChangePro;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IBudgetProjectService budgetProjectService;
    @Autowired
    private IBudgetProjectHistoryProService historyProService;

    @RequestMapping(value={"/refBudgetProjectPro"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectProVO>> refBudgetProjectPro(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().addAll(Arrays.asList("projectName", "employeeName", "departmentName"));
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectProVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getBudgetProjectDetailProDataAndSum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<BudgetProjectDetailProVO>> getBudgetProjectDetailProDataAndSum(@RequestParam Long projectId) {
        List list = this.service.getBudgetProjectDetailProDataAndSum(projectId);
        for (BudgetProjectDetailProVO vo : list) {
            vo.setTid(vo.getId().toString());
            vo.setTpid(vo.getParentId() != null && vo.getParentId() > 0L ? vo.getParentId().toString() : "");
        }
        Collections.sort(list, new BudgetDetailProComparatoeVo());
        list = TreeNodeBUtil.buildTree(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u9884\u7b97\u660e\u7ec6\u6570\u636e\u6210\u529f\uff01", (Object)list);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetProjectProVO> saveOrUpdate(@RequestBody BudgetProjectProVO saveOrUpdateVO) {
        BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BudgetProjectProEntity.class));
        this.service.beforeSaveCheck(entity.getDetailList());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        List<BudgetProjectDetailProEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map data;
            MaterialInsertArchiveVO archiveVO;
            CommonResponse listCommonResponse;
            MaterialVO materialVO;
            HashMap<String, MaterialVO> materialVOMap = new HashMap<String, MaterialVO>();
            Map archiveMap = new HashMap();
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (BudgetProjectDetailProEntity cdEntity : detailList) {
                if (null != cdEntity.getCostType() && 2 == cdEntity.getCostType() && cdEntity.getMatchStatus() != null && cdEntity.getMatchStatus() != 1) {
                    materialVO = new MaterialVO();
                    materialVO.setCategoryName(cdEntity.getCategoryName());
                    materialVO.setName(cdEntity.getMaterialName());
                    materialVO.setSpec(cdEntity.getSpec());
                    materialVO.setUnitName(cdEntity.getUnit());
                    materialVO.setType(Integer.valueOf(1));
                    String key = cdEntity.getName() + (cdEntity.getCostType() != null ? cdEntity.getCostType() : "") + cdEntity.getCategoryName() + cdEntity.getSpec() + cdEntity.getUnit();
                    cdEntity.setKey(key);
                    materialVOMap.put(key, materialVO);
                }
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            if (materialVOMap != null && (listCommonResponse = this.materialApi.batchInsertArchiveBySourceBill(archiveVO = new MaterialInsertArchiveVO(materialVOMap, entity.getId(), entity.getBillCode(), entity.getProjectName(), "\u76ee\u6807\u6210\u672c"))).isSuccess() && (data = (Map)listCommonResponse.getData()) != null) {
                archiveMap = data;
            }
            for (BudgetProjectDetailProEntity cdEntity : detailList) {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
                if (archiveMap != null && (materialVO = (MaterialVO)archiveMap.get(cdEntity.getKey())) != null) {
                    cdEntity.setCategoryId(materialVO.getCategoryId());
                    cdEntity.setMaterialId(materialVO.getId());
                    cdEntity.setCategoryId(materialVO.getCategoryId());
                    cdEntity.setCode(materialVO.getCode());
                    cdEntity.setMatchStatus(1);
                    cdEntity.setMatchStatusDescription("\u5df2\u5339\u914d");
                }
                if (cdEntity.getCostType() != null && cdEntity.getCostType() != 0) {
                    cdEntity.setCostTypeName(CostTypeEnum.getEnumByType((Integer)cdEntity.getCostType()).getName());
                }
                cdEntity.setSubjectId(cdEntity.getId());
                String subjectName = cdEntity.getName();
                if (cdEntity.getMaterialId() != null && StringUtils.isNotEmpty((CharSequence)cdEntity.getSpec())) {
                    subjectName = subjectName + " [" + cdEntity.getSpec() + "]";
                }
                cdEntity.setSubjectName(subjectName);
                cdEntity.setSubjectCode(cdEntity.getCode());
            }
            entity.setDetailList(detailList);
            this.detailsService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
        BudgetProjectProVO vo = (BudgetProjectProVO)BeanMapper.map((Object)((Object)entity), BudgetProjectProVO.class);
        List list = BeanMapper.mapList(detailList, BudgetProjectDetailProVO.class);
        Collections.sort(list, new BudgetDetailProComparatoeVo());
        vo.setDetailList(TreeNodeBUtil.buildTree((List)list));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectProVO> queryDetail(Long id) {
        BudgetProjectProVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/compareDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectProVO> compareDetail(@RequestParam(value="id") Long id, @RequestParam(value="compareFirst", required=false, defaultValue="false") Boolean compareFirst, @RequestParam(value="compareIndex", required=false) Integer compareIndex) {
        BudgetProjectProVO budgetProjectProVO = this.service.compareDetail(id, compareFirst, compareIndex);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)budgetProjectProVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectProVO> vos) {
        List list;
        List mainIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List entities = (List)this.service.listByIds(mainIds);
        List longs = entities.stream().filter(x -> null != x.getSourceId()).map(BudgetProjectProEntity::getSourceId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(longs) && CollectionUtils.isNotEmpty((Collection)(list = (List)this.budgetProjectService.listByIds(longs)))) {
            for (BudgetProjectEntity entity : list) {
                entity.setTargetId(null);
            }
            this.budgetProjectService.saveOrUpdateBatch(list);
        }
        this.service.removeByIds(mainIds, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectProVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectProVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            block5: for (BudgetProjectProEntity entity : list) {
                entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)entity.getBillState()).getDescription());
                switch (entity.getChangeStatus()) {
                    case 1: {
                        entity.setChangeStatusName("\u672a\u53d8\u66f4");
                        continue block5;
                    }
                    case 2: {
                        entity.setChangeStatusName("\u53d8\u66f4\u4e2d");
                        continue block5;
                    }
                    case 3: {
                        entity.setChangeStatusName("\u5df2\u53d8\u66f4");
                        continue block5;
                    }
                }
                entity.setChangeStatusName("");
            }
        }
        ExcelExport.getInstance().export("BudgetProjectPro-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBudgetProjectProData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailReferenProVO>> refBudgetProjectProData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unit");
        String costType = null;
        Long projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"projectId") != null) {
                projectId = Long.parseLong(_con.get((Object)"projectId").toString());
            }
            if (_con.get((Object)"costType") != null) {
                costType = _con.get((Object)"costType").toString();
            }
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.orderByAsc((Object)"orderId");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<BudgetProjectDetailReferenProVO> list = this.service.queryDetailList((Page<BudgetProjectDetailReferenProVO>)page, wrapper, projectId, costType);
        Map<Long, BudgetProjectDetailReferenProVO> collect = list.stream().collect(Collectors.toMap(BudgetProjectDetailReferenProVO::getMaterialId, e -> e, (item1, item2) -> item1));
        List materialIds = collect.keySet().stream().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(materialIds)) {
            CommonResponse queryMaterialResponse = this.materialApi.queryMaterialByIds(materialIds);
            if (queryMaterialResponse.isSuccess()) {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)queryMaterialResponse.getData()))) {
                    for (BudgetProjectDetailReferenProVO data : list) {
                        for (MaterialVO vo : (List)queryMaterialResponse.getData()) {
                            if (!data.getMaterialId().equals(vo.getId())) continue;
                            data.setMaterialCode(vo.getCode());
                        }
                    }
                }
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u83b7\u53d6\u7269\u8d44\u7f16\u7801\u5931\u8d25");
            }
        }
        page.setRecords(list);
        page.setTotal(page.getTotal());
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/refotherBudgetProjectProData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailReferenProVO>> refotherBudgetProjectProData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("spec");
        fuzzyFields.add("unit");
        String costType = null;
        Long projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"projectId") != null) {
                projectId = Long.parseLong(_con.get((Object)"projectId").toString());
            }
            if (_con.get((Object)"costType") != null) {
                costType = _con.get((Object)"costType").toString();
            }
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.orderByDesc((Object)"tax_mny");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<BudgetProjectDetailReferenProVO> list = this.service.queryOtherDetailList((Page<BudgetProjectDetailReferenProVO>)page, wrapper, projectId, costType);
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/refSubBudgetProjectProData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailProVO>> refSubBudgetProjectProData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("spec");
        fuzzyFields.add("unit");
        String costType = null;
        Long projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"projectId") != null) {
                projectId = Long.parseLong(_con.get((Object)"projectId").toString());
            }
            if (_con.get((Object)"costType") != null) {
                costType = _con.get((Object)"costType").toString();
            }
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List list = this.service.querySubDetailList((Page<BudgetProjectDetailProVO>)page, wrapper, projectId, costType);
        if (CollectionUtils.isNotEmpty(list)) {
            List detailProVOS = BeanMapper.mapList(list, BudgetProjectDetailProVO.class);
            List<BudgetProjectDetailProVO> parentList = new ArrayList<BudgetProjectDetailProVO>();
            parentList = this.getParent(detailProVOS, parentList);
            list.addAll(parentList);
            for (BudgetProjectDetailProVO vo : list) {
                vo.setTid(vo.getId().toString());
                vo.setTpid(vo.getParentId() != null && vo.getParentId() > 0L ? vo.getParentId().toString() : "");
            }
            Collections.sort(list, new BudgetDetailProComparatoeVo());
            list = TreeNodeBUtil.buildTree(list);
        }
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private List<BudgetProjectDetailProVO> getParent(List<BudgetProjectDetailProVO> detailProVOS, List<BudgetProjectDetailProVO> parentList) {
        List ids = detailProVOS.stream().filter(s -> s.getParentId() != null).map(BudgetProjectDetailProVO::getParentId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryWrapper objectQueryWrapper = new QueryWrapper();
            objectQueryWrapper.in((Object)"id", ids);
            List parentDetailProEntities = this.budgetProjectDetailProService.list((Wrapper)objectQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)parentDetailProEntities)) {
                List list = BeanMapper.mapList((Iterable)parentDetailProEntities, BudgetProjectDetailProVO.class);
                parentList.addAll(list);
                this.getParent(list, parentList);
            }
        }
        parentList = parentList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BudgetProjectDetailProVO>(Comparator.comparing(BaseVO::getId))), ArrayList::new));
        return parentList;
    }

    @RequestMapping(value={"/checkProjectBudget"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkProjectBudget(Long projectId, Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.ne(id != null, (Object)"id", (Object)id);
        int count = this.service.count((Wrapper)queryWrapper);
        if (count > 0) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u5df2\u7f16\u5236\u9879\u76ee\u9884\u7b97\u5355\u636e\uff0c\u8bf7\u5728\u539f\u5355\u636e\u4e0a\u4fee\u6539\u6216\u8005\u53d8\u66f4\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u5df2\u7f16\u5236\u9879\u76ee\u9884\u7b97\u5355\u636e\uff0c\u8bf7\u5728\u539f\u5355\u636e\u4e0a\u4fee\u6539\u6216\u8005\u53d8\u66f4\uff01");
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectProVO> test(Long id) {
        this.budgetProjectPro.afterApprovalProcessor(id, Integer.valueOf(0), "BT202209000001");
        BudgetProjectProVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/changeTest"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectProVO> changeTest(Long id) {
        this.budgetProjectChangePro.afterApprovalProcessor(id, Integer.valueOf(0), "BT202209000002");
        Object vo = null;
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", vo);
    }

    @RequestMapping(value={"/queryOnlySuject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetCostVO> queryOnlySuject(@RequestBody BudgetCostVO budgetCostVO) {
        List<BudgetProjectDetailProVO> list;
        Long projectId = budgetCostVO.getProjectId();
        Integer costType = budgetCostVO.getCostType();
        Map subjectMap = budgetCostVO.getSubjectMap();
        Set<Long> subjectIds = subjectMap.keySet();
        if (projectId != null && costType != null && CollectionUtils.isNotEmpty(subjectIds) && CollectionUtils.isNotEmpty(list = this.service.queryOnlySuject(projectId, costType, subjectIds))) {
            Map<Long, BudgetProjectDetailProVO> detailMap = list.stream().collect(Collectors.toMap(k -> k.getSubjectId(), k -> k));
            Map<Long, List<BudgetProjectDetailProVO>> materialMap = list.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(BudgetProjectDetailProVO::getMaterialId));
            for (Long key : subjectMap.keySet()) {
                CostSubjectVO costSubjectVO = (CostSubjectVO)subjectMap.get(key);
                BudgetProjectDetailProVO vo = detailMap.get(key) != null ? detailMap.get(key) : null;
                List<BudgetProjectDetailProVO> materialvos = materialMap.get(key);
                if (CollectionUtils.isNotEmpty(materialvos) && materialvos.size() == 1) {
                    vo = materialvos.get(0);
                }
                if (vo != null) {
                    costSubjectVO.setSubjectId(vo.getSubjectId());
                    costSubjectVO.setSubjectCode(vo.getSubjectCode());
                    costSubjectVO.setSubjectName(vo.getSubjectName());
                    costSubjectVO.setCostType(vo.getCostType());
                    continue;
                }
                costSubjectVO.setSubjectId(null);
                costSubjectVO.setSubjectName(null);
                costSubjectVO.setSubjectCode(null);
                costSubjectVO.setCostType(null);
            }
            budgetCostVO.setSubjectMap(subjectMap);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u672c\u79d1\u76ee\u662f\u5426\u552f\u4e00\uff01", (Object)budgetCostVO);
    }

    public static void main(String[] args) {
        BudgetCostVO costVO = new BudgetCostVO();
        costVO.setProjectId(Long.valueOf(1L));
        costVO.setCostType(Integer.valueOf(2));
        HashMap<Long, CostSubjectVO> objectObjectHashMap = new HashMap<Long, CostSubjectVO>();
        CostSubjectVO costSubjectVO = new CostSubjectVO();
        costSubjectVO.setSubjectId(Long.valueOf(1L));
        costSubjectVO.setSubjectCode("\u6d4b\u8bd5");
        costSubjectVO.setSubjectName("jc");
        objectObjectHashMap.put(1L, costSubjectVO);
        costVO.setSubjectMap(objectObjectHashMap);
        System.out.println(JSONObject.toJSONString((Object)costVO));
    }

    @RequestMapping(value={"/handleCostDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectProVO> handleCostDetail(Long id) {
        BudgetProjectProVO vo = this.service.queryDetail(id);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BudgetProjectDetailProEntity::getBudgetId, (Object)id);
        wrapper.isNull(BudgetProjectDetailProEntity::getMaterialId);
        wrapper.isNotNull(BudgetProjectDetailProEntity::getMaterialName);
        wrapper.isNotNull(BudgetProjectDetailProEntity::getCategoryName);
        List detailList = this.detailsService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            Map data;
            MaterialInsertArchiveVO archiveVO;
            CommonResponse listCommonResponse;
            MaterialVO materialVO;
            HashMap<String, MaterialVO> materialVOMap = new HashMap<String, MaterialVO>();
            Map archiveMap = new HashMap();
            for (BudgetProjectDetailProEntity cdEntity : detailList) {
                if (null == cdEntity.getCostType() || 2 != cdEntity.getCostType() || cdEntity.getMatchStatus() == null || cdEntity.getMatchStatus() == 1) continue;
                materialVO = new MaterialVO();
                materialVO.setCategoryName(cdEntity.getCategoryName());
                materialVO.setName(cdEntity.getMaterialName());
                materialVO.setSpec(cdEntity.getSpec());
                materialVO.setUnitName(cdEntity.getUnit());
                materialVO.setType(Integer.valueOf(1));
                String key = cdEntity.getName() + (cdEntity.getCostType() != null ? cdEntity.getCostType() : "") + cdEntity.getCategoryName() + cdEntity.getSpec() + cdEntity.getUnit();
                cdEntity.setKey(key);
                materialVOMap.put(key, materialVO);
            }
            if (materialVOMap != null && (listCommonResponse = this.materialApi.batchInsertArchiveBySourceBill(archiveVO = new MaterialInsertArchiveVO(materialVOMap, vo.getId(), vo.getBillCode(), vo.getProjectName(), "\u76ee\u6807\u6210\u672c"))).isSuccess() && (data = (Map)listCommonResponse.getData()) != null) {
                archiveMap = data;
            }
            for (BudgetProjectDetailProEntity cdEntity : detailList) {
                if (archiveMap != null && (materialVO = (MaterialVO)archiveMap.get(cdEntity.getKey())) != null) {
                    cdEntity.setCategoryId(materialVO.getCategoryId());
                    cdEntity.setMaterialId(materialVO.getId());
                    cdEntity.setCode(materialVO.getCode());
                    cdEntity.setMatchStatus(1);
                    cdEntity.setMatchStatusDescription("\u5df2\u5339\u914d");
                }
                if (cdEntity.getCostType() != null && cdEntity.getCostType() != 0) {
                    cdEntity.setCostTypeName(CostTypeEnum.getEnumByType((Integer)cdEntity.getCostType()).getName());
                }
                cdEntity.setSubjectId(cdEntity.getId());
                String subjectName = cdEntity.getName();
                if (cdEntity.getMaterialId() != null && StringUtils.isNotEmpty((CharSequence)cdEntity.getSpec())) {
                    subjectName = subjectName + " [" + cdEntity.getSpec() + "]";
                }
                cdEntity.setSubjectName(subjectName);
                cdEntity.setSubjectCode(cdEntity.getCode());
            }
            this.detailsService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/refBudgetProjectProDataTwo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailReferenProVO>> refBudgetProjectProDataTwo(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unit");
        String costType = null;
        Long projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"projectId") != null) {
                projectId = Long.parseLong(_con.get((Object)"projectId").toString());
            }
            if (_con.get((Object)"costType") != null) {
                costType = _con.get((Object)"costType").toString();
            }
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.orderByAsc((Object)"orderId");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<BudgetProjectDetailReferenProVO> list = this.service.queryDetailList((Page<BudgetProjectDetailReferenProVO>)page, wrapper, projectId, costType);
        Map<Long, BudgetProjectDetailReferenProVO> collect = list.stream().collect(Collectors.toMap(BudgetProjectDetailReferenProVO::getMaterialId, e -> e, (item1, item2) -> item1));
        List materialIds = collect.keySet().stream().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(materialIds)) {
            CommonResponse queryMaterialResponse = this.materialApi.queryMaterialByIds(materialIds);
            if (queryMaterialResponse.isSuccess()) {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)queryMaterialResponse.getData()))) {
                    for (BudgetProjectDetailReferenProVO data : list) {
                        for (MaterialVO vo : (List)queryMaterialResponse.getData()) {
                            if (!data.getMaterialId().equals(vo.getId())) continue;
                            data.setMaterialCode(vo.getCode());
                        }
                    }
                }
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u83b7\u53d6\u7269\u8d44\u7f16\u7801\u5931\u8d25");
            }
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (BudgetProjectDetailReferenProVO data : list) {
                data.setTaxPrice(null);
                data.setTaxMny(null);
            }
        }
        page.setRecords(list);
        page.setTotal(page.getTotal());
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryBudgetProjectProHistoryById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<BudgetProjectHistoryProVO>> queryBudgetProjectProHistoryById(Long id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BudgetProjectHistoryProEntity::getBudgetId, (Object)id);
        List list = this.historyProService.list((Wrapper)queryWrapper);
        List voList = BeanMapper.mapList((Iterable)list, BudgetProjectHistoryProVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u5386\u53f2\u5217\u8868\u6210\u529f\uff01", (Object)voList);
    }
}

