/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.budget.query.BudgetProjectProExportQuery;
import com.ejianc.business.budget.service.IBudgetProjectProExportService;
import com.ejianc.business.budget.utils.ExportExcelUtil;
import com.ejianc.business.budget.vo.BudgetProjectProExportVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetProjectProExportPerson"})
public class BudgetProjectProExportController {
    @Autowired
    private IBudgetProjectProExportService budgetProjectProExportService;

    @RequestMapping(value={"/queryBudgetProjectProExportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectProExportVO>> queryBudgetProjectProExportList(@RequestBody BudgetProjectProExportQuery query) {
        IPage<BudgetProjectProExportVO> page = this.budgetProjectProExportService.queryBudgetProjectProExportList(query);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelReportExport(@RequestBody BudgetProjectProExportQuery query, HttpServletResponse response) {
        query.setDisAblePage(true);
        IPage<BudgetProjectProExportVO> list = this.budgetProjectProExportService.queryBudgetProjectProExportList(query);
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        if (CollectionUtils.isNotEmpty((Collection)list.getRecords())) {
            for (BudgetProjectProExportVO item : list.getRecords()) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(item.getProjectName());
                row.add(item.getEmployeeName());
                row.add(item.getDepartmentName());
                row.add(item.getTaxRate());
                row.add(item.getMaterialMny());
                row.add(item.getLaborMny());
                row.add(item.getIndirectionMny());
                row.add(item.getMechanicalMny());
                row.add(item.getMaterialTaxMny());
                row.add(item.getLaborTaxMny());
                row.add(item.getIndirectionTaxMny());
                row.add(item.getMechanicalTaxMny());
                row.add(item.getBudgetMny());
                row.add(item.getBudgetTaxMny());
                row.add(item.getMemo());
                data.add(row);
            }
        }
        String fileName = "budgetProjectProExportPerson" + DateUtil.now() + ".xlsx";
        Integer skipRows = 2;
        if (CollectionUtils.isNotEmpty(data)) {
            int index = 1;
            for (List list2 : data) {
                list2.add(0, index++);
            }
        }
        ExportExcelUtil.export("BudgetProjectProExportPerson-export.xlsx", skipRows, fileName, data, null, response);
    }
}

