/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.bean.QuotaDetailTemporaryEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.service.IQuotaDetailTemporaryService;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.bean.SettingEntity;
import com.ejianc.business.cost.bean.SubjectEntity;
import com.ejianc.business.cost.service.ISettingService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectPro")
public class BudgetProjectProBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBudgetProjectProService service;
    @Autowired
    private IBudgetProjectProService budgetProjectProService;
    @Autowired
    private ISettingService settingService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String materialInCostCode = "P-97949U38";
    private static final String TaxInCostCode = "P-BP0a7Z39";
    private static final String budgetPushCost = "P-340m7240";
    @Autowired
    private IBudgetProjectDetailProService detailProService;
    @Autowired
    private IQuotaDetailTemporaryService quotaDetailTemporaryService;
    private static final String PARAM_TEMP_LBOR_CODE = "P-7d32tl03";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return this.beforeSubmitCheck(billId);
    }

    private CommonResponse<String> beforeSubmitCheck(Long billId) {
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BudgetProjectDetailProEntity::getBudgetId, (Object)billId);
        lambdaQuery.eq(BudgetProjectDetailProEntity::getLeafFlag, (Object)1);
        lambdaQuery.and(t -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.isNull(BudgetProjectDetailProEntity::getNum)).or()).isNull(BudgetProjectDetailProEntity::getPrice));
        List list = this.detailProService.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BudgetProjectDetailProEntity detailProEntity = (BudgetProjectDetailProEntity)((Object)list.get(0));
            return CommonResponse.error((String)("\u6210\u672c\u6e05\u5355\u3010\u7f16\u7801\uff1a" + detailProEntity.getCode() + "\uff0c\u540d\u79f0\uff1a" + detailProEntity.getName() + "\u3011\u7684\u5de5\u7a0b\u91cf\u548c\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        CommonResponse byCodeLabor = this.paramConfigApi.getByCode(PARAM_TEMP_LBOR_CODE);
        if (byCodeLabor.isSuccess() && null != byCodeLabor.getData() && StringUtils.isNotEmpty((CharSequence)(valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCodeLabor.getData()).getValueData())) && valueData.equals("\u5426")) {
            LambdaQueryWrapper detailProEntityLambdaQueryWrapper = new LambdaQueryWrapper();
            detailProEntityLambdaQueryWrapper.eq(BudgetProjectDetailProEntity::getBudgetId, (Object)billId);
            detailProEntityLambdaQueryWrapper.eq(BudgetProjectDetailProEntity::getCostType, (Object)CostTypeEnum.LABOR_COST_TYPE.getType());
            detailProEntityLambdaQueryWrapper.isNull(BudgetProjectDetailProEntity::getSourceId);
            List matchList = this.detailProService.list((Wrapper)detailProEntityLambdaQueryWrapper);
            ArrayList<String> detailIndexList = new ArrayList<String>();
            for (BudgetProjectDetailProEntity detailProEntity : matchList) {
                detailIndexList.add(detailProEntity.getDetailIndex());
            }
            if (!detailIndexList.isEmpty()) {
                String detailIndexStr = String.join((CharSequence)",", detailIndexList);
                return CommonResponse.error((String)("\u6821\u9a8c\u5931\u8d25(\u6709" + detailIndexList.size() + "\u6761\u65b0\u589e\u4eba\u5de5\u8d39\u4e34\u65f6\u5b9a\u989d)\uff0c\u5e8f\u53f7\u4e3a[ " + detailIndexStr + " ]\uff0c\u53c2\u6570\u3010\u4e34\u65f6\u5b9a\u989d\u5e93\u662f\u5426\u5f00\u542f\u3011\u672a\u5f00\u542f\uff0c\u8bf7\u5c06\u65b0\u589e\u4e34\u65f6\u5b9a\u989d\u5904\u7406\u540e\u91cd\u65b0\u64cd\u4f5c\uff01"));
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)this.service.selectById(billId));
        QueryWrapper settingQueryWrapper = new QueryWrapper();
        settingQueryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        List list = this.settingService.list((Wrapper)settingQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (SettingEntity settingEntity : list) {
                Integer pushFlag = settingEntity.getPushFlag();
                if (pushFlag != null && pushFlag != 0) continue;
                return CommonResponse.error((String)"\u8be5\u9879\u76ee\u6709\u81ea\u5236\u7684\u6210\u672c\u8bbe\u7f6e\u5355\u636e\uff0c\u8bf7\u5220\u9664\u540e\u518d\u64cd\u4f5c\uff01");
            }
        }
        if (0 == state) {
            return this.beforeSubmitCheck(billId);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse budgetPushResponse;
        LambdaQueryWrapper detailProEntityLambdaQueryWrapper = new LambdaQueryWrapper();
        detailProEntityLambdaQueryWrapper.eq(BudgetProjectDetailProEntity::getBudgetId, (Object)billId);
        detailProEntityLambdaQueryWrapper.eq(BudgetProjectDetailProEntity::getCostType, (Object)CostTypeEnum.LABOR_COST_TYPE.getType());
        detailProEntityLambdaQueryWrapper.isNull(BudgetProjectDetailProEntity::getSourceId);
        List list = this.detailProService.list((Wrapper)detailProEntityLambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BudgetProjectProEntity proEntity = (BudgetProjectProEntity)((Object)this.service.getById(billId));
            Date currentDate = DateFormater.getCurrentDate();
            ArrayList<QuotaDetailTemporaryEntity> quotaDetailTemporaryEntities = new ArrayList<QuotaDetailTemporaryEntity>();
            for (Object detailProEntity : list) {
                QuotaDetailTemporaryEntity quotaDetailTemporaryEntity = new QuotaDetailTemporaryEntity();
                quotaDetailTemporaryEntity.setCreateTime(currentDate);
                quotaDetailTemporaryEntity.setPushFlag(0);
                quotaDetailTemporaryEntity.setSourceProjectId(proEntity.getProjectId());
                quotaDetailTemporaryEntity.setSourceProjectName(proEntity.getProjectName());
                quotaDetailTemporaryEntity.setSourceBillId(proEntity.getId());
                quotaDetailTemporaryEntity.setSourceBillDetailId(detailProEntity.getId());
                quotaDetailTemporaryEntity.setSourceBillCode(proEntity.getBillCode());
                quotaDetailTemporaryEntity.setSourceBillName("\u76ee\u6807\u6210\u672c");
                quotaDetailTemporaryEntity.setDetailCode(StringUtils.trim((String)((BudgetProjectDetailProEntity)((Object)detailProEntity)).getCode()));
                quotaDetailTemporaryEntity.setDetailName(StringUtils.trim((String)((BudgetProjectDetailProEntity)((Object)detailProEntity)).getName()));
                quotaDetailTemporaryEntity.setDetailUnit(((BudgetProjectDetailProEntity)((Object)detailProEntity)).getUnit());
                quotaDetailTemporaryEntity.setDescription(((BudgetProjectDetailProEntity)((Object)detailProEntity)).getSpec());
                quotaDetailTemporaryEntity.setLaborPrice(((BudgetProjectDetailProEntity)((Object)detailProEntity)).getPrice());
                quotaDetailTemporaryEntities.add(quotaDetailTemporaryEntity);
            }
            this.quotaDetailTemporaryService.saveOrUpdateBatch(quotaDetailTemporaryEntities);
            Map<Long, QuotaDetailTemporaryEntity> tempMap = quotaDetailTemporaryEntities.stream().collect(Collectors.toMap(QuotaDetailTemporaryEntity::getSourceBillDetailId, person -> person));
            for (BudgetProjectDetailProEntity detailProEntity : list) {
                Long id = detailProEntity.getId();
                QuotaDetailTemporaryEntity temporaryEntity = tempMap.get(id);
                if (temporaryEntity == null) continue;
                detailProEntity.setSourceId(temporaryEntity.getId());
            }
            this.detailProService.saveOrUpdateBatch(list);
        }
        if ((budgetPushResponse = this.paramConfigApi.getByCode(budgetPushCost)).isSuccess()) {
            BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)this.service.selectById(billId));
            ParamRegisterSetVO data = (ParamRegisterSetVO)budgetPushResponse.getData();
            if ("\u662f".equals(data.getValueData())) {
                QueryWrapper settingQueryWrapper = new QueryWrapper();
                settingQueryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
                settingQueryWrapper.eq((Object)"push_flag", (Object)1);
                List settingList = this.settingService.list((Wrapper)settingQueryWrapper);
                if (CollectionUtils.isEmpty((Collection)settingList)) {
                    CommonResponse taxInCostSet;
                    List<BudgetProjectDetailProEntity> detailList = entity.getDetailList();
                    SettingEntity settingEntity = new SettingEntity();
                    settingEntity.setId(billId);
                    settingEntity.setProjectId(entity.getProjectId());
                    settingEntity.setProjectName(entity.getProjectName());
                    settingEntity.setOrgId(entity.getOrgId());
                    settingEntity.setOrgName(entity.getOrgName());
                    settingEntity.setPeriodRule("1");
                    settingEntity.setBillState(3);
                    settingEntity.setPushFlag(1);
                    CommonResponse materialInCostSet = this.paramConfigApi.getByCode(materialInCostCode);
                    if (materialInCostSet.isSuccess()) {
                        ParamRegisterSetVO materialInCostSetData = (ParamRegisterSetVO)materialInCostSet.getData();
                        if (materialInCostSetData.getValueData().equals("1")) {
                            settingEntity.setMaterialCost("0");
                        } else if (materialInCostSetData.getValueData().equals("2")) {
                            settingEntity.setMaterialCost("1");
                        }
                    }
                    if ((taxInCostSet = this.paramConfigApi.getByCode(TaxInCostCode)).isSuccess()) {
                        ParamRegisterSetVO taxInCostData = (ParamRegisterSetVO)taxInCostSet.getData();
                        if (taxInCostData.getValueData().equals("1")) {
                            settingEntity.setTaxFlag("1");
                        } else {
                            settingEntity.setTaxFlag("0");
                        }
                    }
                    ArrayList<SubjectEntity> subjectEntities = new ArrayList<SubjectEntity>();
                    if (CollectionUtils.isNotEmpty(detailList)) {
                        for (BudgetProjectDetailProEntity detailProEntity : detailList) {
                            SubjectEntity subjectEntity = new SubjectEntity();
                            subjectEntity.setId(detailProEntity.getId());
                            subjectEntity.setCostType(detailProEntity.getCostType());
                            subjectEntity.setSubjectCode(detailProEntity.getCode());
                            subjectEntity.setSubjectName(detailProEntity.getSubjectName());
                            subjectEntity.setDetailIndex(detailProEntity.getDetailIndex());
                            subjectEntity.setParentId(detailProEntity.getParentId());
                            subjectEntity.setTid(detailProEntity.getId());
                            subjectEntity.setLeafFlag(detailProEntity.getLeafFlag() == 1);
                            subjectEntity.setStatus(true);
                            subjectEntities.add(subjectEntity);
                        }
                        settingEntity.setSubjectDetails(subjectEntities);
                    }
                    this.settingService.saveOrUpdate((Object)settingEntity, false);
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)this.budgetProjectProService.selectById(billId));
        if (entity.getChangeStatus() != 1) {
            return CommonResponse.error((String)"\u5355\u636e\u5df2\u53d8\u66f4\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.settingService.delById(billId);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(QuotaDetailTemporaryEntity::getSourceBillId, (Object)billId);
        queryWrapper.eq(QuotaDetailTemporaryEntity::getPushFlag, (Object)0);
        this.quotaDetailTemporaryService.remove((Wrapper)queryWrapper);
        return CommonResponse.success();
    }
}

