/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.bean.BudgetSetDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetEntity;
import com.ejianc.business.budget.bean.BudgetSetFeaturesEntity;
import com.ejianc.business.budget.enums.ConvertResultEnum;
import com.ejianc.business.budget.mapper.BudgetProjectMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.service.IBudgetSetDetailService;
import com.ejianc.business.budget.service.IBudgetSetFeaturesService;
import com.ejianc.business.budget.service.IBudgetSetService;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetProjectVO;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectService")
public class BudgetProjectServiceImpl
extends BaseServiceImpl<BudgetProjectMapper, BudgetProjectEntity>
implements IBudgetProjectService {
    private static final String BILL_CODE_ROLE = "BUDGET_PRO_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetProjectDetailService detailsService;
    @Autowired
    private BudgetProjectMapper budgetProjectMapper;
    @Autowired
    private IBudgetProjectProService budgetProjectProService;
    @Autowired
    private IBudgetSetService budgetSetService;
    @Autowired
    private IBudgetSetDetailService budgetSetDetailService;
    @Autowired
    private IBudgetSetFeaturesService budgetSetFeaturesService;

    @Override
    public CommonResponse<BudgetProjectVO> saveOrUpdate(BudgetProjectVO saveorUpdateVO) {
        List entities;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        BudgetProjectEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = (BudgetProjectEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BudgetProjectEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (BudgetProjectEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BudgetProjectEntity.class));
            operateType = "add";
        }
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BudgetProjectEntity::getBillCode, (Object)saveorUpdateVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BudgetProjectEntity::getBillCode, (Object)saveorUpdateVO.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity.setConvertState(0);
        entity.setBaseBudgetMoney(entity.getBudgetMny());
        entity.setBeforeChangeBudgetMny(entity.getBudgetMny());
        entity.setBaseLaborMny(entity.getLaborMny());
        entity.setBeforeChangeLaborMny(entity.getLaborMny());
        entity.setBaseMaterialMny(entity.getMaterialMny());
        entity.setBeforeChangeMaterialMny(entity.getMaterialMny());
        entity.setBaseMechanicalMny(entity.getMechanicalMny());
        entity.setBeforeChangeMechanicalMny(entity.getMechanicalMny());
        entity.setBaseOtherMny(entity.getOtherMny());
        entity.setBeforeChangeOtherMny(entity.getOtherMny());
        entity.setBaseTotalMny(entity.getTotalMny());
        entity.setBeforeChangeTotalMny(entity.getTotalMny());
        List detailsVos = saveorUpdateVO.getCheckList();
        int leaf = 0;
        int subject = 0;
        for (BudgetProjectDetailVO detailsVo : detailsVos) {
            if ("del".equals(detailsVo.getRowState()) || !detailsVo.getLeafFlag().booleanValue()) continue;
            ++leaf;
            if (detailsVo.getSubjectId() == null) continue;
            ++subject;
        }
        if (leaf == subject) {
            entity.setLinkedFlag(1);
            entity.setUnassociate(0);
        } else {
            entity.setLinkedFlag(0);
            entity.setUnassociate(leaf - subject);
        }
        super.saveOrUpdate((Object)entity);
        ArrayList<BudgetProjectDetailEntity> saveOrUpldates = new ArrayList<BudgetProjectDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (Object detailsVo : detailsVos) {
            BudgetProjectDetailEntity detailslist;
            detailsVo.setChangeType(Integer.valueOf(0));
            if ("add".equals(detailsVo.getRowState())) {
                detailslist = (BudgetProjectDetailEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetProjectDetailEntity.class));
                detailslist.setBudgetId(entity.getId());
                saveOrUpldates.add(detailslist);
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                detailslist = (BudgetProjectDetailEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetProjectDetailEntity.class));
                saveOrUpldates.add(detailslist);
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds.add(detailsVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.detailsService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (BudgetProjectDetailEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetProjectDetailEntity cdEntity : saveOrUpldates) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            List resultMapList = BeanMapper.mapList(saveOrUpldates, Map.class);
            List treeData = ResultAsTree.createTreeData((List)resultMapList);
            List<Map<String, Object>> listCodeDate = this.creatCode(treeData, null);
            ArrayList<BudgetProjectDetailEntity> entities2 = new ArrayList<BudgetProjectDetailEntity>();
            this.treeToList(listCodeDate, entities2);
            this.detailsService.saveOrUpdateBatch(entities2, entities2.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.detailsService.removeByIds(deleteIds, false);
        }
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    private List<Map<String, Object>> creatCode(List<Map<String, Object>> list, String innerCode) {
        for (Map<String, Object> ypd : list) {
            String key = (ypd.get("code") == null ? "" : ypd.get("code")) + ":" + ypd.get("name");
            if (StringUtils.isNotEmpty((CharSequence)innerCode)) {
                ypd.put("innerCode", innerCode + "|" + key);
            } else {
                ypd.put("innerCode", key);
            }
            if (ypd.get("children") == null) continue;
            List<Map<String, Object>> child = this.creatCode((List)ypd.get("children"), ypd.get("innerCode").toString());
            ypd.put("children", child);
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<BudgetProjectDetailEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((BudgetProjectDetailEntity)((Object)BeanMapper.map(ypd, BudgetProjectDetailEntity.class)));
        }
    }

    @Override
    public BudgetProjectVO queryDetail(Long id) {
        BudgetProjectEntity entity = (BudgetProjectEntity)((Object)this.budgetProjectMapper.selectById(id));
        if (entity != null) {
            BudgetProjectVO contractVo = (BudgetProjectVO)BeanMapper.map((Object)((Object)entity), BudgetProjectVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_id", new Parameter("eq", (Object)contractVo.getId()));
            queryParam.getParams().put("change_type", new Parameter("ne", (Object)5));
            List purchaseDetailss = this.detailsService.queryList(queryParam, false);
            if (purchaseDetailss != null && purchaseDetailss.size() > 0) {
                for (BudgetProjectDetailEntity cdEntity : purchaseDetailss) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)purchaseDetailss, BudgetProjectDetailVO.class);
                Collections.sort(resultMapList, new BudgetDetailComparatoeVo());
                contractVo.setCheckList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            return contractVo;
        }
        return null;
    }

    @Override
    public CommonResponse<BudgetProjectVO> pushCost(BudgetProjectVO pushVO) {
        List checkList = pushVO.getCheckList();
        int leaf = 0;
        int subject = 0;
        if (CollectionUtils.isNotEmpty((Collection)checkList)) {
            for (BudgetProjectDetailVO detailsVo : checkList) {
                if (!detailsVo.getLeafFlag().booleanValue()) continue;
                ++leaf;
                if (detailsVo.getSubjectId() == null) continue;
                ++subject;
            }
            LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
            if (leaf == subject) {
                lambda.set(BudgetProjectEntity::getLinkedFlag, (Object)1);
                lambda.set(BudgetProjectEntity::getUnassociate, (Object)0);
            } else {
                lambda.set(BudgetProjectEntity::getLinkedFlag, (Object)0);
                lambda.set(BudgetProjectEntity::getUnassociate, (Object)(leaf - subject));
            }
            lambda.eq(BaseEntity::getId, (Object)pushVO.getId());
            super.update((Wrapper)lambda);
            List detailEntities = BeanMapper.mapList((Iterable)checkList, BudgetProjectDetailEntity.class);
            this.detailsService.saveOrUpdateBatch(detailEntities);
        }
        return CommonResponse.success((Object)this.queryDetail(pushVO.getId()));
    }

    @Override
    public List<BudgetSetDetailVO> querySimilar(Long budgetDetailId) {
        List highMatchSetDetailIds;
        String detailCode;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(BudgetSetEntity::getEnableState, (Object)1);
        BudgetSetEntity setEntity = (BudgetSetEntity)((Object)this.budgetSetService.getOne((Wrapper)queryWrapper, false));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BudgetSetDetailEntity::getSetId, (Object)setEntity.getId());
        List list = this.budgetSetDetailService.list((Wrapper)wrapper);
        HashMap detailMap = new HashMap();
        for (BudgetSetDetailEntity detailEntity : list) {
            detailCode = this.removeLastThreeCharacters(detailEntity.getDetailCode());
            List<BudgetSetDetailEntity> result = detailMap.containsKey(detailCode) ? (List)detailMap.get(detailCode) : new ArrayList();
            result.add(detailEntity);
            detailMap.put(detailCode, result);
        }
        BudgetProjectDetailEntity detailEntity = (BudgetProjectDetailEntity)((Object)this.detailsService.selectById(budgetDetailId));
        BudgetProjectDetailVO detailVO = (BudgetProjectDetailVO)BeanMapper.map((Object)((Object)detailEntity), BudgetProjectDetailVO.class);
        detailCode = this.removeLastThreeCharacters(detailEntity.getCode());
        List setDetailVOS = CollectionUtils.isNotEmpty((Collection)((Collection)detailMap.get(detailCode))) ? BeanMapper.mapList((Iterable)((Iterable)detailMap.get(detailCode)), BudgetSetDetailVO.class) : null;
        String detailFeature = this.nullToTrim(detailVO.getProjectFeature()).replaceAll("\\n|\\r|\\r\\n", "");
        List result = (List)detailMap.get(detailCode);
        HashMap<Long, BudgetSetDetailEntity> map = new HashMap<Long, BudgetSetDetailEntity>();
        for (BudgetSetDetailEntity setDetailEntity : result) {
            String features = setDetailEntity.getDescription().replaceAll("\\n|\\r|\\r\\n", "");
            if (features.equals(detailFeature)) {
                return Arrays.asList((BudgetSetDetailVO)BeanMapper.map((Object)((Object)setDetailEntity), BudgetSetDetailVO.class));
            }
            map.put(setDetailEntity.getId(), setDetailEntity);
        }
        HashMap<Integer, List> matchResMap = new HashMap<Integer, List>();
        LambdaQueryWrapper featureQry = new LambdaQueryWrapper();
        featureQry.in(BudgetSetFeaturesEntity::getSetDetailId, new ArrayList(map.keySet()));
        List featuresEntities = this.budgetSetFeaturesService.list((Wrapper)featureQry);
        Map<Long, List<BudgetSetFeaturesEntity>> featMap = featuresEntities.stream().collect(Collectors.groupingBy(BudgetSetFeaturesEntity::getSetDetailId));
        for (Long key : featMap.keySet()) {
            boolean featMatchFlag = true;
            List<BudgetSetFeaturesEntity> featList = featMap.get(key);
            if (null != detailVO.getHighestMatchLevel() && featList.size() < detailVO.getHighestMatchLevel()) break;
            for (BudgetSetFeaturesEntity featuresEntity : featList) {
                if (this.judgeMatch(detailFeature, featuresEntity)) continue;
                featMatchFlag = false;
                break;
            }
            if (!featMatchFlag) continue;
            int curMatchSize = featList.size();
            if (null == detailVO.getHighestMatchLevel() || curMatchSize > detailVO.getHighestMatchLevel()) {
                detailVO.setHighestMatchLevel(Integer.valueOf(curMatchSize));
            }
            List matchSetDetailIds = Optional.ofNullable(matchResMap.get(curMatchSize)).orElse(new ArrayList());
            matchSetDetailIds.add(key);
            matchResMap.put(curMatchSize, matchSetDetailIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)(highMatchSetDetailIds = (List)matchResMap.get(detailVO.getHighestMatchLevel())))) {
            return setDetailVOS.stream().filter(t -> highMatchSetDetailIds.contains(t.getId())).collect(Collectors.toList());
        }
        return setDetailVOS;
    }

    @Override
    public CommonResponse<String> convertToPro(BudgetProjectVO budgetProjectVO) {
        List projectDetailVOS = budgetProjectVO.getCheckList().stream().filter(x -> x.getLeafFlag()).collect(Collectors.toList());
        budgetProjectVO.setCheckList(projectDetailVOS);
        HashMap detailMap = new HashMap();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(BudgetSetEntity::getEnableState, (Object)1);
        BudgetSetEntity setEntity = (BudgetSetEntity)((Object)this.budgetSetService.getOne((Wrapper)queryWrapper, false));
        if (null != setEntity) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(BudgetSetDetailEntity::getSetId, (Object)setEntity.getId());
            List list = this.budgetSetDetailService.list((Wrapper)wrapper);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BudgetSetDetailEntity detailEntity = (BudgetSetDetailEntity)((Object)iterator.next());
                String detailCode = this.removeLastThreeCharacters(detailEntity.getDetailCode());
                List<BudgetSetDetailEntity> result = detailMap.containsKey(detailCode) ? (List)detailMap.get(detailCode) : new ArrayList();
                result.add(detailEntity);
                detailMap.put(detailCode, result);
            }
        }
        List detailVOS = budgetProjectVO.getCheckList();
        block1: for (BudgetProjectDetailVO detailVO : detailVOS) {
            detailVO.setResultState(ConvertResultEnum.\u65e0\u76f8\u4f3c\u6e05\u5355.getCode());
            detailVO.setBaseResultState(ConvertResultEnum.\u65e0\u76f8\u4f3c\u6e05\u5355.getCode());
            String detailFeature = this.nullToTrim(detailVO.getProjectFeature()).replaceAll("\\n|\\r|\\r\\n", "");
            boolean matchFlag = false;
            String detailCode = this.removeLastThreeCharacters(detailVO.getCode());
            if (!detailMap.containsKey(detailCode)) continue;
            detailVO.setResultState(ConvertResultEnum.\u5b58\u5728\u76f8\u4f3c\u6e05\u5355.getCode());
            detailVO.setBaseResultState(ConvertResultEnum.\u5b58\u5728\u76f8\u4f3c\u6e05\u5355.getCode());
            List result = (List)detailMap.get(detailCode);
            HashMap<Long, BudgetSetDetailEntity> map = new HashMap<Long, BudgetSetDetailEntity>();
            for (BudgetSetDetailEntity detailEntity : result) {
                String features = detailEntity.getDescription().replaceAll("\\n|\\r|\\r\\n", "");
                if (features.equals(detailFeature)) {
                    detailVO.setResultState(ConvertResultEnum.\u5df2\u5339\u914d.getCode());
                    detailVO.setBaseResultState(ConvertResultEnum.\u5df2\u5339\u914d.getCode());
                    detailVO.setSetDetailId(detailEntity.getId());
                    detailVO.setMatchTime(new Date());
                    matchFlag = true;
                    break;
                }
                map.put(detailEntity.getId(), detailEntity);
            }
            if (matchFlag) continue;
            LambdaQueryWrapper featureQry = new LambdaQueryWrapper();
            featureQry.in(BudgetSetFeaturesEntity::getSetDetailId, new ArrayList(map.keySet()));
            List featuresEntities = this.budgetSetFeaturesService.list((Wrapper)featureQry);
            Map<Long, List<BudgetSetFeaturesEntity>> featMap = featuresEntities.stream().collect(Collectors.groupingBy(BudgetSetFeaturesEntity::getSetDetailId));
            for (Long key : featMap.keySet()) {
                boolean featMatchFlag = true;
                List<BudgetSetFeaturesEntity> featList = featMap.get(key);
                if (null != detailVO.getHighestMatchLevel() && featList.size() < detailVO.getHighestMatchLevel()) continue block1;
                for (BudgetSetFeaturesEntity featuresEntity : featList) {
                    if (this.judgeMatch(detailFeature, featuresEntity)) continue;
                    featMatchFlag = false;
                    break;
                }
                if (!featMatchFlag) continue;
                if (null == detailVO.getHighestMatchLevel() || featList.size() > detailVO.getHighestMatchLevel()) {
                    detailVO.setResultState(ConvertResultEnum.\u5df2\u5339\u914d.getCode());
                    detailVO.setBaseResultState(ConvertResultEnum.\u5df2\u5339\u914d.getCode());
                    detailVO.setSetDetailId(((BudgetSetDetailEntity)((Object)map.get(key))).getId());
                    detailVO.setMatchTime(new Date());
                    detailVO.setHighestMatchLevel(Integer.valueOf(featList.size()));
                    continue;
                }
                if (featList.size() != detailVO.getHighestMatchLevel().intValue()) continue;
                detailVO.setResultState(ConvertResultEnum.\u5b58\u5728\u76f8\u4f3c\u6e05\u5355.getCode());
                detailVO.setBaseResultState(ConvertResultEnum.\u5b58\u5728\u76f8\u4f3c\u6e05\u5355.getCode());
                detailVO.setSetDetailId(null);
                detailVO.setMatchTime(null);
            }
        }
        List detailEntities = BeanMapper.mapList((Iterable)detailVOS, BudgetProjectDetailEntity.class);
        this.detailsService.saveOrUpdateBatch(detailEntities);
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(BaseEntity::getId, (Object)budgetProjectVO.getId());
        updateWrapper.set(BudgetProjectEntity::getConvertState, (Object)1);
        this.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u8f6c\u6362\u6210\u529f!");
    }

    private String removeLastThreeCharacters(String str) {
        if (str == null || str.length() <= 3) {
            return "";
        }
        return str.substring(0, str.length() - 3);
    }

    private String nullToTrim(String source) {
        if (null == source) {
            return "";
        }
        return source;
    }

    private boolean judgeMatch(String features, BudgetSetFeaturesEntity featuresEntity) {
        if (StringUtils.isNotEmpty((CharSequence)featuresEntity.getFeaturesName()) && features.contains(featuresEntity.getFeaturesName())) {
            return true;
        }
        String featuresDescription = featuresEntity.getFeaturesDescription();
        if (StringUtils.isNotEmpty((CharSequence)featuresDescription)) {
            if (featuresDescription.contains(",")) {
                String[] arr;
                for (String str : arr = featuresDescription.split(",")) {
                    if (!features.contains(str)) continue;
                    return true;
                }
            } else {
                return features.contains(featuresDescription);
            }
        }
        return false;
    }

    @Override
    public CommonResponse<String> pushToPro(Long budgetId) {
        BudgetProjectEntity entity = (BudgetProjectEntity)((Object)this.selectById(budgetId));
        if (2 != entity.getBudgetType() && 4 != entity.getBudgetType()) {
            throw new BusinessException("\u53ea\u6709\u7c7b\u578b\u4e3a[\u65bd\u5de5\u56fe\u9884\u7b97]\u548c[\u7b7e\u8bc1]\u7684\u9884\u7b97\u4e66\u5141\u8bb8\u8f6c\u6362\u6210\u76ee\u6807\u6210\u672c!");
        }
        if (null != entity.getTargetId()) {
            throw new BusinessException("\u8be5\u9884\u7b97\u5df2\u751f\u6210\u8fc7\u76ee\u6807\u6210\u672c\uff0c\u4e0d\u53ef\u91cd\u590d\u751f\u6210!<br/>(\u5982\u9700\u91cd\u65b0\u751f\u6210\uff0c\u5148\u5220\u9664\u8be5\u9879\u76ee\u7684\u76ee\u6807\u6210\u672c!)");
        }
        BudgetProjectVO budgetProjectVO = (BudgetProjectVO)BeanMapper.map((Object)((Object)entity), BudgetProjectVO.class);
        Long result = this.budgetProjectProService.pushToPro(budgetProjectVO);
        if (null != result) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)budgetId);
            updateWrapper.set(BudgetProjectEntity::getTargetId, (Object)result);
            this.update((Wrapper)updateWrapper);
            return CommonResponse.success((String)"\u751f\u6210\u76ee\u6807\u6210\u672c\u6210\u529f, \u53ef\u70b9\u51fb\u3010\u67e5\u770b\u76ee\u6807\u6210\u672c\u3011\uff01");
        }
        return CommonResponse.error((String)"\u751f\u6210\u76ee\u6807\u6210\u672c\u5931\u8d25!");
    }

    @Override
    public CommonResponse<Boolean> checkBeforePush(Long budgetId) {
        BudgetProjectEntity entity = (BudgetProjectEntity)((Object)this.selectById(budgetId));
        if (2 != entity.getBudgetType() && 4 != entity.getBudgetType()) {
            throw new BusinessException("\u53ea\u6709\u7c7b\u578b\u4e3a[\u65bd\u5de5\u56fe\u9884\u7b97]\u548c[\u7b7e\u8bc1]\u7684\u9884\u7b97\u4e66\u5141\u8bb8\u8f6c\u6362\u6210\u76ee\u6807\u6210\u672c!<br/> (\u5220\u9664\u8be5\u9879\u76ee\u81ea\u5236\u7684\u76ee\u6807\u6210\u672c\u540e\uff0c\u5373\u53ef\u901a\u8fc7\u9884\u7b97\u751f\u6210)");
        }
        LambdaQueryWrapper qry = new LambdaQueryWrapper();
        qry.eq(BudgetProjectProEntity::getProjectId, (Object)entity.getProjectId());
        BudgetProjectProEntity proEntity = (BudgetProjectProEntity)((Object)this.budgetProjectProService.getOne((Wrapper)qry, false));
        if (null != proEntity) {
            if (null == proEntity.getSourceId()) {
                throw new BusinessException("\u5df2\u5b58\u5728\u81ea\u5236\u76ee\u6807\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u9884\u7b97\u8f6c\u6362\u751f\u6210!<br/>(\u5220\u9664\u8be5\u9879\u76ee\u81ea\u5236\u7684\u76ee\u6807\u6210\u672c\u540e\uff0c\u5373\u53ef\u901a\u8fc7\u9884\u7b97\u751f\u6210)");
            }
            if (!BillStateEnum.COMMITED_STATE.getBillStateCode().equals(proEntity.getBillState()) && !BillStateEnum.PASSED_STATE.getBillStateCode().equals(proEntity.getBillState())) {
                throw new BusinessException("\u8be5\u9879\u76ee\u76ee\u6807\u6210\u672c\u672a\u751f\u6548\uff0c\u8bf7\u5904\u7406\u540e\u751f\u6210!<br/>(\u5220\u9664\u6216\u7b49\u5f85\u8be5\u9879\u76ee\u7684\u76ee\u6807\u6210\u672c\u5ba1\u6279\u901a\u8fc7\u540e\u518d\u751f\u6210)");
            }
            if (2 == proEntity.getChangeStatus()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u53d8\u66f4\u4e2d\uff0c\u8bf7\u5904\u7406\u540e\u751f\u6210!<br/> (\u5220\u9664\u8be5\u9879\u76ee\u7684\u53d8\u66f4\u5355\u6216\u7b49\u5f85\u53d8\u66f4\u5355\u5ba1\u6279\u901a\u8fc7\u540e\u518d\u751f\u6210)");
            }
            if (null != entity.getTargetId()) {
                throw new BusinessException("\u8be5\u9884\u7b97\u5df2\u751f\u6210\u8fc7\u76ee\u6807\u6210\u672c\uff0c\u4e0d\u53ef\u91cd\u590d\u751f\u6210!<br/>(\u5982\u9700\u91cd\u65b0\u751f\u6210\uff0c\u5148\u5220\u9664\u8be5\u9879\u76ee\u7684\u76ee\u6807\u6210\u672c!)");
            }
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff0c\u8be5\u9879\u76ee\u5b58\u5728\u5df2\u751f\u6548\u7684\u76ee\u6807\u6210\u672c!", (Object)true);
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff0c\u8be5\u9879\u76ee\u6ca1\u8f6c\u6362\u8fc7\u76ee\u6807\u6210\u672c!", (Object)false);
    }
}

