package com.ejianc.business.budget.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 定额库明细表
 *
 * @author generator
 *
 */
@TableName("ejc_budget_quota_detail")
public class QuotaDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="quota_id")
    private Long quotaId; // 主表ID
    @TableField(value="quota_type_id")
    private Long quotaTypeId; // 类型子表ID
    @TableField(value="detail_code")
    private String detailCode; // 定额编码
    @TableField(value="detail_name")
    private String detailName; // 定额名称
    @TableField(value="description")
    private String description; // 特征描述
    @TableField(value="detail_unit")
    private String detailUnit; // 单位
    @TableField(value="labor_price")
    private BigDecimal laborPrice; // 劳务单价
    @TableField(value="mat_name")
    private String matName; // 主材品类
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(exist=false)
    @SubEntity(serviceName="quotaMatService", pidName = "quotaDetailId")
    private List<QuotaMatEntity> matList = new ArrayList<>();

    public Long getQuotaId() {
        return quotaId;
    }

    public void setQuotaId(Long quotaId) {
        this.quotaId = quotaId;
    }
    public Long getQuotaTypeId() {
        return quotaTypeId;
    }

    public void setQuotaTypeId(Long quotaTypeId) {
        this.quotaTypeId = quotaTypeId;
    }
    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }
    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }
    public BigDecimal getLaborPrice() {
        return laborPrice;
    }

    public void setLaborPrice(BigDecimal laborPrice) {
        this.laborPrice = laborPrice;
    }
    public String getMatName() {
        return matName;
    }

    public void setMatName(String matName) {
        this.matName = matName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<QuotaMatEntity> getMatList() {
        return matList;
    }

    public void setMatList(List<QuotaMatEntity> matList) {
        this.matList = matList;
    }
}
