package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.enums.ConvertResultEnum;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.BudgetMatchVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.business.budget.vo.comparator.BudgetMatchComparatoeVo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 项目预算清单
 *
 * @author generator
 */
@Controller
@RequestMapping("budgetProjectDetail")
public class BudgetProjectDetailController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBudgetProjectDetailService service;

    @Autowired
    private IBudgetProjectService budgetProjectService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetProjectDetailVO> saveOrUpdate(@RequestBody BudgetProjectDetailVO saveorUpdateVO) {
        BudgetProjectDetailEntity entity = BeanMapper.map(saveorUpdateVO, BudgetProjectDetailEntity.class);
        service.saveOrUpdate(entity, false);
        BudgetProjectDetailVO vo = BeanMapper.map(entity, BudgetProjectDetailVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectDetailVO> queryDetail(Long id) {
        BudgetProjectDetailEntity entity = service.selectById(id);
        BudgetProjectDetailVO vo = BeanMapper.map(entity, BudgetProjectDetailVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectDetailVO> vos) {
        service.removeByIds(vos.stream().map(BudgetProjectDetailVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<BudgetProjectDetailEntity> page = service.queryPage(param, false);
        IPage<BudgetProjectDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectDetailVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "budget-detail-import.xlsx", "项目预算导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request, response);
    }

    /**
     * 河南五建
     * 导入 Ydbx
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportYdbx", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImportYdbx(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImportYdbx(request, response);
    }

    // 参照
    @RequestMapping(value = "/detailRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BudgetProjectDetailVO>> detailRef(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询清单参照成功！", service.detailRef(projectId));
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadHk")
    @ResponseBody
    public void downloadHk(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "hk-budget-detail-import.xlsx", "项目预算导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportHk", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImportHk(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImportHk(request, response);
    }

    /**
     * @param param
     * @Description queryMatchList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMatchList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetMatchVO>> queryMatchList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("detailCode");
        fuzzyFields.add("detailName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Parameter budgetIdParm = param.getParams().get("budgetId");
        Parameter setDetailIdParm = param.getParams().get("setDetailId");
        if (null == budgetIdParm && null == setDetailIdParm) {
            throw new BusinessException("预算书Id和设置子表Id不能同时为空!");
        }
        Long budgetId = null != budgetIdParm ? Long.valueOf((String) budgetIdParm.getValue()) : null;
        Long setDetailId = null != setDetailIdParm ? Long.valueOf((String) setDetailIdParm.getValue()) : null;
        Page<BudgetMatchVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<BudgetMatchVO> list = service.queryMatchList(page, wrapper, budgetId, setDetailId);
        //实现排序
        Collections.sort(list, new BudgetMatchComparatoeVo());
        page.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    @RequestMapping(value = "/querySimilar", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BudgetSetDetailVO>> querySimilar(Long budgetDetailId) {
        return CommonResponse.success("查询相似清单列表成功！", budgetProjectService.querySimilar(budgetDetailId));
    }

    @RequestMapping(value = "/saveSimilarResult", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveSimilarResult(@RequestBody BudgetProjectDetailVO detailVO) {
        Long setDetailId = detailVO.getSetDetailId();
        List<Long> detailIdList = detailVO.getDetailList();
        if(setDetailId != null){
            LambdaUpdateWrapper<BudgetProjectDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(BudgetProjectDetailEntity::getId, detailIdList);
            updateWrapper.set(BudgetProjectDetailEntity::getSetDetailId, detailVO.getSetDetailId());
            updateWrapper.set(BudgetProjectDetailEntity::getResultState, ConvertResultEnum.已替换.getCode());
            updateWrapper.set(BudgetProjectDetailEntity::getMatchTime, new Date());
            service.update(updateWrapper);
            return CommonResponse.success("保存相似清单匹配成功!");
        } else {
            // 取消匹配
            List<BudgetProjectDetailEntity> budgetProjectDetailEntities = (List<BudgetProjectDetailEntity>) service.listByIds(detailIdList);
            if (CollectionUtils.isNotEmpty(budgetProjectDetailEntities)) {
                for (BudgetProjectDetailEntity budgetProjectDetailEntity : budgetProjectDetailEntities) {
                    budgetProjectDetailEntity.setSetDetailId(null);
                    budgetProjectDetailEntity.setResultState(budgetProjectDetailEntity.getBaseResultState());
                    budgetProjectDetailEntity.setMatchTime(null);
                }
                service.saveOrUpdateBatch(budgetProjectDetailEntities);
            }
            return CommonResponse.success("操作成功!");
        }
    }

    @RequestMapping(value = "/updateIgnoreState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateIgnoreState(Long budgetDetailId, Boolean ignoreFlag) {
        BudgetProjectDetailEntity projectDetailEntity = service.selectById(budgetDetailId);
        LambdaUpdateWrapper<BudgetProjectDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BudgetProjectDetailEntity::getId, budgetDetailId);
        updateWrapper.set(BudgetProjectDetailEntity::getResultState, ignoreFlag ? ConvertResultEnum.已忽略.getCode() : projectDetailEntity.getBaseResultState());
        service.update(updateWrapper);
        return CommonResponse.success("保存相似清单匹配成功!");
    }

    @RequestMapping(value = "/queryNumInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryNumInfo(Long budgetId) {
        LambdaQueryWrapper<BudgetProjectDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetProjectDetailEntity::getBudgetId, budgetId);
        queryWrapper.eq(BudgetProjectDetailEntity::getLeafFlag, 1);
        List<BudgetProjectDetailEntity> detailEntities = service.list(queryWrapper);
        int totalNum = 0;
        int matchNum = 0;
        int similarNum = 0;
        int noMatchNum = 0;
        for(BudgetProjectDetailEntity detailEntity : detailEntities){
            if(null != detailEntity.getResultState()){
                totalNum++;
                if (ConvertResultEnum.已匹配.getCode().equals(detailEntity.getResultState()) || ConvertResultEnum.已替换.getCode().equals(detailEntity.getResultState())) {
                    matchNum++;
                } else if (ConvertResultEnum.存在相似清单.getCode().equals(detailEntity.getResultState())) {
                    similarNum++;
                } else if (!ConvertResultEnum.已忽略.getCode().equals(detailEntity.getResultState())) {
                    noMatchNum++;
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("totalNum", totalNum);
        jsonObject.put("matchNum", matchNum);
        jsonObject.put("similarNum", similarNum);
        jsonObject.put("noMatchNum", noMatchNum);
        return CommonResponse.success("查询条数信息成功!", jsonObject);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<BudgetMatchVO>> commonResponse = queryMatchList(param);
        Map<String, Object> beans = new HashMap<>();
        List<BudgetMatchVO> records = commonResponse.getData().getRecords();
        records.forEach(vo -> {
            vo.setResultStateName(ConvertResultEnum.getEnumByCode(vo.getResultState()).getDescription());
        });
        beans.put("records", records);
        ExcelExport.getInstance().export("Match-export.xlsx", beans, response);
    }

    /**
     * @Description queryThreeCompare 查询三算对比报表
     * @param projectId
     */
    @RequestMapping(value = "/queryThreeCompare", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryThreeCompare(Long projectId) {
        return CommonResponse.success("查询数据成功！", service.queryThreeCompare(projectId));
    }

    /**
     * @Description queryProfitAnalyse 清单利润分析
     * @param projectId
     */
    @RequestMapping(value = "/queryProfitAnalyse", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryProfitAnalyse(Long projectId) {
        return CommonResponse.success("查询数据成功！", service.queryProfitAnalyse(projectId));
    }
}
