package com.ejianc.business.budget.service.impl;

import com.ejianc.business.budget.bean.*;
import com.ejianc.business.budget.service.*;
import com.ejianc.business.budget.vo.cons.BillCons;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("budgetProjectChange")
public class BudgetProjectChangeBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private IBudgetProjectChangeService changeService;
    @Autowired
    private IBudgetProjectService budgetProjectService;
    @Autowired
    private IBudgetProjectHistoryService historyService;
    @Autowired
    private IBudgetProjectDetailService budgetProjectDetailService;
    @Autowired
    private IBudgetProjectDetailHistoryService historyDetailService;
    @Autowired
    private IBudgetProjectDetailChangeService changeDetailService;
    @Autowired
    private IAttachmentApi attachmentApi;


    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //变更表
        BudgetProjectChangeEntity changeEntity = changeService.selectById(billId);

        BudgetProjectEntity budgetEntity = budgetProjectService.selectById(changeEntity.getBudgetId());

        //项目预算主表
        BudgetProjectHistoryEntity historyEntity = BeanMapper.map(budgetEntity, BudgetProjectHistoryEntity.class);
        historyEntity.setBudgetId(changeEntity.getBudgetId());//原项目预算主键
        historyEntity.setId(null);
        historyEntity.setCreateUserCode(null);
        historyEntity.setCreateTime(changeEntity.getCreateTime());
        historyEntity.setVersion(null);
        historyEntity.setUpdateTime(null);
        historyEntity.setUpdateUserCode(null);
        historyEntity.setChangeCode(changeEntity.getBillCode());
        historyEntity.setChangeReason(changeEntity.getChangeReason());
        List<BudgetProjectDetailHistoryEntity> historyDetailList = historyEntity.getCheckList();
        if (CollectionUtils.isNotEmpty(historyDetailList)) {
            for (BudgetProjectDetailHistoryEntity historyProEntity : historyDetailList) {
                historyProEntity.setBudgetId(budgetEntity.getId());//原预算主键
                historyProEntity.setBudgetDetailId(historyProEntity.getId());
                historyProEntity.setId(null);
            }
        }
        //同步原合同到记录表
        historyService.saveOrUpdate(historyEntity, false);
        //这一步是维护子表的夫级和子级的关系 因为历史的子表是新生成 id改变

        List<BudgetProjectDetailHistoryEntity> historyProDetailList = historyEntity.getCheckList();
        if (CollectionUtils.isNotEmpty(historyProDetailList)) {
            Map<Long, BudgetProjectDetailHistoryEntity> historyDetailMap = historyProDetailList.stream().collect(Collectors.toMap(k -> k.getBudgetDetailId(), (k) -> k));
            for (BudgetProjectDetailHistoryEntity historyProEntity : historyProDetailList) {
                if (historyProEntity.getParentId() != null && historyDetailMap.get(historyProEntity.getParentId()) != null) {
                    historyProEntity.setParentId(historyDetailMap.get(historyProEntity.getParentId()).getId());
                }
            }
            historyDetailService.saveOrUpdateBatch(historyProDetailList, historyProDetailList.size());
        }


        //回写合同主表
        budgetEntity.setBeforeChangeBudgetMny(budgetEntity.getBudgetMny());//变更后金额变为变更前金额
        budgetEntity.setBudgetMny(budgetEntity.getChangingBudgetMny());//变更中金额变为变更后金额
        budgetEntity.setChangingBudgetMny(null);//变更中金额清空
        budgetEntity.setBeforeChangeLaborMny(budgetEntity.getLaborMny());//变更后金额变为变更前金额
        budgetEntity.setLaborMny(budgetEntity.getChangingLaborMny());//变更中金额变为变更后金额
        budgetEntity.setChangingLaborMny(null);//变更中金额清空
        budgetEntity.setBeforeChangeMaterialMny(budgetEntity.getMaterialMny());//变更后金额变为变更前金额
        budgetEntity.setMaterialMny(budgetEntity.getChangingMaterialMny());//变更中金额变为变更后金额
        budgetEntity.setChangingMaterialMny(null);//变更中金额清空
        budgetEntity.setBeforeChangeMechanicalMny(budgetEntity.getMechanicalMny());//变更后金额变为变更前金额
        budgetEntity.setMechanicalMny(budgetEntity.getChangingMechanicalMny());//变更中金额变为变更后金额
        budgetEntity.setChangingMechanicalMny(null);//变更中金额清空
        budgetEntity.setBeforeChangeOtherMny(budgetEntity.getOtherMny());//变更后金额变为变更前金额
        budgetEntity.setOtherMny(budgetEntity.getChangingOtherMny());//变更中金额变为变更后金额
        budgetEntity.setChangingOtherMny(null);//变更中金额清空
        budgetEntity.setBeforeChangeTotalMny(budgetEntity.getTotalMny());//变更后金额变为变更前金额
        budgetEntity.setTotalMny(budgetEntity.getChangingTotalMny());//变更中金额变为变更后金额
        budgetEntity.setChangingTotalMny(null);//变更中金额清空

        budgetEntity.setChangeStatus(3);//状态改为已变更
        budgetEntity.setChangeCode(budgetEntity.getChangeCode());
        budgetEntity.setChangeId(budgetEntity.getChangeId());
        budgetEntity.setBillState(budgetEntity.getBillState());

        budgetEntity.setProjectId(changeEntity.getProjectId());
        budgetEntity.setProjectName(changeEntity.getProjectName());

        budgetEntity.setBillCode(changeEntity.getBillCode());
        budgetEntity.setChangeReason(changeEntity.getChangeReason());
        budgetEntity.setChangeVersion(changeEntity.getChangeVersion());

        //更新子表
        List<BudgetProjectDetailChangeEntity> changeDetailList = changeEntity.getCheckList();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            List<BudgetProjectDetailEntity> addOrUpdateList = new ArrayList<>();
            List<Long> delList = new ArrayList<>();
            //需要判断是走更新还是新增
            List<BudgetProjectDetailEntity> detailList = budgetEntity.getCheckList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                Map<Long, BudgetProjectDetailEntity> detailMap = detailList.stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));
                Map<Long, BudgetProjectDetailChangeEntity> changeDetailMap = changeDetailList.stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));
                for (BudgetProjectDetailChangeEntity detailChangeProEntity : changeDetailList) {
                    if (detailMap.containsKey(detailChangeProEntity.getBudgetDetailId())) {
                        //修改
                        BudgetProjectDetailEntity detailProEntity = detailMap.get(detailChangeProEntity.getBudgetDetailId());
                        if (detailProEntity != null) {
                            BudgetProjectDetailEntity entity = BeanMapper.map(detailChangeProEntity, BudgetProjectDetailEntity.class);
                            entity.setChangeId(changeEntity.getId());
                            entity.setChangeBid(detailChangeProEntity.getId());
                            entity.setId(detailProEntity.getId());
                            entity.setParentId(detailProEntity.getParentId());
                            entity.setVersion(detailProEntity.getVersion());
                            entity.setChangeType(null == entity.getChangeType() ? 0 : entity.getChangeType());
                            entity.setSetDetailId(detailProEntity.getSetDetailId());
                            entity.setResultState(detailProEntity.getResultState());
                            entity.setMatchTime(detailProEntity.getMatchTime());
                            addOrUpdateList.add(entity);
                            detailMap.remove(detailChangeProEntity.getBudgetDetailId());
                        }
                    } else {
                        //新增
                        BudgetProjectDetailEntity entity = BeanMapper.map(detailChangeProEntity, BudgetProjectDetailEntity.class);
                        if (entity.getParentId() != null && changeDetailMap.get(entity.getParentId()) != null && changeDetailMap.get(entity.getParentId()).getBudgetDetailId() != null) {
                            entity.setParentId(changeDetailMap.get(entity.getParentId()).getBudgetDetailId());
                        }
                        entity.setChangeId(changeEntity.getId());
                        entity.setChangeBid(detailChangeProEntity.getId());
                        entity.setVersion(0);
                        entity.setBudgetId(budgetEntity.getId());
                        entity.setChangeType(null == entity.getChangeType() ? 0 : entity.getChangeType());
                        addOrUpdateList.add(entity);
                    }
                }
                if (!detailMap.isEmpty()) {
                    delList.addAll(detailMap.keySet());
                }
                //删除
                if (CollectionUtils.isNotEmpty(delList)) {
                    budgetProjectDetailService.removeByIds(delList, true);
                }
                //修改or新增
                if (CollectionUtils.isNotEmpty(addOrUpdateList)) {
                    budgetProjectDetailService.saveOrUpdateBatch(addOrUpdateList, addOrUpdateList.size());
                }
            } else {
                //原清单为空全部新增 变更子表同步->原清单
                List<BudgetProjectDetailEntity> detailProEntityList = BeanMapper.mapList(changeDetailList, BudgetProjectDetailEntity.class);
                for (BudgetProjectDetailEntity BudgetProjectDetailEntity : detailProEntityList) {
                    BudgetProjectDetailEntity.setChangeId(changeEntity.getId());
                    BudgetProjectDetailEntity.setChangeBid(changeEntity.getId());
                    BudgetProjectDetailEntity.setBudgetId(budgetEntity.getId());
                    BudgetProjectDetailEntity.setId(null);
                    BudgetProjectDetailEntity.setVersion(0);
                    BudgetProjectDetailEntity.setChangeType(null == BudgetProjectDetailEntity.getChangeType() ? 0 : BudgetProjectDetailEntity.getChangeType());
                }
                budgetProjectDetailService.saveOrUpdateBatch(detailProEntityList);
            }

        } else {
            //变更的子表为空删除主表的子表
            List<BudgetProjectDetailEntity> detailList = budgetEntity.getCheckList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                budgetProjectDetailService.removeByIds(detailList.stream().map(BudgetProjectDetailEntity::getId).collect(Collectors.toList()), false);
            }
        }

        // 同步科目
       /* Map<Long, BudgetProjectDetailEntity> checkMap = new HashMap<>();
        for (BudgetProjectDetailEntity bd : budgetEntity.getCheckList()) {
            checkMap.put(bd.getId(), bd);
        }
        //回写原合同清单表
        budgetProjectDetailService.deleteByBudgetId(changeEntity.getBudgetId());
        QueryParam parm = new QueryParam();
        parm.getParams().put("budgetChangeId", new Parameter(QueryParam.EQ, changeEntity.getId()));
        changeDetailList = changeDetailService.queryList(parm, false);
        int leaf = 0;//全部末级数量
        int subject = 0;// 已关联数量
        if (null != changeDetailList && changeDetailList.size() > 0) {
            List<BudgetProjectDetailEntity> detailList = new ArrayList<>();
            for (BudgetProjectDetailChangeEntity cde : changeDetailList) {
                Long detailId = cde.getBudgetDetailId();
                // 同步科目
                if (cde.getLeafFlag()) {
                    if (checkMap.get(detailId) != null) {
                        cde.setSubjectId(checkMap.get(detailId).getSubjectId());
                        cde.setSubjectName(checkMap.get(detailId).getSubjectName());
                        if ((null == cde.getChangeType() || cde.getChangeType() != 5) && checkMap.get(detailId).getSubjectId() != null) {
                            subject++;
                        }
                    } else {
                        cde.setSubjectId(null);
                        cde.setSubjectName(null);
                    }
                    if (null == cde.getChangeType() || cde.getChangeType() != 5) {
                        leaf++;
                    }
                }
                BudgetProjectDetailEntity cdetail = BeanMapper.map(cde, BudgetProjectDetailEntity.class);
                cdetail.setId(null);
                cdetail.setChangeBid(cde.getId());
                //变更类型如果是中止，不能改类型
                if (null == cdetail.getChangeType() || cdetail.getChangeType() != 5) {
                    cdetail.setChangeType(0);
                }

                detailList.add(cdetail);
            }
            budgetProjectDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
            //维护父子关系
            Map<Long, Long> parentMap = new HashMap<>();
            for (BudgetProjectDetailEntity cde : detailList) {
                parentMap.put(cde.getChangeBid(), cde.getId());
            }
            for (BudgetProjectDetailEntity cde : detailList) {
                if (cde.getParentId() != null && cde.getParentId() > 0) {
                    cde.setParentId(parentMap.get(cde.getParentId()));
                }
            }
            budgetProjectDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
        if (leaf == subject) {
            budgetEntity.setLinkedFlag(1);
            budgetEntity.setUnassociate(0);
        } else {
            budgetEntity.setLinkedFlag(0);
            budgetEntity.setUnassociate(leaf - subject);//全部末级数量减去已关联
        }*/
        budgetProjectService.saveOrUpdate(budgetEntity);

        changeEntity.setUsedTime(new Date());
        //entity.setBeforeContractName(contractEntity.getContractName());
        changeService.saveOrUpdate(changeEntity, false);
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(billId), BillCons.BUDGET_CHANGE_BILL_TYPE, BillCons.BUDGET_CHANGE_SOURCE_TYPE,
                String.valueOf(budgetEntity.getId()), BillCons.BUDGET_BILL_TYPE, BillCons.BUDGET_SOURCE_TYPE);
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error("变更单暂不支持回退功能!");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
