package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailHistoryEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.bean.BudgetProjectHistoryEntity;
import com.ejianc.business.budget.mapper.BudgetProjectHistoryMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailHistoryService;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetProjectHistoryService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.BudgetProjectChangeVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailChangeVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailHistoryVO;
import com.ejianc.business.budget.vo.BudgetProjectHistoryVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailHistoryComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目预算记录表
 *
 * @author generator
 *
 */
@Service("budgetProjectHistoryService")
public class BudgetProjectHistoryServiceImpl extends BaseServiceImpl<BudgetProjectHistoryMapper, BudgetProjectHistoryEntity> implements IBudgetProjectHistoryService{

    @Autowired
    private IBudgetProjectDetailHistoryService historyDetailService;
    @Autowired
    private IBudgetProjectService budgetService;

    @Autowired
    private IBudgetProjectDetailService budgetProjectDetailService;

    @Override
    public BudgetProjectHistoryVO queryDetailByChangeId(Long id) {

        BudgetProjectHistoryEntity historyEntity = baseMapper.selectOne(new QueryWrapper<BudgetProjectHistoryEntity>().eq("change_id", id));
        if(historyEntity !=null){
            BudgetProjectHistoryVO historyVo = BeanMapper.map(historyEntity, BudgetProjectHistoryVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_history_id", new Parameter(QueryParam.EQ, historyEntity.getId()));
            queryParam.getParams().put("change_type", new Parameter(QueryParam.NE, 5));
            //queryParam.getOrderMap().put("detailIndex", "asc");
            List<BudgetProjectDetailHistoryEntity> historyDetailEntities = historyDetailService.queryList(queryParam, false);

            if(historyDetailEntities != null && historyDetailEntities.size() > 0) {
                List<BudgetProjectDetailHistoryVO> detailVos = BeanMapper.mapList(historyDetailEntities, BudgetProjectDetailHistoryVO.class);
                //实现排序
                Collections.sort(detailVos,new BudgetDetailHistoryComparatoeVo());
                for(BudgetProjectDetailHistoryVO cdEntity:detailVos){
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                    //cdEntity.setRowState("edit");
                }
                historyVo.setCheckList(TreeNodeBUtil.buildTree(detailVos));
            }

            return historyVo;
        }
        return null;
    }

    @Override
    public BudgetProjectChangeVO queryChange(Long budgetId, Boolean compareFirst) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        QueryWrapper<BudgetProjectHistoryEntity> wrapper = new QueryWrapper<BudgetProjectHistoryEntity>()
                .eq("budget_id", budgetId)
                .in("bill_state", billStatus);
        if (compareFirst) {
            wrapper.orderByAsc("change_version");
        } else {
            wrapper.orderByDesc("change_version");
        }
        wrapper.last("limit 1");
        BudgetProjectHistoryEntity historyEntity = baseMapper.selectOne(wrapper);
        if (null != historyEntity) {
            //Map<Long, BudgetProjectDetailHistoryEntity> map = selectById(historyEntity.getId()).getCheckList().stream().filter(t-> t.getChangeType() == null || t.getChangeType().intValue() != 5).collect(Collectors.toMap(BudgetProjectDetailHistoryEntity::getBudgetDetailId, Function.identity(), (key1, key2) -> key1));
            List<BudgetProjectDetailHistoryEntity> historyEntityList = selectById(historyEntity.getId()).getCheckList().stream().filter(t -> t.getChangeType() == null || t.getChangeType().intValue() != 5).collect(Collectors.toList());
            List<BudgetProjectDetailHistoryVO> detailHistoryVOS = BeanMapper.mapList(historyEntityList, BudgetProjectDetailHistoryVO.class);
            BudgetProjectEntity entity = budgetService.getById(budgetId);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_id", new Parameter(QueryParam.EQ, budgetId));
            queryParam.getParams().put("change_type", new Parameter(QueryParam.NE, 5));
            List<BudgetProjectDetailEntity> purchaseDetailss = budgetProjectDetailService.queryList(queryParam, false);
            entity.setCheckList(purchaseDetailss);
            BudgetProjectChangeVO changeVO = BeanMapper.map(entity, BudgetProjectChangeVO.class);
            changeVO.setBeforeChangeBudgetMny(historyEntity.getBudgetMny());
            List<BudgetProjectDetailChangeVO> checkList = changeVO.getCheckList();
            CompareDifferenceUtil.compareList(detailHistoryVOS, checkList, true);

            /*for (BudgetProjectDetailChangeVO detailVO : changeVO.getCheckList()) {
                if (detailVO.getChangeType() != null && detailVO.getChangeType().intValue() == 5) {
                    detailVO.setChangeFlag("del");
                    detailVO.setBeforeChangeCode(detailVO.getCode());
                    detailVO.setBeforeChangeName(detailVO.getName());
                    detailVO.setBeforeChangeProjectFeature(detailVO.getProjectFeature());
                    detailVO.setBeforeChangeUnit(detailVO.getUnit());
                    detailVO.setBeforeChangeNum(detailVO.getNum());
                    detailVO.setBeforeChangePrice(detailVO.getPrice());
                    detailVO.setBeforeChangeMny(detailVO.getMny());
                    detailVO.setCode(null);
                    detailVO.setName(null);
                    detailVO.setProjectFeature(null);
                    detailVO.setUnit(null);
                    detailVO.setNum(null);
                    detailVO.setPrice(null);
                    detailVO.setMny(null);
                    continue;
                }
                BudgetProjectDetailHistoryEntity projectDetailEntity = map.get(detailVO.getId());
                if (null != projectDetailEntity) {
                    detailVO.setBeforeChangeCode(projectDetailEntity.getCode());
                    detailVO.setBeforeChangeName(projectDetailEntity.getName());
                    detailVO.setBeforeChangeProjectFeature(projectDetailEntity.getProjectFeature());
                    detailVO.setBeforeChangeUnit(projectDetailEntity.getUnit());
                    detailVO.setBeforeChangeNum(projectDetailEntity.getNum());
                    detailVO.setBeforeChangePrice(projectDetailEntity.getPrice());
                    detailVO.setBeforeChangeMny(projectDetailEntity.getMny());
                    if (!nullToTrim(detailVO.getBeforeChangeCode()).equals(nullToTrim(detailVO.getCode())) || !nullToTrim(detailVO.getBeforeChangeName()).equals(nullToTrim(detailVO.getName()))
                            || !nullToTrim(detailVO.getBeforeChangeProjectFeature()).equals(nullToTrim(detailVO.getProjectFeature())) || !nullToTrim(detailVO.getBeforeChangeUnit()).equals(nullToTrim(detailVO.getUnit()))
                            || !ComputeUtil.equals(detailVO.getBeforeChangeNum(), detailVO.getNum()) || !ComputeUtil.equals(detailVO.getBeforeChangePrice(), detailVO.getPrice())
                            || !ComputeUtil.equals(detailVO.getBeforeChangeMny(), detailVO.getMny())
                    ) {
                        detailVO.setChangeFlag("update");
                    } else
                        detailVO.setChangeFlag("unchange");
                } else {
                    detailVO.setChangeFlag("add");
                }
            }*/
            changeVO.setCheckList(TreeNodeBUtil.buildTree(checkList));
            return changeVO;
        }
        return null;
    }

    private String nullToTrim(String source){
        if (null == source) {
            return "";
        }
        return source;
    }
}
