package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.CtrlSetDetailEntity;
import com.ejianc.business.cost.bean.CtrlSetEntity;
import com.ejianc.business.cost.service.ICtrlSetDetailService;
import com.ejianc.business.cost.service.ICtrlSetService;
import com.ejianc.business.cost.vo.CtrlSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物料管控方式设置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("ctrlSet")
public class CtrlSetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICtrlSetDetailService ctrlSetDetailService;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ICtrlSetService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CtrlSetVO> saveOrUpdate(@RequestBody CtrlSetVO saveOrUpdateVO) {
    	CtrlSetEntity entity = BeanMapper.map(saveOrUpdateVO, CtrlSetEntity.class);
    	service.saveOrUpdate(entity, false);
    	CtrlSetVO vo = BeanMapper.map(entity, CtrlSetVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdateBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdateBatch(@RequestBody List<CtrlSetVO> ctrlSetVOS) {
        if (CollectionUtils.isNotEmpty(ctrlSetVOS)) {
            List<String> codeList = ctrlSetVOS.stream().map(CtrlSetVO::getCode).collect(Collectors.toList());
            LambdaQueryWrapper<CtrlSetEntity> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.in(CtrlSetEntity::getCode, codeList);
            List<CtrlSetEntity> setEntities = service.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(setEntities)) {
                codeList = setEntities.stream().map(CtrlSetEntity::getCode).collect(Collectors.toList());
                throw new BusinessException("分类编码[" + StringUtils.join(codeList, ",") + "]已存在!");
            }
            List<CtrlSetEntity> list = BeanMapper.mapList(ctrlSetVOS, CtrlSetEntity.class);
            service.saveOrUpdateBatch(list);
        }
        return CommonResponse.success("保存或修改单据成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CtrlSetVO> queryDetail(Long id) {
    	CtrlSetEntity entity = service.selectById(id);
    	CtrlSetVO vo = BeanMapper.map(entity, CtrlSetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CtrlSetVO> vos) {
        List<Long> longs = vos.stream().map(CtrlSetVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<CtrlSetDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(CtrlSetDetailEntity::getSetId, longs);
        if(ctrlSetDetailService.count(queryWrapper) > 0){
            throw  new BusinessException("明细有数据，不允许删除!");
        }
        service.removeByIds(vos.stream().map(CtrlSetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CtrlSetVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        IPage<CtrlSetEntity> page = service.queryPage(param,false);
        IPage<CtrlSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CtrlSetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CtrlSetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CtrlSet-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCtrlSetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CtrlSetVO>> refCtrlSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CtrlSetEntity> page = service.queryPage(param,false);
        IPage<CtrlSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CtrlSetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
