package com.ejianc.business.cost.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.CtrlSetDetailEntity;
import com.ejianc.business.cost.bean.CtrlSetEntity;
import com.ejianc.business.cost.service.ICtrlSetDetailService;
import com.ejianc.business.cost.service.ICtrlSetService;
import com.ejianc.business.cost.vo.CtrlSetDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/ctrlSet/")
public class CtrlSetApi {

    @Autowired
    private ICtrlSetService service;

    @Autowired
    private ICtrlSetDetailService detailService;




    @RequestMapping(value = "querySetDetailByCategory", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<CtrlSetDetailVO>> querySetDetailByCategory(@RequestBody List<Long> categoryIds) {

        QueryWrapper<CtrlSetEntity> queryWrapper =  new QueryWrapper<>();
        queryWrapper.in("category_id", categoryIds);
        List<CtrlSetEntity> ctrlSetEntities = service.list(queryWrapper);
        List<CtrlSetDetailVO> ctrlSetDetailVO = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(ctrlSetEntities)){
            List<Long> collect = ctrlSetEntities.stream().map(e -> e.getId()).collect(Collectors.toList());
            Map<Long, Long> collect1 = ctrlSetEntities.stream().collect(Collectors.toMap(e -> e.getId(), e -> e.getCategoryId()));
            QueryWrapper<CtrlSetDetailEntity> wrapper = new QueryWrapper<>();
            wrapper.in("set_id", collect);
            List<CtrlSetDetailEntity> ctrlSetDetailEntities = detailService.list(wrapper);
            ctrlSetDetailVO = BeanMapper.mapList(ctrlSetDetailEntities, CtrlSetDetailVO.class);
            for (CtrlSetDetailVO ctrlSetDetailVO1 : ctrlSetDetailVO){
                Long aLong = collect1.get(ctrlSetDetailVO1.getSetId());
                ctrlSetDetailVO1.setSetId(aLong);
            }
        }
        return CommonResponse.success(ctrlSetDetailVO);
    }
}
