package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.ApprovmentEntity;
import com.ejianc.business.cost.bean.ClaimEntity;
import com.ejianc.business.cost.service.IApprovmentService;
import com.ejianc.business.cost.service.IClaimService;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("approvment")
public class ApprovmentBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IClaimService claimService;
	@Autowired
	private IApprovmentService approvmentService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ApprovmentEntity entity = approvmentService.selectById(billId);
		LambdaUpdateWrapper<ClaimEntity> updateWrapper = Wrappers.lambdaUpdate();
		updateWrapper.eq(ClaimEntity::getId, entity.getClaimId());
		updateWrapper.set(ClaimEntity::getFirstAgreeMny, entity.getFirstAgreeMny());
		updateWrapper.set(ClaimEntity::getLockState, entity.getLockState());
		if(!claimService.update(updateWrapper)){
			throw new BusinessException("更新对外签证单失败!");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ApprovmentEntity entity = approvmentService.selectById(billId);
		LambdaQueryWrapper<ApprovmentEntity> queryWrapper = Wrappers.lambdaQuery();
		queryWrapper.eq(ApprovmentEntity::getClaimId, entity.getClaimId());
		queryWrapper.ne(ApprovmentEntity::getId, entity.getId());
		queryWrapper.orderByDesc(ApprovmentEntity::getOccurDate);
		queryWrapper.last("limit 1");
		ApprovmentEntity approvmentEntity = approvmentService.getOne(queryWrapper, false);
		if(null != approvmentEntity && approvmentEntity.getOccurDate().compareTo(entity.getOccurDate()) > 0){
			throw new BusinessException("非最新的甲方批复单，不允许撤回!");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
