package com.ejianc.business.budget.service.impl;


// 1. 框架与工具库​
// MyBatis-Plus​​（ORM框架）：
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
// Spring Framework​​（核心框架）：
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
//​Checker Framework​​（静态分析工具）：
import org.checkerframework.checker.units.qual.A;

// 2. 项目内部模块​
// 业务模块（com.ejianc.business.hk）：
//import com.ejianc.business.hk.enums.ArchivesEnum;  // 枚举定义
import com.ejianc.business.budget.mapper.BudgetProjectProReportMapper;  // Mapper接口（数据访问层）
import com.ejianc.business.budget.query.BudgetProjectProReportQuery;  // 查询参数对象（DTO）
import com.ejianc.business.budget.service.IBudgetProjectProReportService;  // 服务接口（业务层）
import com.ejianc.business.budget.vo.BudgetProjectProReportVO;  // 视图对象（VO）
//import com.ejianc.business.hk.vo.HKDefdocDetailVO;  // 其他业务VO
// 组织中心模块（com.ejianc.foundation.orgcenter）：
import com.ejianc.foundation.orgcenter.api.IOrgApi;  // 组织中心API
import com.ejianc.foundation.orgcenter.vo.OrgVO;  // 组织中心VO
// 支持模块（com.ejianc.foundation.support）：
import com.ejianc.foundation.support.api.IDefdocApi;  // 文档服务API
import com.ejianc.foundation.support.vo.DefdocDetailVO;  // 文档服务VO
//​基础框架（com.ejianc.framework.core）：
import com.ejianc.framework.core.context.InvocationInfoProxy;  // 上下文代理
import com.ejianc.framework.core.exception.BusinessException;  // 自定义异常
import com.ejianc.framework.core.response.CommonResponse;  // 统一响应封装

// 3.Java 标准库​
// 集合与工具类：
import java.util.ArrayList;  // 动态数组
import java.util.List;  // 列表接口
import java.util.Map;  // 键值对接口
// 函数式编程：
import java.util.function.Function;  // 函数式接口
import java.util.stream.Collectors;  // Stream操作工具

@Service("BudgetProjectProReportServiceImpl")
public class BudgetProjectProReportServiceImpl implements IBudgetProjectProReportService {

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDefdocApi defdocApi;

    //@Autowired
    //private HkBaseService hkBaseService;

    @Autowired
    private BudgetProjectProReportMapper budgetProjectProReportMapper;

    @Override
    public IPage<BudgetProjectProReportVO> queryBudgetProjectProReportList(BudgetProjectProReportQuery query) {

        /** 租户隔离 */
        // query.xxx,是query里面的代码
        // InvocationInfoProxy这个是依赖里面的东西，跟着写就行了
        query.setTenantId(InvocationInfoProxy.getTenantid());

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        query.setOrgIdList(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        IPage<BudgetProjectProReportVO> page = new Page<>(query.getPageNum(), query.getPageSize());
        List<BudgetProjectProReportVO> result = new ArrayList<>();
        if (query.getDisAblePage()){
            result = budgetProjectProReportMapper.queryBudgetProjectProReportList(null, query);
        }else{
            result = budgetProjectProReportMapper.queryBudgetProjectProReportList(page, query);
        }

        // 设置分页
        page.setRecords(result);

        return page;

    }

}