package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.cost.bean.xml.*;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

@Controller
@RequestMapping("ydbx")
public class YdbxController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @RequestMapping(value = "/excelImportZip", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportZip(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = FileUtils.getFileExt(originalFileName, false);

            // 检查是否为.ydbx文件
            if (!"ydbx".equalsIgnoreCase(extName)) {
                return CommonResponse.error("请上传.ydbx文件");
            }
            try {
                // 直接当作zip文件处理
                processYdbxAsZip(mf);
            } catch (Exception e) {
                logger.error("处理.ydbx文件失败", e);
                return CommonResponse.error("文件处理失败：" + e.getMessage());
            }
        }
        return CommonResponse.success("导入成功");
    }

    public static ConstructionProject processYdbxAsZip(MultipartFile file) throws Exception {
        // 一次性读取文件内容到字节数组中，避免多次读取输入流
        byte[] fileBytes = file.getBytes();

        // 第一遍：解析Projects.xml并收集需要处理的文件
        ConstructionProject project = null;

        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileBytes);
             ZipInputStream zis = new ZipInputStream(byteArrayInputStream)) {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if ("Projects.xml".equals(entry.getName())) {
                    project = parseProjectsXml(zis);
                    collectRequiredFiles(project,fileBytes);
                    break;
                }
            }
        }
        return project;
    }

    /**
     * 收集所有需要处理的关联文件
     */
    public static  void collectRequiredFiles(ConstructionProject project,byte[] fileBytes) throws  Exception {
        if (project.getProjectfee() != null && project.getProjectfee().getSectionalWorks() != null) {
            for (SectionalWorks sectionalWorks : project.getProjectfee().getSectionalWorks()) {
                if (sectionalWorks.getUnitWorks() != null) {
                    for (UnitWorks unitWork : sectionalWorks.getUnitWorks()) {
                        String relFileName = unitWork.getRelFileName();
                        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileBytes);
                             ZipInputStream zis = new ZipInputStream(byteArrayInputStream)) {
                            ZipEntry entry;
                            while ((entry = zis.getNextEntry()) != null) {
                                if (relFileName.equals(entry.getName())) {
//                                   处理@_n.xml文件
                                    List<SummaryItemInfo> summaryItemInfos = parseSummaryItemInfo(zis);
                                    unitWork.setSummaryItemInfos(summaryItemInfos);
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static  List<SummaryItemInfo> parseSummaryItemInfo(InputStream inputStream) throws Exception  {
        SAXReader reader = new SAXReader();
        Document document = reader.read(inputStream);
        // 解析根元素
        Element rootElement = document.getRootElement();
        Element Summary = rootElement.element("Summary");
        List<SummaryItemInfo> summaryItemInfos = new ArrayList<>();
        List< Element> elements = Summary.elements("SummaryItem");
        if(ListUtil.isNotEmpty( elements)){
            for (Element e : elements) {
                SummaryItemInfo summaryItemInfo = new SummaryItemInfo();
                summaryItemInfo.setOrdCode(e.attributeValue("OrdCode"));
                summaryItemInfo.setName(e.attributeValue("Name"));
                summaryItemInfo.setCalcVariable(e.attributeValue("CalcVariable"));
                summaryItemInfo.setCalcBasis(e.attributeValue("CalcBasis"));
                summaryItemInfo.setKindCode(e.attributeValue("KindCode"));
                summaryItemInfo.setFormula(e.attributeValue("Formula"));
                summaryItemInfo.setQfjs(e.attributeValue("Qfjs"));
                summaryItemInfo.setRate(e.attributeValue("Rate"));
                summaryItemInfo.setTotal(e.attributeValue("Total"));
                summaryItemInfo.setRemark(e.attributeValue("Remark"));
                if("1".equals(e.attributeValue("OrdCode"))){
                    Element BillTable = rootElement.element("BillTable");
                    List<DivisionalWorkInfo> billTablesList = new ArrayList<>();
                    List< Element> billTableElements = BillTable.elements("DivisionalWorks");
                    if(ListUtil.isNotEmpty( billTableElements)){
                        for (Element billTableElement : billTableElements) {
                            DivisionalWorkInfo divisionalWorkInfo = new DivisionalWorkInfo();
                            divisionalWorkInfo.setName(billTableElement.attributeValue("Name"));
                            divisionalWorkInfo.setCode(billTableElement.attributeValue("Code"));
                            divisionalWorkInfo.setAttr(billTableElement.attributeValue("Attr"));
                            divisionalWorkInfo.setUnit(billTableElement.attributeValue("Unit"));
                            divisionalWorkInfo.setQuantity(billTableElement.attributeValue("Quantity"));
                            divisionalWorkInfo.setTotal(billTableElement.attributeValue("Total"));
                            divisionalWorkInfo.setTotalCode(billTableElement.attributeValue("TotalCode"));
                            divisionalWorkInfo.setRemark(billTableElement.attributeValue("Remark"));
                            divisionalWorkInfo.setZgj(billTableElement.attributeValue("Zgj"));
                            List<ListProjectInfo> listProjects = new ArrayList<>();
                            List< Element> listProjectElements = billTableElement.elements("ListProjects");
                            if(ListUtil.isNotEmpty( listProjectElements)){
                                for (Element listProjectElement : listProjectElements) {
                                    ListProjectInfo listProjectInfo = new ListProjectInfo();
                                    listProjectInfo.setCode(listProjectElement.attributeValue("Code"));
                                    listProjectInfo.setName(listProjectElement.attributeValue("Name"));
                                    listProjectInfo.setAttr(listProjectElement.attributeValue("Attr"));
                                    listProjectInfo.setContent(listProjectElement.attributeValue("Content"));
                                    listProjectInfo.setUnit(listProjectElement.attributeValue("Unit"));
                                    listProjectInfo.setQuantity(listProjectElement.attributeValue("Quantity"));
                                    listProjectInfo.setPrice(listProjectElement.attributeValue("Price"));
                                    listProjectInfo.setCalcType(listProjectElement.attributeValue("CalcType"));
                                    listProjectInfo.setCalcBasis(listProjectElement.attributeValue("CalcBasis"));
                                    listProjectInfo.setFormula(listProjectElement.attributeValue("Formula"));
                                    listProjectInfo.setRate(listProjectElement.attributeValue("Rate"));
                                    listProjectInfo.setTotal(listProjectElement.attributeValue("Total"));
                                    listProjectInfo.setMajor(listProjectElement.attributeValue("Major"));
                                    listProjectInfo.setTotalCode(listProjectElement.attributeValue("TotalCode"));
                                    listProjectInfo.setSpecialty(listProjectElement.attributeValue("Specialty"));
                                    listProjectInfo.setListingIdentity(listProjectElement.attributeValue("ListingIdentity"));
                                    listProjectInfo.setRemark(listProjectElement.attributeValue("Remark"));
                                    listProjects.add(listProjectInfo);
                                }
                                divisionalWorkInfo.setListProjects(listProjects);
                            }
                            billTablesList.add(divisionalWorkInfo);
                        }
                        summaryItemInfo.setBillTables(billTablesList);
                    }
                    summaryItemInfos.add(summaryItemInfo);
                }
                else if("2".equals(e.attributeValue("OrdCode"))){
                    Element PreliminariesByTotal = rootElement.element("PreliminariesTable").element("PreliminariesByTotal");
                    Element PreliminariesByPrice = rootElement.element("PreliminariesTable").element("PreliminariesByPrice");
                    if(PreliminariesByTotal!=null){
                        List<Element> ListProjects = PreliminariesByTotal.elements("ListProjects");
                        List<ListProjectInfo> listProjects = new ArrayList<>();
                        if(ListUtil.isNotEmpty(ListProjects)){
                            for (Element listProjectElement : ListProjects) {
                                ListProjectInfo listProjectInfo = new ListProjectInfo();
                                listProjectInfo.setCode(listProjectElement.attributeValue("Code"));
                                listProjectInfo.setName(listProjectElement.attributeValue("Name"));
                                listProjectInfo.setAttr(listProjectElement.attributeValue("Attr"));
                                listProjectInfo.setContent(listProjectElement.attributeValue("Content"));
                                listProjectInfo.setUnit(listProjectElement.attributeValue("Unit"));
                                listProjectInfo.setQuantity(listProjectElement.attributeValue("Quantity"));
                                listProjectInfo.setPrice(listProjectElement.attributeValue("Price"));
                                listProjectInfo.setCalcType(listProjectElement.attributeValue("CalcType"));
                                listProjectInfo.setCalcBasis(listProjectElement.attributeValue("CalcBasis"));
                                listProjectInfo.setFormula(listProjectElement.attributeValue("Formula"));
                                listProjectInfo.setRate(listProjectElement.attributeValue("Rate"));
                                listProjectInfo.setTotal(listProjectElement.attributeValue("Total"));
                                listProjectInfo.setMajor(listProjectElement.attributeValue("Major"));
                                listProjectInfo.setTotalCode(listProjectElement.attributeValue("TotalCode"));
                                listProjectInfo.setSpecialty(listProjectElement.attributeValue("Specialty"));
                                listProjectInfo.setListingIdentity(listProjectElement.attributeValue("ListingIdentity"));
                                listProjectInfo.setRemark(listProjectElement.attributeValue("Remark"));
                                listProjects.add(listProjectInfo);
                            }
                        }
                        Element element = PreliminariesByTotal.element("DivisionalWorks");
                        if(element != null){
                            ListProjectInfo listProjectInfo = new ListProjectInfo();
                            listProjectInfo.setCode(element.attributeValue("Code"));
                            listProjectInfo.setName(element.attributeValue("Name"));
                            listProjectInfo.setAttr(element.attributeValue("Attr"));
                            listProjectInfo.setUnit(element.attributeValue("Unit"));
                            listProjectInfo.setRemark(element.attributeValue("Remark"));
                            listProjects.add(listProjectInfo);
                            List<Element> innerListProjects = element.elements("ListProjects");
                            if(ListUtil.isNotEmpty(innerListProjects)){
                                List<ListProjectInfo> innerListProjectList = new ArrayList<>();
                                for (Element listProjectElement : innerListProjects) {
                                    ListProjectInfo innerListProjectInfo = new ListProjectInfo();
                                    innerListProjectInfo.setCode(listProjectElement.attributeValue("Code"));
                                    innerListProjectInfo.setName(listProjectElement.attributeValue("Name"));
                                    innerListProjectInfo.setAttr(listProjectElement.attributeValue("Attr"));
                                    innerListProjectInfo.setContent(listProjectElement.attributeValue("Content"));
                                    innerListProjectInfo.setUnit(listProjectElement.attributeValue("Unit"));
                                    innerListProjectInfo.setQuantity(listProjectElement.attributeValue("Quantity"));
                                    innerListProjectInfo.setPrice(listProjectElement.attributeValue("Price"));
                                    innerListProjectInfo.setCalcType(listProjectElement.attributeValue("CalcType"));
                                    innerListProjectInfo.setCalcBasis(listProjectElement.attributeValue("CalcBasis"));
                                    innerListProjectInfo.setFormula(listProjectElement.attributeValue("Formula"));
                                    innerListProjectInfo.setRate(listProjectElement.attributeValue("Rate"));
                                    innerListProjectInfo.setTotal(listProjectElement.attributeValue("Total"));
                                    innerListProjectInfo.setMajor(listProjectElement.attributeValue("Major"));
                                    innerListProjectInfo.setTotalCode(listProjectElement.attributeValue("TotalCode"));
                                    innerListProjectInfo.setSpecialty(listProjectElement.attributeValue("Specialty"));
                                    innerListProjectInfo.setListingIdentity(listProjectElement.attributeValue("ListingIdentity"));
                                    innerListProjectInfo.setRemark(listProjectElement.attributeValue("Remark"));
                                    innerListProjectList.add(innerListProjectInfo);
                                }
                                listProjectInfo.setInnerListProjectInfos(innerListProjectList);
                            }
                        }
                        summaryItemInfo.setPreliminariesByTotal(listProjects);
                    }
                    if(PreliminariesByPrice!=null){
                        List<Element> ListProjects = PreliminariesByPrice.elements("ListProjects");
                        List<ListProjectInfo> listProjects = new ArrayList<>();
                        if(ListUtil.isNotEmpty(ListProjects)){
                            for (Element listProjectElement : ListProjects) {
                                ListProjectInfo listProjectInfo = new ListProjectInfo();
                                listProjectInfo.setCode(listProjectElement.attributeValue("Code"));
                                listProjectInfo.setName(listProjectElement.attributeValue("Name"));
                                listProjectInfo.setAttr(listProjectElement.attributeValue("Attr"));
                                listProjectInfo.setContent(listProjectElement.attributeValue("Content"));
                                listProjectInfo.setUnit(listProjectElement.attributeValue("Unit"));
                                listProjectInfo.setQuantity(listProjectElement.attributeValue("Quantity"));
                                listProjectInfo.setPrice(listProjectElement.attributeValue("Price"));
                                listProjectInfo.setCalcType(listProjectElement.attributeValue("CalcType"));
                                listProjectInfo.setCalcBasis(listProjectElement.attributeValue("CalcBasis"));
                                listProjectInfo.setFormula(listProjectElement.attributeValue("Formula"));
                                listProjectInfo.setRate(listProjectElement.attributeValue("Rate"));
                                listProjectInfo.setTotal(listProjectElement.attributeValue("Total"));
                                listProjectInfo.setMajor(listProjectElement.attributeValue("Major"));
                                listProjectInfo.setTotalCode(listProjectElement.attributeValue("TotalCode"));
                                listProjectInfo.setSpecialty(listProjectElement.attributeValue("Specialty"));
                                listProjectInfo.setListingIdentity(listProjectElement.attributeValue("ListingIdentity"));
                                listProjectInfo.setRemark(listProjectElement.attributeValue("Remark"));
                                listProjects.add(listProjectInfo);
                            }
                        }
                        summaryItemInfo.setPreliminariesByPrice(listProjects);
                    }
                    summaryItemInfos.add(summaryItemInfo);
                }
                else if("3".equals(e.attributeValue("OrdCode"))){
                    Element ExtraTable = rootElement.element("ExtraTable");
                    if(ExtraTable!=null){
                        List<Element> ExtraItems = ExtraTable.elements("ExtraItem");
                        List<ExtraItem> extraItems = new ArrayList<>();
                        if(ListUtil.isNotEmpty(ExtraItems)){
                            for (Element element : ExtraItems) {
                                ExtraItem extraItem = new ExtraItem();
                                extraItem.setName(element.attributeValue("Name"));
                                extraItem.setCode(element.attributeValue("Code"));
                                extraItem.setCalcVariable(element.attributeValue("CalcVariable"));
                                extraItem.setCalcBasis(element.attributeValue("CalcBasis"));
                                extraItem.setUnit(element.attributeValue("Unit"));
                                extraItem.setQuantity(element.attributeValue("Quantity"));
                                extraItem.setPrice(element.attributeValue("Price"));
                                extraItem.setFormula(element.attributeValue("Formula"));
                                extraItem.setRate(element.attributeValue("Rate"));
                                extraItem.setTotal(element.attributeValue("Total"));
                                extraItem.setKind(element.attributeValue("Kind"));
                                extraItem.setXmlb(element.attributeValue("Xmlb"));
                                extraItem.setRemark(element.attributeValue("Remark"));
                                extraItems.add(extraItem);
                            }
                        }
                        summaryItemInfo.setExtraTables(extraItems);
                    }
                    summaryItemInfos.add(summaryItemInfo);
                }
                else if("4".equals(e.attributeValue("OrdCode"))){
                    Element element = rootElement.element("StatutoryFees").element("StatutoryFeesItem");
                    StatutoryFeesItem statutoryFeesItem = new StatutoryFeesItem();
                    statutoryFeesItem.setOrdCode(element.attributeValue("OrdCode"));
                    statutoryFeesItem.setCalcVariable(element.attributeValue("CalcVariable"));
                    statutoryFeesItem.setName(element.attributeValue("Name"));
                    statutoryFeesItem.setCalcBasis(element.attributeValue("CalcBasis"));
                    statutoryFeesItem.setKindCode(element.attributeValue("KindCode"));
                    statutoryFeesItem.setFormula(element.attributeValue("Formula"));
                    statutoryFeesItem.setRate(element.attributeValue("Rate"));
                    statutoryFeesItem.setTotal(element.attributeValue("Total"));
                    statutoryFeesItem.setRemark(element.attributeValue("Remark"));
                    summaryItemInfo.setStatutoryFeesItem(statutoryFeesItem);
                    summaryItemInfos.add(summaryItemInfo);
                }
                else if("6".equals(e.attributeValue("OrdCode"))){
                    Element element = rootElement.element("TaxTable").element("TaxItem");
                    TaxItem taxItem = new TaxItem();
                    taxItem.setOrdCode(element.attributeValue("OrdCode"));
                    taxItem.setCalcVariable(element.attributeValue("CalcVariable"));
                    taxItem.setName(element.attributeValue("Name"));
                    taxItem.setCalcBasis(element.attributeValue("CalcBasis"));
                    taxItem.setKindCode(element.attributeValue("KindCode"));
                    taxItem.setFormula(element.attributeValue("Formula"));
                    taxItem.setRate(element.attributeValue("Rate"));
                    taxItem.setTotal(element.attributeValue("Total"));
                    taxItem.setRemark(element.attributeValue("Remark"));
                    summaryItemInfo.setTaxItem(taxItem);
                    summaryItemInfos.add(summaryItemInfo);
                }
                else if("5".equals(e.attributeValue("OrdCode")) || "7".equals(e.attributeValue("OrdCode"))){
                    summaryItemInfos.add(summaryItemInfo);
                }
            }
        }
        return summaryItemInfos;
    }

    public static  ConstructionProject parseProjectsXml(InputStream inputStream) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(inputStream);
        // 解析根元素
        Element rootElement = document.getRootElement();
        ConstructionProject project = new ConstructionProject();

        // 解析根元素属性
        project.setNumber(rootElement.attributeValue("Number"));
        project.setName(rootElement.attributeValue("Name"));
        project.setSegment(rootElement.attributeValue("Segment"));
        project.setProjectAdress(rootElement.attributeValue("ProjectAdress"));
        project.setFileKind(rootElement.attributeValue("FileKind"));
        project.setStandardName(rootElement.attributeValue("StandardName"));
        project.setScale(rootElement.attributeValue("Scale"));
        project.setExplains(rootElement.attributeValue("Explains"));
        project.setVersion(rootElement.attributeValue("Version"));
        // 解析Projectfee
        Element projectfeeElement = rootElement.element("Projectfee");
        if (projectfeeElement != null) {
            Projectfee projectfee = parseProjectfee(projectfeeElement);
            project.setProjectfee(projectfee);
        }
        return project;
    }
    public static  Projectfee parseProjectfee(Element projectfeeElement) {
        Projectfee projectfee = new Projectfee();
        projectfee.setName(projectfeeElement.attributeValue("Name"));
        projectfee.setTotal(projectfeeElement.attributeValue("Total"));
        projectfee.setSoftNum(projectfeeElement.attributeValue("SoftNum"));
        projectfee.setScale(projectfeeElement.attributeValue("Scale"));
        projectfee.setRemark(projectfeeElement.attributeValue("Remark"));


        // 解析SectionalWorks列表
        List<Element> sectionalWorksElements = projectfeeElement.elements("SectionalWorks");
        List<SectionalWorks> sectionalWorksList = new ArrayList<>();
        for (Element sectionalWorksElement : sectionalWorksElements) {
            SectionalWorks sectionalWorks = parseSectionalWorks(sectionalWorksElement);
            sectionalWorksList.add(sectionalWorks);
        }
        projectfee.setSectionalWorks(sectionalWorksList);

        return projectfee;
    }
    public static  SectionalWorks parseSectionalWorks(Element sectionalWorksElement) {
        SectionalWorks sectionalWorks = new SectionalWorks();
        sectionalWorks.setName(sectionalWorksElement.attributeValue("Name"));
        sectionalWorks.setTotal(sectionalWorksElement.attributeValue("Total"));
        sectionalWorks.setScale(sectionalWorksElement.attributeValue("Scale"));
        sectionalWorks.setSegment(sectionalWorksElement.attributeValue("Segment"));
        sectionalWorks.setRatios(sectionalWorksElement.attributeValue("Ratios"));
        sectionalWorks.setRemark(sectionalWorksElement.attributeValue("Remark"));


        // 解析UnitWorks列表
        List<Element> unitWorksElements = sectionalWorksElement.elements("UnitWorks");
        List<UnitWorks> unitWorksList = new ArrayList<>();
        for (Element unitWorksElement : unitWorksElements) {
            UnitWorks unitWorks = new UnitWorks();
            unitWorks.setRelFileName(unitWorksElement.attributeValue("RelFileName"));
            unitWorks.setNumber(unitWorksElement.attributeValue("Number"));
            unitWorks.setName(unitWorksElement.attributeValue("Name"));
            unitWorks.setSoftNum(unitWorksElement.attributeValue("SoftNum"));
            unitWorks.setTotal(unitWorksElement.attributeValue("Total"));
            unitWorks.setSpecialty(unitWorksElement.attributeValue("Specialty"));
            unitWorks.setPurposes(unitWorksElement.attributeValue("Purposes"));
            unitWorks.setScale(unitWorksElement.attributeValue("Scale"));
            unitWorks.setValuationMethod(unitWorksElement.attributeValue("ValuationMethod"));
            unitWorks.setTaxModel(unitWorksElement.attributeValue("TaxModel"));
            unitWorks.setListingIdentity(unitWorksElement.attributeValue("ListingIdentity"));
            unitWorks.setNormIdentity(unitWorksElement.attributeValue("NormIdentity"));
            unitWorks.setRemark(unitWorksElement.attributeValue("Remark"));
            unitWorksList.add(unitWorks);
        }
        sectionalWorks.setUnitWorks(unitWorksList);

        return sectionalWorks;
    }
}
