package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.*;
import com.ejianc.business.budget.service.*;
import com.ejianc.business.budget.vo.QuotaDetailAccessVO;
import com.ejianc.business.budget.vo.QuotaDetailTemporaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.google.common.base.Joiner;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 临时人工定额明细审核
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("quotaDetailTemporary")
public class QuotaDetailTemporaryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;


    @Autowired
    private IQuotaDetailTemporaryService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IQuotaDetailService detailService;

    @Autowired
    private IQuotaService quotaService;


    @Autowired
    private IQuotaMatTemporaryService quotaMatTemporaryService;

    @Autowired
    private IQuotaMatService quotaMatService;

    /**
     * @Description 批量准入正式
     */
    @RequestMapping(value = "/batchAccess", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> batchAccess(@RequestBody QuotaDetailAccessVO accessVO) {
        Long quotaTypeId = accessVO.getQuotaTypeId();
        if (quotaTypeId == null) {
            throw new BusinessException("请选择定额库分类!");
        }
        List<Long> detailIds = accessVO.getDetailIds();
        if (CollectionUtils.isEmpty(detailIds)) {
            throw new BusinessException("请选择定额库明细!");
        }
        List<QuotaDetailTemporaryEntity> detailTemporaryEntities = (List<QuotaDetailTemporaryEntity>) service.listByIds(detailIds);

        LambdaQueryWrapper<QuotaEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(QuotaEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(QuotaEntity::getEnableState, 1);
        QuotaEntity quotaEntity = quotaService.getOne(queryWrapper, false);
        if (quotaEntity == null) {
            throw new BusinessException("未查询到启用的定额库!");
        }
        Long quotaId = quotaEntity.getId();
        List<String> detailCodes = detailTemporaryEntities.stream().filter(t -> t.getDetailCode() != null).map(e -> e.getDetailCode()).collect(Collectors.toList());

        LambdaQueryWrapper<QuotaDetailEntity> detailEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
        detailEntityLambdaQueryWrapper.eq(QuotaDetailEntity::getQuotaId, quotaId);
        detailEntityLambdaQueryWrapper.in(QuotaDetailEntity::getDetailCode, detailCodes);
        List<QuotaDetailEntity> list = detailService.list(detailEntityLambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            List<String> repeatDetailCodes = list.stream().filter(t -> t.getDetailCode() != null).map(e -> e.getDetailCode()).collect(Collectors.toList());
            throw new BusinessException(Joiner.on(",").join(repeatDetailCodes) + "定额编码重复，修改后再入库！");
        }

        for (QuotaDetailTemporaryEntity detailTemporaryEntity : detailTemporaryEntities) {
            detailTemporaryEntity.setQuotaId(quotaId);
            detailTemporaryEntity.setQuotaTypeId(quotaTypeId);
            detailTemporaryEntity.setPushFlag(1);
        }
        List<QuotaDetailEntity> quotaDetailEntities = BeanMapper.mapList(detailTemporaryEntities, QuotaDetailEntity.class);
        boolean b = detailService.saveOrUpdateBatch(quotaDetailEntities);
        if (b) {
            LambdaQueryWrapper<QuotaMatTemporaryEntity> matTemporaryEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
            matTemporaryEntityLambdaQueryWrapper.in(QuotaMatTemporaryEntity::getQuotaDetailId, detailIds);
            List<QuotaMatTemporaryEntity> quotaMatTemporaryEntities = quotaMatTemporaryService.list(matTemporaryEntityLambdaQueryWrapper);
            if(CollectionUtils.isNotEmpty(quotaMatTemporaryEntities)){
                for (QuotaMatTemporaryEntity quotaMatTemporaryEntity : quotaMatTemporaryEntities) {
                    quotaMatTemporaryEntity.setQuotaId(quotaId);
                    quotaMatTemporaryEntity.setQuotaTypeId(quotaTypeId);
                }
                List<QuotaMatEntity> quotaMatEntities = BeanMapper.mapList(quotaMatTemporaryEntities, QuotaMatEntity.class);
                quotaMatService.saveOrUpdateBatch(quotaMatEntities);
            }
            // 临时定额改为已推送正式状态
            service.saveOrUpdateBatch(detailTemporaryEntities);
        }

        return CommonResponse.success("准入正式库成功！");
    }


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuotaDetailTemporaryVO> saveOrUpdate(@RequestBody QuotaDetailTemporaryVO saveOrUpdateVO) {
       /* LambdaQueryWrapper<QuotaDetailTemporaryEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.ne(null != saveOrUpdateVO.getId(), QuotaDetailTemporaryEntity::getId, saveOrUpdateVO.getId());
        queryWrapper.eq(QuotaDetailTemporaryEntity::getDetailCode, StringUtils.trim(saveOrUpdateVO.getDetailCode()));
        if (service.count(queryWrapper) > 0) {
            throw new BusinessException("编码重复,不允许保存!");
        }*/
        QuotaDetailTemporaryEntity entity = BeanMapper.map(saveOrUpdateVO, QuotaDetailTemporaryEntity.class);
        if (CollectionUtils.isNotEmpty(entity.getMatList())) {
            List<String> nameList = entity.getMatList().stream().filter(x -> !"del".equals(x.getRowState())).map(QuotaMatTemporaryEntity::getMaterialName).collect(Collectors.toList());
            entity.setMatName(StringUtils.join(nameList, ","));
        }
        entity.setPushFlag(0);
        service.saveOrUpdate(entity, false);
        QuotaDetailTemporaryVO vo = BeanMapper.map(entity, QuotaDetailTemporaryVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuotaDetailTemporaryVO> queryDetail(Long id) {
        QuotaDetailTemporaryEntity entity = service.selectById(id);
        QuotaDetailTemporaryVO vo = BeanMapper.map(entity, QuotaDetailTemporaryVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotaDetailTemporaryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (QuotaDetailTemporaryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(QuotaDetailTemporaryVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QuotaDetailTemporaryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("detailCode", "detailName", "sourceProjectName", "sourceBillCode"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("pushFlag", new Parameter(QueryParam.EQ, 0));

        IPage<QuotaDetailTemporaryEntity> page = service.queryPage(param, false);
        IPage<QuotaDetailTemporaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotaDetailTemporaryVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<QuotaDetailTemporaryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("QuotaDetailTemporary-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refQuotaDetailTemporaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<QuotaDetailTemporaryVO>> refQuotaDetailTemporaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                     String condition,
                                                                                     String searchObject,
                                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<QuotaDetailTemporaryEntity> page = service.queryPage(param, false);
        IPage<QuotaDetailTemporaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotaDetailTemporaryVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
