package com.ejianc.business.budget.controller;

// 工具类
import cn.hutool.core.date.DateUtil;   // 日期处理
import org.apache.commons.collections.CollectionUtils;  // 集合工具
import org.apache.commons.lang3.StringUtils;  // 字符串工具
// 分页
import com.baomidou.mybatisplus.core.metadata.IPage;
// 业务相关
import com.ejianc.business.budget.query.BudgetProjectProExportQuery;
import com.ejianc.business.budget.service.IBudgetProjectProExportService;
import com.ejianc.business.budget.utils.ExportExcelUtil;
import com.ejianc.business.budget.vo.BudgetProjectProExportVO;

// 1. 查询参数对象（DTO）
//import com.ejianc.business.hk.query.ProjectAccountabilityAllocationQuery;
// 需要手写：定义查询参数（如分页参数、过滤条件等）
//----------------------
// 2. Service接口
//import com.ejianc.business.hk.service.IProjectAccountabilityAllocationService;
// 需要手写：定义业务逻辑接口（如查询报表数据的方法）
//----------------------
// 3. Excel导出工具类
//import com.ejianc.business.hk.utils.ExportExcelUtil;
// 可能需要手写：如果这个工具类是项目自定义的Excel处理逻辑
//----------------------
// 4. 视图对象（VO）
//import com.ejianc.business.hk.vo.ProjectAccountabilityAllocationVO;
// 需要手写：定义返回给前端的结构化数据格式

// 框架响应
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
// Spring相关
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
// Servlet
import javax.servlet.http.HttpServletResponse;
// Java基础
import java.util.ArrayList;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
// 未使用的实体类
// ---
// 未使用的工具类
//import com.ejianc.business.hk.utils.CellModel;
// 未使用的VO类
//import com.ejianc.business.hk.vo.SunkCostReportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
// 未使用的框架组件
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;

@Controller
@RequestMapping("budgetProjectProExportPerson")
public class BudgetProjectProExportController {

    // @Autowired 是 Spring 框架提供的一个注解，主要用于自动装配依赖项。
    @Autowired
    private IBudgetProjectProExportService budgetProjectProExportService;

    @RequestMapping(value = "/queryBudgetProjectProExportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectProExportVO>> queryBudgetProjectProExportList(@RequestBody BudgetProjectProExportQuery query) {

        IPage<BudgetProjectProExportVO> page = budgetProjectProExportService.queryBudgetProjectProExportList(query);

        // 查询数据
        return CommonResponse.success("查询列表数据成功！",page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @RequestMapping(value = "/excelReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelReportExport(@RequestBody BudgetProjectProExportQuery query, HttpServletResponse response) {
        query.setDisAblePage(true);
        IPage<BudgetProjectProExportVO> list = budgetProjectProExportService.queryBudgetProjectProExportList(query);

        // 设置导出数据
        List<List<Object>> data = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list.getRecords())) {
            for (BudgetProjectProExportVO item : list.getRecords()) {
                List<Object> row = new ArrayList<>();
                row.add(item.getProjectName()); //项目名称
                row.add(item.getEmployeeName()); //经办人
                row.add(item.getDepartmentName());//经办人部门
                row.add(item.getTaxRate());//综合税率
                row.add(item.getMaterialMny());// 材料费(无税)
                row.add(item.getLaborMny());// 人工费(无税)
                row.add(item.getIndirectionMny());//间接费(无税)
                row.add(item.getMechanicalMny());//其他费(无税)
                row.add(item.getMaterialTaxMny());//材料费
                row.add(item.getLaborTaxMny());//人工费
                row.add(item.getIndirectionTaxMny());//间接费
                row.add(item.getMechanicalTaxMny());//其他费
                row.add(item.getBudgetMny());//成本总金额(无税)
                row.add(item.getBudgetTaxMny());//成本总金额
                row.add(item.getMemo());//备注
                data.add(row);
            }
        }

        // 导出Excel文件的文件名
        String fileName = "budgetProjectProExportPerson"+ DateUtil.now()+".xlsx";

        // 跳过行数默认为表头行数(excel从0开始计算行)
        Integer skipRows = 2;

        // 使用传统的for循环给每个List<Object>的头部添加序号
        if (CollectionUtils.isNotEmpty(data)) {
            int index = 1;
            for (List<Object> objects : data) {
                objects.add(0, index++);
            }
        }

        // 调用工具类导出Excel
        ExportExcelUtil.export("BudgetProjectProExportPerson-export.xlsx", skipRows, fileName, data, null, response);

    }
}