package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetEntity;
import com.ejianc.business.budget.bean.BudgetSetTypeEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetSetDetailService;
import com.ejianc.business.budget.service.IBudgetSetService;
import com.ejianc.business.budget.service.IBudgetSetTypeService;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.business.budget.vo.BudgetSetTypeVO;
import com.ejianc.business.budget.vo.BudgetSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 清单定额关系设置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetSet")
public class BudgetSetController implements Serializable {
	private static final long serialVersionUID = 1L;
    @Autowired
    private IBudgetSetService service;
    @Autowired
    private IBudgetSetDetailService budgetSetDetailService;
    @Autowired
    private IBudgetProjectDetailService budgetProjectDetailService;

    @Autowired
    private IBudgetSetTypeService budgetSetTypeService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetSetVO> saveOrUpdate(@RequestBody BudgetSetVO saveOrUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * @Description copySave 复制
     */
    @RequestMapping(value = "/copySave", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetSetVO> copySave(@RequestBody BudgetSetVO budgetSetVO) {
        return CommonResponse.success("复制单据成功！", service.copySave(budgetSetVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetSetVO> queryDetail(Long id) {
    	BudgetSetEntity entity = service.selectById(id);
    	BudgetSetVO vo = BeanMapper.map(entity, BudgetSetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetSetVO> vos) {
        List<Long> mainIds = vos.stream().map(BudgetSetVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<BudgetSetDetailEntity> qry = new LambdaQueryWrapper<>();
        qry.in(BudgetSetDetailEntity::getSetId, mainIds);
        List<Long> detailIds = null;
        List<BudgetSetDetailEntity> list = budgetSetDetailService.list(qry);
        if (CollectionUtils.isNotEmpty(list)) {
            detailIds = list.stream().map(BudgetSetDetailEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<BudgetProjectDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(BudgetProjectDetailEntity::getSetDetailId, detailIds);
            if (budgetProjectDetailService.count(queryWrapper) > 0) {
                throw new BusinessException("所选清单定额关系设置被[项目预算书]引用，不允许删除!");
            }
        }
        service.removeByIds(mainIds,true);
        if (CollectionUtils.isNotEmpty(detailIds)) {
            budgetSetDetailService.removeByIds(detailIds, true);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetSetVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<BudgetSetEntity> page = service.queryPage(param,false);
        IPage<BudgetSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetSetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BudgetSetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetSet-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBudgetSetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetSetVO>> refBudgetSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BudgetSetEntity> page = service.queryPage(param,false);
        IPage<BudgetSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetSetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @param id
     * @Description updaeEnable 更新启用停用
     */
    @RequestMapping(value = "/updateEnable", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateEnable(Long id, Boolean enableState) {
        if (enableState) {
            LambdaQueryWrapper<BudgetSetEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(BudgetSetEntity::getTenantId, InvocationInfoProxy.getTenantid());
            queryWrapper.ne(BudgetSetEntity::getId, id);
            queryWrapper.eq(BudgetSetEntity::getEnableState, 1);
            BudgetSetEntity budgetSetEntity = service.getOne(queryWrapper, false);
            if (null != budgetSetEntity) {
                budgetSetEntity.setEnableState(0);
                service.saveOrUpdate(budgetSetEntity);
            }
        }
        LambdaUpdateWrapper<BudgetSetEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BudgetSetEntity::getId, id);
        updateWrapper.set(BudgetSetEntity::getEnableState, enableState);
        service.update(updateWrapper);
        return CommonResponse.success("更新启用停用成功！");
    }




    /**
     * @param
     * @Description 选择清单库
     * @Return void
     */
    @RequestMapping(value = "/refBudgetSetType", method = RequestMethod.GET)
    @ResponseBody
    public List<BudgetSetTypeVO> refBudgetSetType(@RequestParam(required = false) String searchText,
                                                  @RequestParam(required = false) String condition) {
        List<BudgetSetTypeVO> typeList = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        LambdaQueryWrapper<BudgetSetEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BudgetSetEntity::getEnableState, 1);
        queryWrapper.eq(BudgetSetEntity::getTenantId, InvocationInfoProxy.getTenantid());
        BudgetSetEntity setEntity = service.getOne(queryWrapper, false);
        if (null != setEntity) {
            LambdaQueryWrapper<BudgetSetTypeEntity> lambda = Wrappers.lambdaQuery();
            lambda.eq(BudgetSetTypeEntity::getSetId, setEntity.getId());
            if (StringUtils.isNotBlank(searchText)) {
                lambda.like(BudgetSetTypeEntity::getTypeName, searchText);
            }
            List<BudgetSetTypeEntity> resList = budgetSetTypeService.list(lambda);
            if (CollectionUtils.isNotEmpty(resList)) {
                typeList = BeanMapper.mapList(resList, BudgetSetTypeVO.class);
                typeList.forEach(e -> {
                    e.setCode(e.getTypeCode());
                    e.setName(e.getTypeName());
                });
            }
        }
        return typeList;
    }

    /**
     * @param
     * @Description 选择清单明细
     * @Return void
     */
    @RequestMapping(value = "/refBudgetSetDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetSetDetailVO>> refQuotaDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   @RequestParam(required = false) String relyCondition,
                                                                   String searchObject,
                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().addAll(Arrays.asList("detailCode", "detailName", "description"));
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        LambdaQueryWrapper<BudgetSetEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BudgetSetEntity::getEnableState, 1);
        queryWrapper.eq(BudgetSetEntity::getTenantId, InvocationInfoProxy.getTenantid());
        BudgetSetEntity setEntity = service.getOne(queryWrapper, false);
        Long setId = 1L;
        if (null != setEntity) {
            setId = setEntity.getId();
        }
        param.getParams().put("setId", new Parameter(QueryParam.EQ, setId));

        Long setTypeId = null;
        if (StringUtils.isNotEmpty(relyCondition)) {
            /** 处理condition */
            setTypeId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("setTypeId", new Parameter(QueryParam.EQ, setTypeId));
        }
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("setTypeId")) {
                setTypeId = Long.valueOf(String.valueOf(_con.get("setTypeId")));
                param.getParams().put("setTypeId", new Parameter(QueryParam.EQ, setTypeId));
            }
        }
        IPage<BudgetSetDetailEntity> page = budgetSetDetailService.queryPage(param, false);
        IPage<BudgetSetDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<BudgetSetDetailVO> detailVOS = BeanMapper.mapList(page.getRecords(), BudgetSetDetailVO.class);
        pageData.setRecords(detailVOS);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

}
