package com.ejianc.business.budget.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目预算API接口：Pro版本
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@RestController
@RequestMapping(value = "/api/budgetProjectPro/")
public class BudgetProjectProApi {
	@Resource
	private IBudgetProjectProService service;
	@Autowired
	private IBudgetProjectDetailProService budgetProjectDetailProService;

	/**
	 * 获取预算量价
	 *
	 * @param paramControlVO 项目预算Pro参数控制VO
	 *
	 * @return {@link CommonResponse}<{@link BudgetProjectProQuantityAndMnyVO}>
	 */
	@PostMapping(value = "/fetchQuantityAndMny")
	public CommonResponse<BudgetProjectProQuantityAndMnyVO> fetchQuantityAndMny(@Validated @RequestBody BudgetProjectProParamControlVO paramControlVO) {
		return CommonResponse.success("请求成功！", service.fetchQuantityAndMny(paramControlVO));
	}

	/**
	 * 根据项目id查询该项目的预算编制单中 物资档案的预算总量
	 * @param projectId
	 * @return
	 */
	@GetMapping(value = "getBudgetProjectProQuantityByProjectId")
	public CommonResponse<Map<Long, BigDecimal>> getBudgetProjectProQuantityByProjectId(@RequestParam(value = "projectId", required = true)  Long projectId){
		return CommonResponse.success("请求成功！", service.getBudgetProjectProQuantityByProjectId(projectId));
	}

	@GetMapping(value = "queryFeeMny")
	public CommonResponse<BigDecimal> queryFeeMny(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "feeTypeId") Long feeTypeId) {
		BigDecimal result = BigDecimal.ZERO;
		LambdaQueryWrapper<BudgetProjectProEntity> queryWrapper = Wrappers.lambdaQuery();
		queryWrapper.eq(BudgetProjectProEntity::getProjectId, projectId);
		queryWrapper.in(BudgetProjectProEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
		List<BudgetProjectProEntity> entities = service.list(queryWrapper);
		if (CollectionUtils.isNotEmpty(entities)) {
			List<Long> idList = entities.stream().map(BudgetProjectProEntity::getId).collect(Collectors.toList());
			LambdaQueryWrapper<BudgetProjectDetailProEntity> query = Wrappers.lambdaQuery();
			query.eq(BudgetProjectDetailProEntity::getLeafFlag, 1);
			query.eq(BudgetProjectDetailProEntity::getSourceId, feeTypeId);
			query.eq(BudgetProjectDetailProEntity::getSourceType, 1);
			query.in(BudgetProjectDetailProEntity::getBudgetId, idList);
			List<BudgetProjectDetailProEntity> infoEntities = budgetProjectDetailProService.list(query);
			if (CollectionUtils.isNotEmpty(infoEntities)) {
				result =  infoEntities.stream().map(BudgetProjectDetailProEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
			}
		}
		return CommonResponse.success("查询成功!", result);
	}
}
