package com.ejianc.business.budget.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 转换结果
 */
public enum ConvertResultEnum {
    已匹配(1, "完全匹配"),
    存在相似清单(2, "存在相似清单"),
    无相似清单(3, "无相似清单"),
    已替换(4, "已替换"),
    已忽略(5, "已忽略");

    private Integer code;
    private String description;
    private static Map<Integer, ConvertResultEnum> enumMap = new HashMap<>();

    ConvertResultEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(ConvertResultEnum.class).stream().collect(Collectors.toMap(ConvertResultEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ConvertResultEnum getEnumByCode(Integer code) {
        return enumMap.get(code);
    }

}

