package com.ejianc.business.budget.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailReferenProVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * 项目预算主实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface BudgetProjectProMapper extends BaseCrudMapper<BudgetProjectProEntity> {

    List<BudgetProjectDetailReferenProVO> queryDetailList(Page<BudgetProjectDetailReferenProVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper, @Param("projectId") Long projectId, @Param("costType") String costType);

    List<BudgetProjectDetailReferenProVO> queryOtherDetailList(Page<BudgetProjectDetailReferenProVO> page,@Param(Constants.WRAPPER) QueryWrapper wrapper,@Param("projectId") Long projectId,@Param("costType") String costType);

    List<BudgetProjectDetailProVO> querySubDetailList(Page<BudgetProjectDetailProVO> page,@Param(Constants.WRAPPER) QueryWrapper wrapper,@Param("projectId") Long projectId,@Param("costType") String costType);

    List<BudgetProjectDetailProVO> queryOnlySuject(Long projectId, Integer costType, Set<Long> subjectIds);

    List<BudgetProjectDetailProVO> getBudgetProjectDetailProDataAndSum(Long projectId);
}
