package com.ejianc.business.budget.service;

import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.vo.BudgetProjectVO;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 项目预算
 *
 * @author generator
 *
 */
public interface IBudgetProjectService extends IBaseService<BudgetProjectEntity> {

    CommonResponse<BudgetProjectVO> saveOrUpdate(BudgetProjectVO saveorUpdateVO);

    BudgetProjectVO queryDetail(Long id);

    CommonResponse<BudgetProjectVO> pushCost(BudgetProjectVO pushVO);

    CommonResponse<String> convertToPro(BudgetProjectVO budgetProjectVO);

    CommonResponse<String> pushToPro(Long budgetId);

    CommonResponse<Boolean> checkBeforePush(Long budgetId);

    List<BudgetSetDetailVO> querySimilar(Long budgetDetailId);
}
