package com.ejianc.business.budget.service.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.*;
import com.ejianc.business.budget.enums.BudgetTypeEnum;
import com.ejianc.business.budget.mapper.BudgetProjectDetailMapper;
import com.ejianc.business.budget.service.*;
import com.ejianc.business.budget.utils.ExcelImportUtil;
import com.ejianc.business.budget.utils.StringNameUtils;
import com.ejianc.business.budget.vo.BudgetMatchVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.business.budget.vo.ThreeCompareVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailComparatoeVo;
import com.ejianc.business.cost.bean.xml.*;
import com.ejianc.business.cost.utils.DetailListUtil;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.business.utils.HuaKangExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.business.cost.controller.YdbxController.processYdbxAsZip;

/**
 * 项目预算清单
 *
 * @author generator
 */
@Service("budgetProjectDetailService")
public class BudgetProjectDetailServiceImpl extends BaseServiceImpl<BudgetProjectDetailMapper, BudgetProjectDetailEntity> implements IBudgetProjectDetailService {

    @Autowired
    private IBudgetProjectService budgetProjectService;
    @Autowired
    private IBudgetSetService budgetSetService;
    @Autowired
    private IBudgetSetDetailService budgetSetDetailService;

    @Autowired
    private IBudgetProjectProService costService;

    @Autowired
    private DetailListUtil detailListUtil;

    @Override
    public void deleteByBudgetId(Long id) {
        QueryWrapper<BudgetProjectDetailEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("budget_id", id);
        baseMapper.delete(deleteWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<BudgetProjectDetailVO> detailVoList = new ArrayList<>();
                Map<String, String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BudgetProjectDetailVO vo = new BudgetProjectDetailVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setDetailIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex, id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第" + (i + 2) + "行序号和第" + (indexMap.get(detailIndex) + 2) + "行重复");
                    } else {
                        indexMap.put(detailIndex, i);
                    }

                    if (StringUtils.isEmpty(datas.get(1))) {// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType + "编码为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setCode(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType = warnType + "项目名称为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setName(datas.get(2));
                    }

                    vo.setProjectFeature(datas.get(3));//项目特征
                    vo.setUnit(datas.get(4));
//                    if (StringUtils.isEmpty(datas.get(4))) {//清单名称为空
//                        vo.setUnit(null);
//                        warnType =  warnType+"单位为空,";
//                        flag = true;
//                        parentWarn = true;
//                    } else {
//                        vo.setUnit(datas.get(4));
//                    }

                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setNum(null);
                        warnType = warnType + "工程量为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setNum(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType + "工程量只能为数字或小数,";
                            flag = true;
                        }
                    }

//                    if (StringUtils.isEmpty(datas.get(6))) {
//                        vo.setPrice(null);
//                        warnType = warnType+"综合单价为空,";
//                        flag = true;
//                    } else {
//                        try {
//                            vo.setPrice(new BigDecimal(datas.get(6)));
//                        } catch (Exception e) {
//                            vo.setPrice(null);
//                            warnType = warnType+"综合单价只能为数字或小数,";
//                            flag = true;
//                        }
//                    }

                    if (StringUtils.isEmpty(datas.get(7))) {// 不是强制必输
                        vo.setLaborCost(null);
                    } else {
                        try {
                            vo.setLaborCost(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            vo.setLaborCost(null);
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(8))) {// 不是强制必输
                        vo.setMaterialCost(null);
                    } else {
                        try {
                            vo.setMaterialCost(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            vo.setMaterialCost(null);
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(9))) {// 不是强制必输
                        vo.setMechanicalCost(null);
                    } else {
                        try {
                            vo.setMechanicalCost(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            vo.setMechanicalCost(null);
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(10))) {// 不是强制必输
                        vo.setOtherCost(null);
                    } else {
                        try {
                            vo.setOtherCost(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            vo.setOtherCost(null);
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(11))) {
                        vo.setMny(null);
                        warnType = warnType + "合价为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setMny(new BigDecimal(datas.get(11)));
                        } catch (Exception e) {
                            vo.setMny(null);
                            warnType = warnType + "合价只能为数字或小数,";
                            flag = true;
                        }
                    }


                    if (null == vo.getNum() || null == vo.getMny()) {
                        vo.setPrice(null);
                    } else {
                        if (vo.getNum().compareTo(BigDecimal.ZERO) == 0) {
                            vo.setPrice(null);
                        } else {
                            vo.setPrice(vo.getMny().divide(vo.getNum(), 20, BigDecimal.ROUND_HALF_EVEN));
                        }
                    }

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    if (flag) {
                        warnType = warnType.substring(0, warnType.length() - 1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    vo.setChangeType(3);//增补项
                    detailVoList.add(vo);
                }

                for (BudgetProjectDetailVO tVo : detailVoList) {
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList", allList.get(0));
                resp.put("errorList", errorList);
                resp.put("successNum", result.size() - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImportYdbx(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        ConstructionProject project = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = FileUtils.getFileExt(originalFileName, false);

            // 检查是否为.ydbx文件
            if (!"ydbx".equalsIgnoreCase(extName)) {
                return CommonResponse.error("请上传.ydbx文件");
            }
            try {
                // 直接当作zip文件处理
                project = processYdbxAsZip(mf);
                if(project == null){
                    return CommonResponse.error("文件处理失败");
                }

            } catch (Exception e) {
                return CommonResponse.error("文件处理失败：" + e.getMessage());
            }
        }
        JSONObject resp = new JSONObject();
        if (project == null) {
            return CommonResponse.error("文件处理失败！");
        } else {
            if(project.getProjectfee() == null){
                return CommonResponse.error("文件不存在projectFee");
            }
            List<SectionalWorks> sectionalWorks = project.getProjectfee().getSectionalWorks();
            if(ListUtil.isEmpty(sectionalWorks)){
                return CommonResponse.error("文件不存在SectionalWorks");
            }
            List<BudgetProjectDetailVO> detailVoList = new ArrayList<>();
            Map<String, String> tidMap = new HashMap<>();
            for (int i = 0; i < sectionalWorks.size(); i++) {
                SectionalWorks works = sectionalWorks.get(i);
                BudgetProjectDetailVO vo = new BudgetProjectDetailVO();
                String warnType = "";
                String detailIndex = (i+1)+"";
                System.out.println(detailIndex);
                vo.setDetailIndex(detailIndex);
                //维护父子关系
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                String[] split = detailIndex.split("[-/.]");
                vo.setTid(id);
                tidMap.put(detailIndex, id);
                if (split.length > 1) {
                    vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                }
                vo.setName(works.getName());
                vo.setImportFlag(true);// true=可以导入，false=不可导入
                vo.setParentWarn(false);
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setChangeType(3);//增补项
                detailVoList.add(vo);
                /** 处理 List<UnitWorks> unitWorks */
                List<UnitWorks> unitWorks = works.getUnitWorks();
                if(ListUtil.isNotEmpty(unitWorks)){
                    String parentIndex = vo.getDetailIndex();
                    for (int i1 = 0; i1 < unitWorks.size(); i1++) {
                        BudgetProjectDetailVO vo1 = new BudgetProjectDetailVO();
                        UnitWorks unitWorks1 = unitWorks.get(i1);
                        detailIndex = parentIndex+"."+(i1+1);
                        vo1.setDetailIndex(detailIndex);
                        System.out.println(detailIndex);
                        id = UUID.randomUUID().toString().replaceAll("-", "");
                        split = detailIndex.split("[-/.]");
                        vo1.setTid(id);
                        tidMap.put(detailIndex, id);
                        if (split.length > 1) {
                            vo1.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }

                        vo1.setName(unitWorks1.getName());

                        vo1.setImportFlag(true);// true=可以导入，false=不可导入
                        vo1.setParentWarn(false);
                        vo1.setRowState("add");
                        vo1.setShadowId(vo1.getTid());
                        vo1.setChangeType(3);//增补项
                        detailVoList.add(vo1);
                        /** 处理List<SummaryItemInfo> summaryItemInfos */
                        List<SummaryItemInfo> summaryItemInfos = unitWorks1.getSummaryItemInfos();
                        if(ListUtil.isNotEmpty(summaryItemInfos)){
                            String parentIndex2 = vo1.getDetailIndex();
                            for (int i2 = 0; i2 < summaryItemInfos.size(); i2++) {
                                SummaryItemInfo itemInfo = summaryItemInfos.get(i2);
                                if(!itemInfo.getOrdCode().contains(".")){
                                    BudgetProjectDetailVO vo2 = new BudgetProjectDetailVO();
                                    warnType = "";
                                    detailIndex = parentIndex2+"."+("6".equals(itemInfo.getOrdCode())?"5":itemInfo.getOrdCode());
                                    System.out.println(detailIndex);
                                    vo2.setDetailIndex(detailIndex);
                                    id = UUID.randomUUID().toString().replaceAll("-", "");
                                    split = detailIndex.split("[-/.]");
                                    vo2.setTid(id);
                                    tidMap.put(detailIndex, id);
                                    if (split.length > 1) {
                                        vo2.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                    }
                                    vo2.setCode(itemInfo.getOrdCode());
                                    vo2.setName(itemInfo.getName());

                                    vo2.setImportFlag(true);// true=可以导入，false=不可导入
                                    vo2.setParentWarn(false);
                                    vo2.setRowState("add");
                                    vo2.setShadowId(vo2.getTid());
                                    vo2.setChangeType(3);//增补项

                                    if("1".equals(itemInfo.getOrdCode())){
                                        /** 处理 List<DivisionalWorkInfo> billTables */
                                        List<DivisionalWorkInfo> billTables = itemInfo.getBillTables();
                                        if(ListUtil.isNotEmpty(billTables)){
                                            String parentIndex3 = vo2.getDetailIndex();
                                            for (int i3 = 0; i3 < billTables.size(); i3++) {
                                                DivisionalWorkInfo billTable = billTables.get(i3);
                                                BudgetProjectDetailVO vo3 = new BudgetProjectDetailVO();
                                                detailIndex = parentIndex3+"."+(i3+1);
                                                System.out.println(detailIndex);
                                                vo3.setDetailIndex(detailIndex);
                                                id = UUID.randomUUID().toString().replaceAll("-", "");
                                                split = detailIndex.split("[-/.]");
                                                vo3.setTid(id);
                                                tidMap.put(detailIndex, id);
                                                if (split.length > 1) {
                                                    vo3.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                                }
                                                vo3.setName(billTable.getName());

                                                vo3.setImportFlag(true);// true=可以导入，false=不可导入
                                                vo3.setParentWarn(false);
                                                vo3.setRowState("add");
                                                vo3.setShadowId(vo3.getTid());
                                                vo3.setChangeType(3);//增补项
                                                detailVoList.add(vo3);
                                                /** 处理 List<DivisionalWorkInfo> billTables */
                                                List<ListProjectInfo> listProjects = billTable.getListProjects();
                                                if(ListUtil.isNotEmpty(listProjects)){
                                                    String parentIndex4 = vo3.getDetailIndex();
                                                    for (int i4 = 0; i4 < listProjects.size(); i4++) {
                                                        ListProjectInfo listProjectInfo = listProjects.get(i4);
                                                        BudgetProjectDetailVO vo4 = new BudgetProjectDetailVO();
                                                        detailIndex = parentIndex4+"."+(i4+1);
                                                        System.out.println(detailIndex);
                                                        vo4.setDetailIndex(detailIndex);
                                                        id = UUID.randomUUID().toString().replaceAll("-", "");
                                                        split = detailIndex.split("[-/.]");
                                                        vo4.setTid(id);
                                                        tidMap.put(detailIndex, id);
                                                        if (split.length > 1) {
                                                            vo4.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                                        }
                                                        vo4.setCode(listProjectInfo.getCode());
                                                        vo4.setName(listProjectInfo.getName());
                                                        vo4.setUnit(listProjectInfo.getUnit());
                                                        vo4.setNum(new java.math.BigDecimal(listProjectInfo.getQuantity()));
                                                        vo4.setPrice(new java.math.BigDecimal(listProjectInfo.getPrice()));
                                                        vo4.setMny(new java.math.BigDecimal(listProjectInfo.getTotal()));
                                                        vo4.setLeafFlag(true);
                                                        vo4.setImportFlag(true);// true=可以导入，false=不可导入
                                                        vo4.setRowState("add");
                                                        vo4.setShadowId(vo4.getTid());
                                                        vo4.setChangeType(3);//增补项
                                                        detailVoList.add(vo4);
                                                    }
                                                }else {
                                                    vo3.setMny(new java.math.BigDecimal(0));
                                                    vo3.setNum(new java.math.BigDecimal(0));
                                                    vo3.setPrice(new java.math.BigDecimal(0));
                                                    vo3.setCode("0");
                                                }
                                            }
                                        }else {
                                            List<ListProjectInfo> billTableList = itemInfo.getBillTableList();
                                            if(ListUtil.isNotEmpty(billTableList)){
                                                String parentIndex4 = vo2.getDetailIndex();
                                                for (int i4 = 0; i4 < billTableList.size(); i4++) {
                                                    ListProjectInfo listProjectInfo = billTableList.get(i4);
                                                    BudgetProjectDetailVO vo4 = new BudgetProjectDetailVO();
                                                    detailIndex = parentIndex4+"."+(i4+1);
                                                    System.out.println(detailIndex);
                                                    vo4.setDetailIndex(detailIndex);
                                                    id = UUID.randomUUID().toString().replaceAll("-", "");
                                                    split = detailIndex.split("[-/.]");
                                                    vo4.setTid(id);
                                                    tidMap.put(detailIndex, id);
                                                    if (split.length > 1) {
                                                        vo4.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                                    }
                                                    vo4.setCode(listProjectInfo.getCode());
                                                    vo4.setName(listProjectInfo.getName());
                                                    vo4.setUnit(listProjectInfo.getUnit());
                                                    vo4.setNum(new java.math.BigDecimal(listProjectInfo.getQuantity()));
                                                    vo4.setPrice(new java.math.BigDecimal(listProjectInfo.getPrice()));
                                                    vo4.setMny(new java.math.BigDecimal(listProjectInfo.getTotal()));
                                                    vo4.setLeafFlag(true);
                                                    vo4.setImportFlag(true);// true=可以导入，false=不可导入
                                                    vo4.setRowState("add");
                                                    vo4.setShadowId(vo4.getTid());
                                                    vo4.setChangeType(3);//增补项
                                                    detailVoList.add(vo4);
                                                }
                                            }
                                        }
                                    }else
                                    if("2".equals(itemInfo.getOrdCode())){
                                        List<ListProjectInfo> totals = itemInfo.getPreliminariesByTotal();
                                        List<ListProjectInfo> prices = itemInfo.getPreliminariesByPrice();
                                        if(ListUtil.isNotEmpty(totals)){
                                            BudgetProjectDetailVO vo3 = new BudgetProjectDetailVO();
                                            detailIndex = vo2.getDetailIndex()+".1";
                                            System.out.println(detailIndex);
                                            vo3.setDetailIndex(detailIndex);
                                            vo3.setName("总价措施项目");
                                            id = UUID.randomUUID().toString().replaceAll("-", "");
                                            split = detailIndex.split("[-/.]");
                                            vo3.setTid(id);
                                            tidMap.put(detailIndex, id);
                                            if (split.length > 1) {
                                                vo3.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                            }
                                            vo3.setShadowId(vo3.getTid());
                                            vo3.setImportFlag(true);// true=可以导入，false=不可导入
                                            vo3.setParentWarn(false);
                                            vo3.setRowState("add");
                                            vo3.setChangeType(3);//增补项
                                            detailVoList.add(vo3);
                                            for (int i3 = 0; i3 < totals.size(); i3++) {
                                                ListProjectInfo listProjectInfo = totals.get(i3);
                                                BudgetProjectDetailVO vo4 = new BudgetProjectDetailVO();
                                                detailIndex = vo3.getDetailIndex()+"."+(i3+1);
                                                System.out.println(detailIndex);
                                                vo4.setDetailIndex(detailIndex);
                                                id = UUID.randomUUID().toString().replaceAll("-", "");
                                                split = detailIndex.split("[-/.]");
                                                vo4.setTid(id);
                                                tidMap.put(detailIndex, id);
                                                if (split.length > 1) {
                                                    vo4.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                                }
                                                vo4.setCode(listProjectInfo.getCode());
                                                vo4.setName(listProjectInfo.getName());
                                                if(ListUtil.isEmpty(listProjectInfo.getInnerListProjectInfos())){
                                                    vo4.setUnit(listProjectInfo.getUnit());
                                                    vo4.setNum(new java.math.BigDecimal(listProjectInfo.getQuantity()));
                                                    if(StringUtils.isNotEmpty(listProjectInfo.getPrice())){
                                                        vo4.setPrice(new java.math.BigDecimal(listProjectInfo.getPrice()));
                                                    }
                                                    vo4.setMny(new java.math.BigDecimal(listProjectInfo.getTotal()));
                                                    vo4.setLeafFlag(true);
                                                }else {
                                                    List<ListProjectInfo> innerListProjectInfos = listProjectInfo.getInnerListProjectInfos();
                                                    for (int i4 = 0; i4 < innerListProjectInfos.size(); i4++) {
                                                        detailIndex = vo4.getDetailIndex()+"."+(i4+1);
                                                        System.out.println(detailIndex);
                                                        ListProjectInfo info = innerListProjectInfos.get(i4);
                                                        BudgetProjectDetailVO vo5 = new BudgetProjectDetailVO();
                                                        vo5.setDetailIndex(detailIndex);
                                                        id = UUID.randomUUID().toString().replaceAll("-", "");
                                                        split = detailIndex.split("[-/.]");
                                                        vo5.setTid(id);
                                                        tidMap.put(detailIndex, id);
                                                        if (split.length > 1) {
                                                            vo5.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                                        }
                                                        vo5.setCode(info.getCode());
                                                        vo5.setName(info.getName());
                                                        vo5.setUnit(info.getUnit());
                                                        vo5.setNum(new java.math.BigDecimal(info.getQuantity()));
                                                        if(StringUtils.isNotEmpty(info.getPrice())){
                                                            vo5.setPrice(new java.math.BigDecimal(info.getPrice()));
                                                        }
                                                        vo5.setMny(new java.math.BigDecimal(info.getTotal()));
                                                        vo5.setLeafFlag(true);
                                                        vo5.setImportFlag(true);// true=可以导入，false=不可导入
                                                        vo5.setRowState("add");
                                                        vo5.setShadowId(vo5.getTid());
                                                        vo5.setChangeType(3);//增补项
                                                        detailVoList.add(vo5);
                                                    }
                                                }
                                                vo4.setImportFlag(true);// true=可以导入，false=不可导入
                                                vo4.setRowState("add");
                                                vo4.setShadowId(vo4.getTid());
                                                vo4.setChangeType(3);//增补项
                                                detailVoList.add(vo4);
                                            }
                                        }
                                        if(ListUtil.isNotEmpty(prices)){
                                            BudgetProjectDetailVO vo3 = new BudgetProjectDetailVO();
                                            detailIndex = vo2.getDetailIndex()+".2";
                                            vo3.setDetailIndex(detailIndex);
                                            System.out.println(detailIndex);
                                            vo3.setName("单价措施项目");
                                            id = UUID.randomUUID().toString().replaceAll("-", "");
                                            split = vo3.getDetailIndex().split("[-/.]");
                                            vo3.setTid(id);
                                            tidMap.put(vo3.getDetailIndex(), id);
                                            if (split.length > 1) {
                                                vo3.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                            }
                                            vo3.setImportFlag(true);// true=可以导入，false=不可导入
                                            vo3.setParentWarn(false);
                                            vo3.setRowState("add");
                                            vo3.setShadowId(vo3.getTid());
                                            vo3.setChangeType(3);//增补项
                                            detailVoList.add(vo3);
                                            for (int i3 = 0; i3 < prices.size(); i3++) {
                                                ListProjectInfo listProjectInfo = prices.get(i3);
                                                BudgetProjectDetailVO vo4 = new BudgetProjectDetailVO();
                                                detailIndex = vo3.getDetailIndex()+"."+(i3+1);
                                                System.out.println(detailIndex);
                                                vo4.setDetailIndex(detailIndex);
                                                id = UUID.randomUUID().toString().replaceAll("-", "");
                                                split = detailIndex.split("[-/.]");
                                                vo4.setTid(id);
                                                tidMap.put(detailIndex, id);
                                                if (split.length > 1) {
                                                    vo4.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                                }
                                                vo4.setCode(listProjectInfo.getCode());
                                                vo4.setName(listProjectInfo.getName());
                                                vo4.setUnit(listProjectInfo.getUnit());
                                                vo4.setNum(new java.math.BigDecimal(listProjectInfo.getQuantity()));
                                                vo4.setPrice(new java.math.BigDecimal(listProjectInfo.getPrice()));
                                                vo4.setMny(new java.math.BigDecimal(listProjectInfo.getTotal()));
                                                vo4.setLeafFlag(true);
                                                vo4.setImportFlag(true);// true=可以导入，false=不可导入
                                                vo4.setRowState("add");
                                                vo4.setShadowId(vo4.getTid());
                                                vo4.setChangeType(3);//增补项
                                                detailVoList.add(vo4);
                                            }
                                        }
                                    }else
                                    if("3".equals(itemInfo.getOrdCode())){
                                        List<ExtraItem> extraTables = itemInfo.getExtraTables();
                                        if(ListUtil.isNotEmpty(extraTables)){
                                            for (int i3 = 0; i3 < extraTables.size(); i3++) {
                                                ExtraItem extraItem = extraTables.get(i3);
                                                if(!extraItem.getCode().contains(".")){
                                                    BudgetProjectDetailVO vo3 = new BudgetProjectDetailVO();
                                                    detailIndex = vo2.getDetailIndex()+"."+extraItem.getCode();
                                                    System.out.println(detailIndex);
                                                    vo3.setDetailIndex(detailIndex);
                                                    id = UUID.randomUUID().toString().replaceAll("-", "");
                                                    split = detailIndex.split("[-/.]");
                                                    vo3.setTid(id);
                                                    tidMap.put(detailIndex, id);
                                                    if (split.length > 1) {
                                                        vo3.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                                    }
                                                    vo3.setCode(extraItem.getCode());
                                                    vo3.setName(extraItem.getName());
                                                    vo3.setUnit(extraItem.getUnit());
                                                    vo3.setNum(new BigDecimal(extraItem.getQuantity()));
                                                    vo3.setPrice(new BigDecimal(extraItem.getPrice()));
                                                    vo3.setMny(new BigDecimal(extraItem.getTotal()));
                                                    vo3.setLeafFlag(true);
                                                    vo3.setImportFlag(true);// true=可以导入，false=不可导入
                                                    vo3.setParentWarn(false);
                                                    vo3.setRowState("add");
                                                    vo3.setShadowId(vo2.getTid());
                                                    vo3.setChangeType(3);//增补项
                                                    detailVoList.add(vo3);
                                                }
                                            }
                                        }
                                    }else
                                    if("4".equals(itemInfo.getOrdCode())){
                                        StatutoryFeesItem statutoryFeesItem = itemInfo.getStatutoryFeesItem();
                                        if(statutoryFeesItem!=null){
                                            BudgetProjectDetailVO vo4 = new BudgetProjectDetailVO();
                                            detailIndex = vo2.getDetailIndex()+".1";
                                            vo4.setDetailIndex(detailIndex);
                                            System.out.println(detailIndex);
                                            vo4.setName(statutoryFeesItem.getName());
                                            vo4.setMny(new BigDecimal(statutoryFeesItem.getTotal()));
                                            vo4.setLeafFlag(true);
                                            vo4.setImportFlag(true);// true=可以导入，false=不可导入
                                            vo4.setParentWarn(false);
                                            vo4.setCode(detailIndex);
                                            vo4.setPrice(new BigDecimal(statutoryFeesItem.getTotal()));
                                            vo4.setNum(new BigDecimal(1));
                                            id = UUID.randomUUID().toString().replaceAll("-", "");
                                            split = vo4.getDetailIndex().split("[-/.]");
                                            vo4.setTid(id);
                                            tidMap.put(vo4.getDetailIndex(), id);
                                            if (split.length > 1) {
                                                vo4.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                            }
                                            vo4.setRowState("add");
                                            vo4.setShadowId(vo4.getTid());
                                            vo4.setChangeType(3);//增补项
                                            detailVoList.add(vo4);
                                        }
                                    }else
                                    if("6".equals(itemInfo.getOrdCode())){
                                        TaxItem taxItem = itemInfo.getTaxItem();
                                        if(taxItem!=null){
                                            BudgetProjectDetailVO vo4 = new BudgetProjectDetailVO();
                                            detailIndex = vo2.getDetailIndex()+".1";
                                            vo4.setDetailIndex(detailIndex);
                                            System.out.println(detailIndex);
                                            vo4.setName(taxItem.getName());
                                            vo4.setMny(new BigDecimal(taxItem.getTotal()));
                                            vo4.setCode(detailIndex);
                                            vo4.setPrice(new BigDecimal(taxItem.getTotal()));
                                            vo4.setNum(new BigDecimal(1));
                                            vo4.setLeafFlag(true);
                                            vo4.setProjectFeature(taxItem.getRate()+"%");
                                            id = UUID.randomUUID().toString().replaceAll("-", "");
                                            split = vo4.getDetailIndex().split("[-/.]");
                                            vo4.setTid(id);
                                            tidMap.put(vo4.getDetailIndex(), id);
                                            if (split.length > 1) {
                                                vo4.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                            }
                                            vo4.setRowState("add");
                                            vo4.setShadowId(vo4.getTid());
                                            vo4.setChangeType(3);//增补项
                                            vo4.setLeafFlag(true);
                                            vo4.setImportFlag(true);// true=可以导入，false=不可导入
                                            vo4.setParentWarn(false);
                                            detailVoList.add(vo4);
                                        }
                                    }else {
                                        continue;
                                    }
                                    detailVoList.add(vo2);
                                }
                            }
                        }
                    }
                }
            }

            for (BudgetProjectDetailVO tVo : detailVoList) {
                tVo.setTpid(tidMap.get(tVo.getTpid()));
            }
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            List<Map<String, Object>> falseList = new ArrayList<>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
            resp.put("successList", allList.get(0));
            resp.put("errorList", errorList);
            resp.put("successNum", sectionalWorks.size() - errorList.size());
            resp.put("errorNum", errorList.size());
            return CommonResponse.success(resp);
        }
    }

    //清单参照
    @Override
    public List<BudgetProjectDetailVO> detailRef(Long projectId) {
        // 根据项目获取主表主键
        LambdaQueryWrapper<BudgetProjectEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetProjectEntity::getProjectId, projectId);
        queryWrapper.and(wrapper -> wrapper.eq(BudgetProjectEntity::getBillState, 1).or().eq(BudgetProjectEntity::getBillState, 3));
        BudgetProjectEntity entity = budgetProjectService.getOne(queryWrapper);
        // 根据主表主键查询子表
        List<BudgetProjectDetailVO> detailList = new ArrayList<>();
        if (entity != null && entity.getId() != null) {
            LambdaQueryWrapper<BudgetProjectDetailEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(BudgetProjectDetailEntity::getBudgetId, entity.getId());
            wrapper.ne(BudgetProjectDetailEntity::getChangeType, 5);//中止不显示
            wrapper.orderBy(true, true, BudgetProjectDetailEntity::getDetailIndex);
            List<BudgetProjectDetailEntity> entityList = super.list(wrapper);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (BudgetProjectDetailEntity i : entityList) {
                    i.setTid(i.getId().toString());
                    i.setTpid(i.getParentId() != null && i.getParentId() > 0 ? i.getParentId().toString() : "");
                }
            }
            detailList = BeanMapper.mapList(entityList, BudgetProjectDetailVO.class);
            //实现排序
            Collections.sort(detailList, new BudgetDetailComparatoeVo());
        }
        return TreeNodeBUtil.buildTree(detailList);
    }

    @Override
    public CommonResponse<JSONObject> excelImportHk(HttpServletRequest request, HttpServletResponse response) {
        Integer projNameLine = Integer.valueOf(request.getParameter("projNameLine"));
        Integer beginLine = Integer.valueOf(request.getParameter("beginLine"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = HuaKangExcelReader.readExcel(mf, projNameLine, beginLine);
            if (result != null && result.size() > 0) {
                int engineeringNameIndex = 0;

                int nameIndex = 0;

                int itemIndex = 0;

                String engineeringtpid = "";

                String tpid = "";

                //筛选重复序号
                List<BudgetProjectDetailVO> detailVoList = new LinkedList<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BudgetProjectDetailVO vo = new BudgetProjectDetailVO();
                    boolean flag = false;
                    boolean parentWarn = false;

                    vo.setSheetName(datas.get(0));
                    String detailIndex = (StringUtils.isNotBlank(datas.get(1)) && datas.get(1).contains("."))  ? null : datas.get(1) ;
                    String code = datas.get(2);
                    String name = datas.get(3);
                    if (StringUtils.isNotBlank(name) && ("分部小计".equals(name) || "本页小计".equals(name) || "合计".equals(name))) {
                        continue;
                    }
                    if (StringUtils.isBlank(code) || StringUtils.isBlank(detailIndex)) {
                        if (StringUtils.isNotBlank(detailIndex)) {
                            // 工程名称
                            if (detailIndex.contains("工程名称")) {
                                String engineeringName = detailIndex.replaceAll("工程名称：", "").trim();
                                engineeringNameIndex++;
                                vo.setDetailIndex(String.valueOf(engineeringNameIndex));
                                vo.setName(engineeringName);
                                engineeringtpid = vo.getDetailIndex();
                                vo.setTid(vo.getDetailIndex());
                                nameIndex = 0;
                                vo.setImportFlag(true);// true=可以导入，false=不可导入
                                vo.setParentWarn(false);
                                vo.setRowState("add");
                                vo.setShadowId(vo.getTid());
                                String key = vo.getCode() + vo.getName() + vo.getUnit();
                                vo.setKey(key);
                                detailVoList.add(vo);
                                continue;
                            }
                            // 标题
                            if (StringUtils.isBlank(name)) {
                                continue;
                            }
                        } else {
                            // 序号为空，name不为空则是项目名称
                            if (StringUtils.isNotBlank(name) && (!"分部小计".equals(name) && !"本页小计".equals(name) && !"合计".equals(name))) {
                                BudgetProjectDetailVO lastVO = detailVoList.get(detailVoList.size() - 1);
                                if (lastVO.getDetailIndex().contains(".")) {
                                    if(!StringUtils.isBlank(lastVO.getCode())){
                                        String lastDetailIndex = lastVO.getDetailIndex().substring(0, lastVO.getDetailIndex().lastIndexOf("."));
                                        String parentDetailIndex = lastDetailIndex.substring(0, lastDetailIndex.lastIndexOf("."));
                                        Integer index = Integer.valueOf(lastDetailIndex.substring(lastDetailIndex.lastIndexOf(".") + 1));
                                        vo.setDetailIndex(parentDetailIndex + "." + (index + 1));
                                        vo.setTpid(parentDetailIndex);
                                        vo.setTid(vo.getDetailIndex());
                                    }else {
                                        vo.setDetailIndex(lastVO.getDetailIndex() + ".1");
                                        vo.setTpid(tpid);
                                        vo.setTid(vo.getDetailIndex());
                                    }
                                } else {
                                    nameIndex++;
                                    vo.setDetailIndex(engineeringNameIndex + "." + nameIndex);
                                    vo.setCode("单价措施费".equals(name) ? code : null);
                                    vo.setTpid(engineeringtpid);
                                    vo.setTid(vo.getDetailIndex());
                                }
                                vo.setName(name);
                                vo.setParentId(Long.valueOf(111));//随便给个父级id，前端合计时parentId必须有值
                                tpid = vo.getDetailIndex();
                                itemIndex = 0;
                                vo.setImportFlag(true);// true=可以导入，false=不可导入
                                vo.setParentWarn(false);
                                vo.setRowState("add");
                                vo.setShadowId(vo.getTid());
                                String key = vo.getCode() + vo.getName() + vo.getUnit();
                                vo.setKey(key);
                                detailVoList.add(vo);
                                continue;
                            }
                        }
                    } else {
                        itemIndex++;
                        String warnType = "";
                        String parentId = StringUtils.isBlank(tpid) ? engineeringtpid : tpid;
                        vo.setDetailIndex(parentId + "." + itemIndex);
                        vo.setTid(vo.getDetailIndex());
                        vo.setTpid(parentId);
                        vo.setParentId(Long.valueOf(111));//随便给个父级id，前端合计时parentId必须有值

                        if (StringUtils.isBlank(code)) {// 清单编码为空
                            vo.setCode(null);
                            warnType = warnType + "项目编码为空,";
                            flag = true;
                            parentWarn = true;
                        } else {
                            vo.setCode(code);
                        }

                        if (StringUtils.isBlank(name)) {//清单名称为空
                            vo.setName(null);
                            warnType = warnType + "项目名称为空,";
                            flag = true;
                            parentWarn = true;
                        } else {
                            vo.setName(name.replace(" ", ""));
                        }

                        vo.setProjectFeature(datas.get(4));//项目特征
                        vo.setUnit(datas.get(5));

                        if (StringUtils.isBlank(datas.get(6))) {
                            vo.setNum(null);
                            warnType = warnType + "工程量为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setNum(new BigDecimal(datas.get(6)));
                            } catch (Exception e) {
                                vo.setNum(null);
                                warnType = warnType + "工程量只能为数字或小数,";
                                flag = true;
                            }
                        }

                        if (StringUtils.isBlank(datas.get(7))) {
                            vo.setPrice(null);
                            warnType = warnType + "综合单价为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setPrice(new BigDecimal(datas.get(7)));
                            } catch (Exception e) {
                                vo.setPrice(null);
                                warnType = warnType + "综合单价只能为数字或小数,";
                                flag = true;
                            }
                        }


                        if (StringUtils.isBlank(datas.get(8))) {
                            vo.setMny(null);
                            warnType = warnType + "合价为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setMny(new BigDecimal(datas.get(8)));
                            } catch (Exception e) {
                                vo.setMny(null);
                                warnType = warnType + "合价只能为数字或小数,";
                                flag = true;
                            }
                        }


                        if (null == vo.getNum() || null == vo.getMny()) {
                            vo.setPrice(null);
                        } else {
                            if (vo.getNum().compareTo(BigDecimal.ZERO) == 0) {
                                vo.setPrice(null);
                            } else {
                                vo.setPrice(vo.getMny().divide(vo.getNum(), 20, BigDecimal.ROUND_HALF_EVEN));
                                vo.setPrice(ComputeUtil.scale(ComputeUtil.safeDiv(vo.getMny(), vo.getNum()), 4));
                            }
                        }

                        vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                        vo.setParentWarn(parentWarn);
                        if (flag) {
                            warnType = warnType.substring(0, warnType.length() - 1);
                        }
                        vo.setWarnType(warnType);
                        vo.setRowState("add");
                        vo.setShadowId(vo.getTid());
                        vo.setChangeType(3);//增补项
                        detailVoList.add(vo);
                    }
                }

                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList", allList.get(0));
                resp.put("errorList", errorList);
                resp.put("successNum", detailVoList.size() - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public List<BudgetMatchVO> queryMatchList(Page<BudgetMatchVO> page, QueryWrapper wrapper, Long budgetId, Long setDetailId) {
        return baseMapper.queryMatchList(page, wrapper, budgetId, setDetailId);
    }


    @Override
    public List<Map<String, Object>> queryThreeCompare(Long projectId) {
        List<ThreeCompareVO> result = new LinkedList<>();
        LambdaQueryWrapper<BudgetProjectEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BudgetProjectEntity::getProjectId, projectId);
        queryWrapper.in(BudgetProjectEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<BudgetProjectEntity> entities = budgetProjectService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(entities)) {
            Map<String, ThreeCompareVO> baseCodeMap = new LinkedHashMap<>();
            Map<Integer, List<BudgetProjectEntity>> map = entities.stream().collect(Collectors.groupingBy(BudgetProjectEntity::getBudgetType));

            List<BudgetProjectEntity> jsList = map.get(BudgetTypeEnum.结算预算.getCode());
            if (CollectionUtils.isNotEmpty(jsList)) {
                baseCodeMap = dealReportData(jsList, baseCodeMap, BudgetTypeEnum.结算预算.getCode());
            }

            List<BudgetProjectEntity> sgtList = map.get(BudgetTypeEnum.施工图预算.getCode());
            if (CollectionUtils.isNotEmpty(sgtList)) {
                baseCodeMap = dealReportData(sgtList, baseCodeMap, BudgetTypeEnum.施工图预算.getCode());
            }

            List<BudgetProjectEntity> zbList = map.get(BudgetTypeEnum.中标预算.getCode());
            if (CollectionUtils.isNotEmpty(zbList)) {
                baseCodeMap = dealReportData(zbList, baseCodeMap, BudgetTypeEnum.中标预算.getCode());
            }

            if (!baseCodeMap.isEmpty()) {
                ThreeCompareVO compareVO = new ThreeCompareVO();
                compareVO.setId(IdWorker.getId());
                compareVO.setName("合同内");
                result.add(compareVO);
                for (ThreeCompareVO threeVO : baseCodeMap.values()) {
                    if (null == threeVO.getParentId()) {
                        threeVO.setParentId(compareVO.getId());
                    }
                    result.add(threeVO);
                }
            }

            baseCodeMap = new LinkedHashMap<>();

            List<BudgetProjectEntity> qzList = map.get(BudgetTypeEnum.签证.getCode());
            if (CollectionUtils.isNotEmpty(qzList)) {
                baseCodeMap = dealReportData(qzList, baseCodeMap, BudgetTypeEnum.结算预算.getCode());
            }

            List<BudgetProjectEntity> qtList = map.get(BudgetTypeEnum.其他.getCode());
            if (CollectionUtils.isNotEmpty(qtList)) {
                baseCodeMap = dealReportData(qtList, baseCodeMap, BudgetTypeEnum.结算预算.getCode());
            }

            if (!baseCodeMap.isEmpty()) {
                ThreeCompareVO compareVO = new ThreeCompareVO();
                compareVO.setId(IdWorker.getId());
                compareVO.setName("合同外");
                result.add(compareVO);
                for (ThreeCompareVO threeVO : baseCodeMap.values()) {
                    if (null == threeVO.getParentId()) {
                        threeVO.setParentId(compareVO.getId());
                    }
                    result.add(threeVO);
                }
            }
        }

        if (CollectionUtils.isNotEmpty(result)) {

            generateSequences(result);

            List<Map> resultMapList = BeanMapper.mapList(result, Map.class);
            List<Map<String, Object>> treeData = TreeNodeBUtil.createTreeData(resultMapList);

            gatherMny(null, treeData);

            return treeData.stream().sorted(BudgetProjectDetailServiceImpl::compareDetailIndex).collect(Collectors.toList());
        }
        return null;
    }

    private Map<String, ThreeCompareVO> dealReportData(List<BudgetProjectEntity> settles, Map<String, ThreeCompareVO> baseCodeMap, Integer bugetType) {
        for (int i = 0; i < settles.size(); i++) {
            List<BudgetProjectDetailEntity> detailEntities = budgetProjectService.selectById(settles.get(i).getId()).getCheckList();
            if (CollectionUtils.isNotEmpty(detailEntities)) {
                detailEntities = detailEntities.stream().sorted(BudgetProjectDetailServiceImpl::compareDetailIndex).collect(Collectors.toList());
                if (baseCodeMap.isEmpty()) {
                    for (BudgetProjectDetailEntity detailEntity : detailEntities) {
                        ThreeCompareVO compareVO = BeanMapper.map(detailEntity, ThreeCompareVO.class);
                        if (bugetType.equals(BudgetTypeEnum.结算预算.getCode())) {
                            compareVO.setJsNum(detailEntity.getNum());
                            compareVO.setJsPrice(detailEntity.getPrice());
                            compareVO.setJsMny(detailEntity.getMny());
                        } else if (bugetType.equals(BudgetTypeEnum.施工图预算.getCode())) {
                            compareVO.setSgtNum(detailEntity.getNum());
                            compareVO.setSgtPrice(detailEntity.getPrice());
                            compareVO.setSgtMny(detailEntity.getMny());
                        } else if (bugetType.equals(BudgetTypeEnum.中标预算.getCode())) {
                            compareVO.setZbNum(detailEntity.getNum());
                            compareVO.setZbPrice(detailEntity.getPrice());
                            compareVO.setZbMny(detailEntity.getMny());
                        }
                        baseCodeMap.put(createKey(compareVO), compareVO);
                    }
                } else {
                    List<ThreeCompareVO> tmp = new LinkedList<>();
                    for (BudgetProjectDetailEntity detailEntity : detailEntities) {
                        ThreeCompareVO compareVO = BeanMapper.map(detailEntity, ThreeCompareVO.class);
                        if (bugetType.equals(BudgetTypeEnum.结算预算.getCode())) {
                            compareVO.setJsNum(detailEntity.getNum());
                            compareVO.setJsPrice(detailEntity.getPrice());
                            compareVO.setJsMny(detailEntity.getMny());
                        } else if (bugetType.equals(BudgetTypeEnum.施工图预算.getCode())) {
                            compareVO.setSgtNum(detailEntity.getNum());
                            compareVO.setSgtPrice(detailEntity.getPrice());
                            compareVO.setSgtMny(detailEntity.getMny());
                        } else if (bugetType.equals(BudgetTypeEnum.中标预算.getCode())) {
                            compareVO.setZbNum(detailEntity.getNum());
                            compareVO.setZbPrice(detailEntity.getPrice());
                            compareVO.setZbMny(detailEntity.getMny());
                        }
                        tmp.add(compareVO);
                    }


                    Map<Long, ThreeCompareVO> cpreIdMap = new LinkedHashMap<>();
                    Map<String, ThreeCompareVO> cpreCodeMap = new LinkedHashMap<>();
                    for (ThreeCompareVO compareVO : tmp) {
                        cpreIdMap.put(compareVO.getId(), compareVO);
                        cpreCodeMap.put(createKey(compareVO), compareVO);
                    }

                    for (ThreeCompareVO compareVO : tmp) {
                        String key = createKey(compareVO);
                        if (compareVO.getLeafFlag()) {
                            String innerCode = compareVO.getInnerCode();
                            //循环整个枝儿
                            for (String code : innerCode.split("\\|")) {
                                //非末级且不包含，放入map
                                if (!key.equals(code) && !baseCodeMap.containsKey(code)) {
                                    //非根节点，重新设置父Id:本集合内找到父级，然后根据父级key去基准map找到对应行
                                    ThreeCompareVO threeCompareVO = cpreCodeMap.get(code);
                                    if (null != threeCompareVO.getParentId()) {
                                        threeCompareVO.setParentId(baseCodeMap.get(createKey(cpreIdMap.get(threeCompareVO.getParentId()))).getId());
                                    }
                                    baseCodeMap.put(code, threeCompareVO);
                                } else if (key.equals(code)) {
                                    if (!baseCodeMap.containsKey(code)) {
                                        compareVO.setParentId(baseCodeMap.get(createKey(cpreIdMap.get(compareVO.getParentId()))).getId());
                                        baseCodeMap.put(key, compareVO);
                                    } else {
                                        ThreeCompareVO baseVO = baseCodeMap.get(key);
                                        if (bugetType.equals(BudgetTypeEnum.结算预算.getCode())) {
                                            baseVO.setJsNum(ComputeUtil.safeAdd(baseVO.getJsNum(), compareVO.getJsNum()));
                                            baseVO.setJsMny(ComputeUtil.safeAdd(baseVO.getJsMny(), compareVO.getJsMny()));
                                            baseVO.setJsPrice(ComputeUtil.safeDiv(baseVO.getJsMny(), baseVO.getJsNum()));
                                        } else if (bugetType.equals(BudgetTypeEnum.施工图预算.getCode())) {
                                            baseVO.setSgtNum(ComputeUtil.safeAdd(baseVO.getSgtNum(), compareVO.getSgtNum()));
                                            baseVO.setSgtMny(ComputeUtil.safeAdd(baseVO.getSgtMny(), compareVO.getSgtMny()));
                                            baseVO.setSgtPrice(ComputeUtil.safeDiv(baseVO.getSgtMny(), baseVO.getSgtNum()));
                                        } else if (bugetType.equals(BudgetTypeEnum.中标预算.getCode())) {
                                            baseVO.setZbNum(ComputeUtil.safeAdd(baseVO.getZbNum(), compareVO.getZbNum()));
                                            baseVO.setZbMny(ComputeUtil.safeAdd(baseVO.getZbMny(), compareVO.getZbMny()));
                                            baseVO.setZbPrice(ComputeUtil.safeDiv(baseVO.getZbMny(), baseVO.getZbNum()));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return baseCodeMap;
    }

    @Override
    public List<Map<String, Object>> queryProfitAnalyse(Long projectId) {
        List<ThreeCompareVO> result = new LinkedList<>();
        LambdaQueryWrapper<BudgetProjectEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BudgetProjectEntity::getProjectId, projectId);
        queryWrapper.in(BudgetProjectEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(BudgetProjectEntity::getBudgetType, BudgetTypeEnum.施工图预算.getCode(), BudgetTypeEnum.签证.getCode(), BudgetTypeEnum.其他.getCode());
        List<BudgetProjectEntity> entities = budgetProjectService.list(queryWrapper);
        detailListUtil.setDetailList(entities);

        // 目标成本按照预算类型分组，分别按照编码+名称汇总合价
        LambdaQueryWrapper<BudgetProjectProEntity> costWrapper = Wrappers.lambdaQuery();
        costWrapper.eq(BudgetProjectProEntity::getProjectId, projectId);
        costWrapper.in(BudgetProjectProEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<BudgetProjectProEntity> costList = costService.list(costWrapper);
        detailListUtil.setDetailList(costList);
        Map<Integer, Map<String, BigDecimal>> costMap = costList.stream().map(BudgetProjectProEntity::getDetailList).flatMap(Collection::stream).
                filter(x->null != x.getBudgetType() && ComputeUtil.isNotEmpty(x.getMny())).collect(Collectors.groupingBy(BudgetProjectDetailProEntity::getBudgetType,
                Collectors.toMap(x->(x.getCode() == null ? "" : x.getCode()) + ":" + x.getName(), BudgetProjectDetailProEntity::getMny, ComputeUtil::safeAdd)));

        if (CollectionUtils.isNotEmpty(entities)) {
            Map<String, ThreeCompareVO> baseCodeMap = new LinkedHashMap<>();
            Map<Integer, List<BudgetProjectEntity>> map = entities.stream().collect(Collectors.groupingBy(BudgetProjectEntity::getBudgetType));
            List<BudgetProjectEntity> sgtList = map.get(BudgetTypeEnum.施工图预算.getCode());
            if (CollectionUtils.isNotEmpty(sgtList)) {
                baseCodeMap = this.dealProfitReportData(sgtList, baseCodeMap, BudgetTypeEnum.施工图预算.getCode(), costMap.get(BudgetTypeEnum.施工图预算.getCode()));
            }
            if (!baseCodeMap.isEmpty()) {
                ThreeCompareVO compareVO = new ThreeCompareVO();
                compareVO.setId(IdWorker.getId());
                compareVO.setName("合同内");
                result.add(compareVO);
                for (ThreeCompareVO threeVO : baseCodeMap.values()) {
                    if (null == threeVO.getParentId()) {
                        threeVO.setParentId(compareVO.getId());
                    }
                    result.add(threeVO);
                }
            }

            baseCodeMap = new LinkedHashMap<>();

            List<BudgetProjectEntity> qzList = map.get(BudgetTypeEnum.签证.getCode());
            if (CollectionUtils.isNotEmpty(qzList)) {
                baseCodeMap = this.dealProfitReportData(qzList, baseCodeMap, BudgetTypeEnum.结算预算.getCode(), costMap.get(BudgetTypeEnum.签证.getCode()));
            }

            List<BudgetProjectEntity> qtList = map.get(BudgetTypeEnum.其他.getCode());
            if (CollectionUtils.isNotEmpty(qtList)) {
                baseCodeMap = this.dealProfitReportData(qtList, baseCodeMap, BudgetTypeEnum.结算预算.getCode(), costMap.get(BudgetTypeEnum.其他.getCode()));
            }

            if (!baseCodeMap.isEmpty()) {
                ThreeCompareVO compareVO = new ThreeCompareVO();
                compareVO.setId(IdWorker.getId());
                compareVO.setName("合同外");
                result.add(compareVO);
                for (ThreeCompareVO threeVO : baseCodeMap.values()) {
                    if (null == threeVO.getParentId()) {
                        threeVO.setParentId(compareVO.getId());
                    }
                    result.add(threeVO);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(result)) {
            this.generateSequences(result);
            List<Map> resultMapList = BeanMapper.mapList(result, Map.class);
            List<Map<String, Object>> treeData = TreeNodeBUtil.createTreeData(resultMapList);
            this.gatherProfitMny(null, treeData);
            return treeData.stream().sorted(BudgetProjectDetailServiceImpl::compareDetailIndex).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<BudgetSetDetailVO> queryBudgetSimilarByName(Long setId, String name) {
        return baseMapper.queryBudgetSimilarByName(setId, name);
    }

    @Override
    public Integer countBudgetSimilarByName(Long setId, String name) {
        return baseMapper.countBudgetSimilarByName(setId, name);
    }

    /**
     * 数据汇总
     * @param settles
     * @param baseCodeMap
     * @param bugetType
     * @return
     */
    private Map<String, ThreeCompareVO> dealProfitReportData(List<BudgetProjectEntity> settles, Map<String, ThreeCompareVO> baseCodeMap,
            Integer bugetType, Map<String, BigDecimal> costMap) {
        for (int i = 0; i < settles.size(); i++) {
            List<BudgetProjectDetailEntity> detailEntities = settles.get(i).getCheckList();
            if (CollectionUtils.isNotEmpty(detailEntities)) {
                detailEntities = detailEntities.stream().sorted(BudgetProjectDetailServiceImpl::compareDetailIndex).collect(Collectors.toList());
                if (baseCodeMap.isEmpty()) {
                    for (BudgetProjectDetailEntity detailEntity : detailEntities) {
                        ThreeCompareVO compareVO = BeanMapper.map(detailEntity, ThreeCompareVO.class);
                        if (bugetType.equals(BudgetTypeEnum.结算预算.getCode())) {
                            compareVO.setJsNum(detailEntity.getNum());
                            compareVO.setJsPrice(detailEntity.getPrice());
                            compareVO.setJsMny(detailEntity.getMny());
                        } else if (bugetType.equals(BudgetTypeEnum.施工图预算.getCode())) {
                            compareVO.setSgtNum(detailEntity.getNum());
                            compareVO.setSgtPrice(detailEntity.getPrice());
                            compareVO.setSgtMny(detailEntity.getMny());
                        } else if (bugetType.equals(BudgetTypeEnum.中标预算.getCode())) {
                            compareVO.setZbNum(detailEntity.getNum());
                            compareVO.setZbPrice(detailEntity.getPrice());
                            compareVO.setZbMny(detailEntity.getMny());
                        }
                        if(MapUtil.isNotEmpty(costMap)){
                            compareVO.setCostMny(costMap.get(this.createKey(compareVO)));
                            compareVO.setProfit(ComputeUtil.safeSub(compareVO.getMny(), compareVO.getCostMny()));
                            compareVO.setProfitRate(ComputeUtil.bigDecimalPercent(compareVO.getProfit(), compareVO.getMny(), 2));
                        }
                        baseCodeMap.put(this.createKey(compareVO), compareVO);
                    }
                } else {
                    List<ThreeCompareVO> tmp = new LinkedList<>();
                    for (BudgetProjectDetailEntity detailEntity : detailEntities) {
                        ThreeCompareVO compareVO = BeanMapper.map(detailEntity, ThreeCompareVO.class);
                        if (bugetType.equals(BudgetTypeEnum.结算预算.getCode())) {
                            compareVO.setJsNum(detailEntity.getNum());
                            compareVO.setJsPrice(detailEntity.getPrice());
                            compareVO.setJsMny(detailEntity.getMny());
                        } else if (bugetType.equals(BudgetTypeEnum.施工图预算.getCode())) {
                            compareVO.setSgtNum(detailEntity.getNum());
                            compareVO.setSgtPrice(detailEntity.getPrice());
                            compareVO.setSgtMny(detailEntity.getMny());
                        } else if (bugetType.equals(BudgetTypeEnum.中标预算.getCode())) {
                            compareVO.setZbNum(detailEntity.getNum());
                            compareVO.setZbPrice(detailEntity.getPrice());
                            compareVO.setZbMny(detailEntity.getMny());
                        }
                        if(MapUtil.isNotEmpty(costMap)){
                            compareVO.setCostMny(costMap.get(this.createKey(compareVO)));
                            compareVO.setProfit(ComputeUtil.safeSub(compareVO.getMny(), compareVO.getCostMny()));
                            compareVO.setProfitRate(ComputeUtil.bigDecimalPercent(compareVO.getProfit(), compareVO.getMny(), 2));
                        }
                        tmp.add(compareVO);
                    }

                    Map<Long, ThreeCompareVO> cpreIdMap = new LinkedHashMap<>();
                    Map<String, ThreeCompareVO> cpreCodeMap = new LinkedHashMap<>();
                    for (ThreeCompareVO compareVO : tmp) {
                        cpreIdMap.put(compareVO.getId(), compareVO);
                        cpreCodeMap.put(this.createKey(compareVO), compareVO);
                    }

                    for (ThreeCompareVO compareVO : tmp) {
                        String key = this.createKey(compareVO);
                        if (compareVO.getLeafFlag()) {
                            String innerCode = compareVO.getInnerCode();
                            //循环整个枝儿
                            for (String code : innerCode.split("\\|")) {
                                //非末级且不包含，放入map
                                if (!key.equals(code) && !baseCodeMap.containsKey(code)) {
                                    //非根节点，重新设置父Id:本集合内找到父级，然后根据父级key去基准map找到对应行
                                    ThreeCompareVO threeCompareVO = cpreCodeMap.get(code);
                                    if (null != threeCompareVO.getParentId()) {
                                        threeCompareVO.setParentId(baseCodeMap.get(this.createKey(cpreIdMap.get(threeCompareVO.getParentId()))).getId());
                                    }
                                    baseCodeMap.put(code, threeCompareVO);
                                } else if (key.equals(code)) {
                                    if (!baseCodeMap.containsKey(code)) {
                                        compareVO.setParentId(baseCodeMap.get(this.createKey(cpreIdMap.get(compareVO.getParentId()))).getId());
                                        baseCodeMap.put(key, compareVO);
                                    } else {
                                        ThreeCompareVO baseVO = baseCodeMap.get(key);
                                        if (bugetType.equals(BudgetTypeEnum.结算预算.getCode())) {
                                            baseVO.setJsNum(ComputeUtil.safeAdd(baseVO.getJsNum(), compareVO.getJsNum()));
                                            baseVO.setJsMny(ComputeUtil.safeAdd(baseVO.getJsMny(), compareVO.getJsMny()));
                                            baseVO.setJsPrice(ComputeUtil.safeDiv(baseVO.getJsMny(), baseVO.getJsNum()));
                                        } else if (bugetType.equals(BudgetTypeEnum.施工图预算.getCode())) {
                                            baseVO.setSgtNum(ComputeUtil.safeAdd(baseVO.getSgtNum(), compareVO.getSgtNum()));
                                            baseVO.setSgtMny(ComputeUtil.safeAdd(baseVO.getSgtMny(), compareVO.getSgtMny()));
                                            baseVO.setSgtPrice(ComputeUtil.safeDiv(baseVO.getSgtMny(), baseVO.getSgtNum()));
                                        } else if (bugetType.equals(BudgetTypeEnum.中标预算.getCode())) {
                                            baseVO.setZbNum(ComputeUtil.safeAdd(baseVO.getZbNum(), compareVO.getZbNum()));
                                            baseVO.setZbMny(ComputeUtil.safeAdd(baseVO.getZbMny(), compareVO.getZbMny()));
                                            baseVO.setZbPrice(ComputeUtil.safeDiv(baseVO.getZbMny(), baseVO.getZbNum()));
                                        }
                                        baseVO.setNum(ComputeUtil.safeAdd(baseVO.getNum(), compareVO.getNum()));
                                        baseVO.setMny(ComputeUtil.safeAdd(baseVO.getMny(), compareVO.getMny()));
                                        baseVO.setPrice(ComputeUtil.safeDiv(baseVO.getMny(), baseVO.getNum()));
                                        baseVO.setCostMny(ComputeUtil.safeDiv(baseVO.getCostMny(), compareVO.getCostMny()));
                                        baseVO.setProfit(ComputeUtil.safeSub(baseVO.getMny(), baseVO.getCostMny()));
                                        baseVO.setProfitRate(ComputeUtil.bigDecimalPercent(baseVO.getProfit(), baseVO.getMny(), 2));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return baseCodeMap;
    }

    private String createKey(ThreeCompareVO compareVO) {
        return (compareVO.getCode() == null ? "" : compareVO.getCode()) + ":" + compareVO.getName();
    }

    private static int compareDetailIndex(BudgetProjectDetailEntity detailEntity1, BudgetProjectDetailEntity detailEntity2) {
        String[] parts1 = detailEntity1.getDetailIndex().split("\\.");
        String[] parts2 = detailEntity1.getDetailIndex().split("\\.");

        int length = Math.max(parts1.length, parts2.length);

        for (int i = 0; i < length; i++) {
            int part1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int part2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;

            if (part1 != part2) {
                return Integer.compare(part1, part2);
            }
        }
        return 0;
    }

    private static int compareDetailIndex(Map<String, Object> m1, Map<String, Object> m2) {
        String[] parts1 = ((String)m1.get("detailIndex")).split("\\.");
        String[] parts2 = ((String)m2.get("detailIndex")).split("\\.");

        int length = Math.max(parts1.length, parts2.length);

        for (int i = 0; i < length; i++) {
            int part1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int part2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;

            if (part1 != part2) {
                return Integer.compare(part1, part2);
            }
        }
        return 0;
    }

    /**
     * 汇总金额
     */
    private void gatherMny(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal zbMny = null;
        BigDecimal sgtMny = null;
        BigDecimal jsMny = null;

        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                gatherMny(ypd, (List) ypd.get("children"));
            }
            zbMny = ComputeUtil.safeAdd(zbMny, getBigDecimalValue(ypd, "zbMny"));
            sgtMny = ComputeUtil.safeAdd(sgtMny, getBigDecimalValue(ypd, "sgtMny"));
            jsMny = ComputeUtil.safeAdd(jsMny, getBigDecimalValue(ypd, "jsMny"));
        }
        if (now != null) {
            now.put("zbMny", zbMny);
            now.put("sgtMny", sgtMny);
            now.put("jsMny", jsMny);
        }
    }

    /**
     * 汇总金额
     */
    private void gatherProfitMny(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal zbMny = null;
        BigDecimal sgtMny = null;
        BigDecimal jsMny = null;
        BigDecimal mny = null;
        BigDecimal costMny = null;

        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.gatherProfitMny(ypd, (List) ypd.get("children"));
            }
            zbMny = ComputeUtil.safeAdd(zbMny, this.getBigDecimalValue(ypd, "zbMny"));
            sgtMny = ComputeUtil.safeAdd(sgtMny, this.getBigDecimalValue(ypd, "sgtMny"));
            jsMny = ComputeUtil.safeAdd(jsMny, this.getBigDecimalValue(ypd, "jsMny"));
            mny = ComputeUtil.safeAdd(mny, this.getBigDecimalValue(ypd, "mny"));
            costMny = ComputeUtil.safeAdd(costMny, this.getBigDecimalValue(ypd, "costMny"));
        }
        if (now != null) {
            now.put("zbMny", zbMny);
            now.put("sgtMny", sgtMny);
            now.put("jsMny", jsMny);
            now.put("mny", mny);
            now.put("costMny", costMny);
            BigDecimal profit = ComputeUtil.safeSub(mny, costMny);
            BigDecimal profitRate = ComputeUtil.bigDecimalPercent(profit, mny, 2);
            now.put("profit", profit);
            now.put("profitRate", profitRate);
        }
    }

    private BigDecimal getBigDecimalValue(Map<String, Object> ypd, String code) {
        return ypd.get(code) == null ? null : (BigDecimal) ypd.get(code);
    }

    private void treeToList(List<Map<String, Object>> list, List<ThreeCompareVO> voList) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), voList);
            }
            voList.add(BeanMapper.map(ypd, ThreeCompareVO.class));
        }
    }

    private void generateSequences(List<ThreeCompareVO> compareVOS) {
        Map<Long, ThreeCompareVO> compareVOMap = new LinkedHashMap<>();
        for (ThreeCompareVO compareVO : compareVOS) {
            compareVOMap.put(compareVO.getId(), compareVO);
        }

        int rootIndex = 1;
        for (ThreeCompareVO department : compareVOS) {
            if (department.getParentId() == null) {
                department.setDetailIndex(String.valueOf(rootIndex));
                setChildSequences(department, compareVOMap, String.valueOf(rootIndex));
                rootIndex++;
            }
        }
    }

    private void setChildSequences(ThreeCompareVO compareVO, Map<Long, ThreeCompareVO> compareVOMap, String parentSequence) {
        List<ThreeCompareVO> children = new LinkedList<>();
        for (ThreeCompareVO department : compareVOMap.values()) {
            if (compareVO.getId().equals(department.getParentId())) {
                children.add(department);
            }
        }

        for (int i = 0; i < children.size(); i++) {
            ThreeCompareVO child = children.get(i);
            String sequence = parentSequence + "." + (i + 1);
            child.setDetailIndex(sequence);
            setChildSequences(child, compareVOMap, sequence);
        }
    }
}
