package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.cost.bean.ClaimDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 对外签证
 *
 * @author generator
 *
 */
 @TableName("ejc_cost_claim")
public class ClaimEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="proj_manager_id")
    private Long projManagerId; // 项目负责人ID
    @TableField(value="proj_manager_name")
    private String projManagerName; // 项目负责人名称
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="occur_date")
    private Date occurDate; // 发生日期
    @TableField(value="change_type")
    private Integer changeType; // 变更类型，1-施工范围内增补变更，2-施工范围线外增补，3-非增补变更
    @TableField(value="commit_file_desc")
    private String commitFileDesc; // 提交资料说明
    @TableField(value="visa_state")
    private Integer visaState; // 是否办理对外签证
    @TableField(value="no_visa_reason")
    private String noVisaReason; // 不办理签证理由
    @TableField(value="offer_state")
    private Integer offerState; // 是否需要报价
    @TableField(value="first_expect")
    private String firstExpect; // 甲方预期
    @TableField(value="image_state")
    private Integer imageState; // 对外签证是否需要附图
    @TableField(value="image_type")
    private String imageType; // 对外签证图纸类型
    @TableField(value="importance_state")
    private Integer importanceState; // 是否为大变更
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="pre_approve_mny")
    private BigDecimal preApproveMny; // 预计审定金额
    @TableField(value="offer_mny")
    private BigDecimal offerMny; // 报价金额
    @TableField(value="cost_mny")
    private BigDecimal costMny; // 成本金额
    @TableField(value="first_agree_mny")
    private BigDecimal firstAgreeMny; // 甲方批复金额
    @TableField(value="lock_state")
    private Integer lockState; // 锁定状态1-锁项2-锁价


    @TableField(exist=false)
    @SubEntity(serviceName="claimDetailService", pidName = "claimId")//此处有pid="xxx"，默认值pid="pid"
    private List<ClaimDetailEntity> detailList = new ArrayList<>(); // 对外签证明细

    @TableField(exist=false)
    @SubEntity(serviceName="claimAdjustmentDetailService", pidName = "claimId")//此处有pid="xxx"，默认值pid="pid"
    private List<ClaimAdjustmentDetailEntity> claimAdjustmentDetailList = new ArrayList<>(); // 对外签证调整明细


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjManagerId() {
        return projManagerId;
    }

    public void setProjManagerId(Long projManagerId) {
        this.projManagerId = projManagerId;
    }
    public String getProjManagerName() {
        return projManagerName;
    }

    public void setProjManagerName(String projManagerName) {
        this.projManagerName = projManagerName;
    }
    public Date getOccurDate() {
        return occurDate;
    }

    public void setOccurDate(Date occurDate) {
        this.occurDate = occurDate;
    }
    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    public String getCommitFileDesc() {
        return commitFileDesc;
    }

    public void setCommitFileDesc(String commitFileDesc) {
        this.commitFileDesc = commitFileDesc;
    }
    public Integer getVisaState() {
        return visaState;
    }

    public void setVisaState(Integer visaState) {
        this.visaState = visaState;
    }
    public String getNoVisaReason() {
        return noVisaReason;
    }

    public void setNoVisaReason(String noVisaReason) {
        this.noVisaReason = noVisaReason;
    }
    public Integer getOfferState() {
        return offerState;
    }

    public void setOfferState(Integer offerState) {
        this.offerState = offerState;
    }
    public String getFirstExpect() {
        return firstExpect;
    }

    public void setFirstExpect(String firstExpect) {
        this.firstExpect = firstExpect;
    }
    public Integer getImageState() {
        return imageState;
    }

    public void setImageState(Integer imageState) {
        this.imageState = imageState;
    }
    public String getImageType() {
        return imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }
    public Integer getImportanceState() {
        return importanceState;
    }

    public void setImportanceState(Integer importanceState) {
        this.importanceState = importanceState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public BigDecimal getPreApproveMny() {
        return preApproveMny;
    }

    public void setPreApproveMny(BigDecimal preApproveMny) {
        this.preApproveMny = preApproveMny;
    }
    public BigDecimal getOfferMny() {
        return offerMny;
    }

    public void setOfferMny(BigDecimal offerMny) {
        this.offerMny = offerMny;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getFirstAgreeMny() {
        return firstAgreeMny;
    }

    public void setFirstAgreeMny(BigDecimal firstAgreeMny) {
        this.firstAgreeMny = firstAgreeMny;
    }
    public Integer getLockState() {
        return lockState;
    }

    public void setLockState(Integer lockState) {
        this.lockState = lockState;
    }

    public List<ClaimDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ClaimDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<ClaimAdjustmentDetailEntity> getClaimAdjustmentDetailList() {
        return claimAdjustmentDetailList;
    }

    public void setClaimAdjustmentDetailList(List<ClaimAdjustmentDetailEntity> claimAdjustmentDetailList) {
        this.claimAdjustmentDetailList = claimAdjustmentDetailList;
    }
}
