package com.ejianc.business.cost.controller;

import com.ejianc.business.cost.service.ICostDetailService;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 项目看板
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@RestController
@RequestMapping("proPeportDetail")
public class ProPeportDetailController {
  @Resource private ICostDetailService costDetailService;

  @GetMapping("costSquareChart")
  public CommonResponse<LinkedHashMap<String, BigDecimal>> costSquareChart(@RequestParam("projectId") Long projectId) {
    return CommonResponse.success(costDetailService.costSquareChart(projectId));
  }
}
