package com.ejianc.business.cost.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.vo.CostAmountVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.bean.CostDetailEntity;
import com.ejianc.business.cost.bean.SettingEntity;
import com.ejianc.business.cost.bean.SubjectEntity;
import com.ejianc.business.cost.service.ICostDetailService;
import com.ejianc.business.cost.service.ISettingService;
import com.ejianc.business.cost.service.IShareDetailService;
import com.ejianc.business.cost.service.ISubjectService;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.cost.vo.ProjectReportVo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/cost/")
public class CostDetailApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICostDetailService costDetailService;

    @Autowired
    private ISettingService settingService;

    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IBudgetProjectProService budgetProjectProService;

    @RequestMapping(value = "saveCostDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CostDetailVO> saveCostDetail(
            @RequestBody List<CostDetailVO> list) {
        try {
            logger.info("成本信息:"+ JSONObject.toJSONString(list));
            if (CollectionUtils.isNotEmpty(list)) {
                LambdaQueryWrapper<SettingEntity> lambda = Wrappers.<SettingEntity>lambdaQuery();
                lambda.eq(SettingEntity::getProjectId, list.get(0).getProjectId());
                lambda.in(SettingEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
                List<SettingEntity> settingEntityList = settingService.list(lambda);
                if (CollectionUtils.isNotEmpty(settingEntityList)) {
                    LambdaQueryWrapper<SubjectEntity> lambda2 = Wrappers.<SubjectEntity>lambdaQuery();
                    lambda2.eq(SubjectEntity::getSettingId, settingEntityList.get(0).getId());
                    List<SubjectEntity> subjectEntityList = subjectService.list(lambda2);
                    Map<Long, List<SubjectEntity>> map = subjectEntityList.stream().collect(Collectors.groupingBy(SubjectEntity::getId));
                    for (CostDetailVO e : list) {
                        if (e.getSubjectId() != null) {
                            List<SubjectEntity> subjectEntities = map.get(e.getSubjectId());
                            if (CollectionUtils.isEmpty(subjectEntities)) {
                                return CommonResponse.error("插入失败，该项目的成本设置中没有此成本科目!");
                            }
                            Integer costType = subjectEntities.get(0).getCostType()!=null ? subjectEntities.get(0).getCostType() : e.getCostType();
                            e.setCostType(costType);
                            e.setCostTypeName(CostTypeEnum.getEnumByType(costType).getName());
                        }
                    }
                }
                List<CostDetailEntity> listres = BeanMapper.mapList(list, CostDetailEntity.class);
                costDetailService.deleteCostDetail(listres.get(0).getSourceId());
                costDetailService.saveBatch(listres);
            }
        } catch (Exception e) {
            logger.error("系统异常：" + e.getMessage());
            return CommonResponse.error("插入失败");
        }
        return CommonResponse.success("插入成功");
    }

    @RequestMapping(value = "deleteCostDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostDetailVO> deleteCostDetail(@RequestParam Long id) {
        try {
            costDetailService.deleteCostDetail(id);
        } catch (Exception e) {
            logger.error("系统异常：" + e.getMessage());
            return CommonResponse.error("删除失败");
        }
        return CommonResponse.success("删除成功");
    }

    @GetMapping(value = "/checkShareFlag")
    public CommonResponse<String> checkShareFlag(@RequestParam(value = "id", required = true) Long id) {
        QueryWrapper<CostDetailEntity> objectQueryWrapper = new QueryWrapper<>();
        objectQueryWrapper.eq("source_id", id);
        objectQueryWrapper.eq("share_flag", 1);
        int count = costDetailService.count(objectQueryWrapper);
        if (count == 0) {
            return CommonResponse.success("该单据没有被成本分摊！");
        } else {
            return CommonResponse.error("该单据已经被成本分摊！");
        }
    }

    @GetMapping(value = "/getCostMonth")
    public CommonResponse<Map<String, BigDecimal>> getCostMonth(@RequestParam(value = "projectId") Long projectId){
        Map<String, BigDecimal> map = null;
        List<ProjectReportVo> costMonth = costDetailService.getCostMonth(projectId);
        if (CollectionUtils.isNotEmpty(costMonth)){
            map = costMonth.stream().collect(Collectors.toMap(k -> k.getFinishMonth(), (k) -> k.getMny()));
        }
        return CommonResponse.success("成本查询！",map);
    }
    @GetMapping(value = "/getCostTypeAndBudgetMny")
    public CommonResponse<Map<Integer, BigDecimal>> getCostTypeAndBudgetMny(@RequestParam(value = "projectId") Long projectId){
        Map<Integer, BigDecimal> map = new HashMap<>();
        CostAmountVO costAmountVO = subjectService.queryCostSumMny(projectId);
        if (!Objects.isNull(costAmountVO)){
            map.put(1,costAmountVO.getLaborTaxMnyCost());
            map.put(2,costAmountVO.getMaterialTaxMnyCost());
            map.put(3,costAmountVO.getMajorTaxMnyCost());
            map.put(4,costAmountVO.getMechanicalTaxMnyCost());
            map.put(5,costAmountVO.getIndirectionTaxMnyCost());
        }
        QueryWrapper<BudgetProjectProEntity> budgetQueryWrapper = new QueryWrapper<>();
        budgetQueryWrapper.eq("project_id",projectId);
        List<BudgetProjectProEntity> budgetList = budgetProjectProService.list(budgetQueryWrapper);
        if (CollectionUtils.isNotEmpty(budgetList)){
            BudgetProjectProEntity budgetProjectProEntity = budgetList.get(0);
            BigDecimal budgetTaxMny = budgetProjectProEntity.getBudgetTaxMny();
            map.put(6,budgetTaxMny);
        }
        return CommonResponse.success("成本与预算查询！",map);
    }
}
