package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.cost.bean.GuidePriceDetailEntity;
import com.ejianc.business.cost.mapper.GuidePriceDetailMapper;
import com.ejianc.business.cost.service.IGuidePriceDetailService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 指导价-价格明细
 *
 * @author generator
 */
@Service("guidePriceDetailService")
public class GuidePriceDetailServiceImpl extends BaseServiceImpl<GuidePriceDetailMapper, GuidePriceDetailEntity> implements IGuidePriceDetailService {

    @Override
    public Map<String, BigDecimal> queryGuidePriceDetailData() {
        List<GuidePriceDetailEntity> detailEntityList = baseMapper.queryGuidePriceDetailData(InvocationInfoProxy.getTenantid());
        Map<String, BigDecimal> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (GuidePriceDetailEntity entity : detailEntityList) {
                map.put(entity.getMaterialId().toString() + (null == entity.getBrandId() ? null : entity.getBrandId().toString()), entity.getPrice());
            }
        }
        return map;
    }
}
