package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.vo.GuidePriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.GuidePriceMapper;
import com.ejianc.business.cost.bean.GuidePriceEntity;
import com.ejianc.business.cost.service.IGuidePriceService;

/**
 * 指导价
 * 
 * @author generator
 * 
 */
@Service("guidePriceService")
public class GuidePriceServiceImpl extends BaseServiceImpl<GuidePriceMapper, GuidePriceEntity> implements IGuidePriceService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDJ-CODE";//此处需要根据实际修改


    @Override
    public CommonResponse<GuidePriceVO> saveOrUpdate(GuidePriceVO guidePriceVO) {
        GuidePriceEntity entity = BeanMapper.map(guidePriceVO, GuidePriceEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),guidePriceVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        GuidePriceVO vo = BeanMapper.map(entity, GuidePriceVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
