/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectChangeProEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailChangeProEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectHistoryProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.bean.BudgetSetDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetQuotaEntity;
import com.ejianc.business.budget.bean.QuotaDetailEntity;
import com.ejianc.business.budget.bean.QuotaMatEntity;
import com.ejianc.business.budget.enums.ConvertResultEnum;
import com.ejianc.business.budget.mapper.BudgetProjectDetailProMapper;
import com.ejianc.business.budget.mapper.BudgetProjectProMapper;
import com.ejianc.business.budget.service.IBudgetProjectChangeProService;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectHistoryProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.service.IBudgetSetDetailService;
import com.ejianc.business.budget.service.IBudgetSetQuotaService;
import com.ejianc.business.budget.service.IBudgetSetService;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.service.IQuotaMatService;
import com.ejianc.business.budget.vo.BudgetProjectChangeProVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailReferenProVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetProjectHistoryProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityVO;
import com.ejianc.business.budget.vo.BudgetProjectProVO;
import com.ejianc.business.budget.vo.BudgetProjectVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailComparatoeVo;
import com.ejianc.business.budget.vo.comparator.BudgetDetailProComparatoeVo;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.bean.SubjectEntity;
import com.ejianc.business.cost.service.IGuidePriceDetailService;
import com.ejianc.business.cost.service.ISettingService;
import com.ejianc.business.cost.service.ISubjectService;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.api.ICategoryBrandApi;
import com.ejianc.foundation.share.vo.CategoryBrandVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectProService")
public class BudgetProjectProServiceImpl
extends BaseServiceImpl<BudgetProjectProMapper, BudgetProjectProEntity>
implements IBudgetProjectProService {
    @Autowired
    private BudgetProjectProMapper budgetProjectProMapper;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;
    @Autowired
    private BudgetProjectDetailProMapper budgetProjectDetailProMapper;
    @Autowired
    private IBudgetProjectProService budgetProService;
    @Autowired
    private ISettingService settingService;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IQuotaMatService quotaMatService;
    @Autowired
    private IQuotaDetailService quotaDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PROJECT_BUDGET_PRO_CODE";
    private static final String CHANGE_BILL_CODE = "PROJECT_BUDGET_PRO_CHANGE_CODE";
    private final String CHECK_PARAM = "P-Fu572q01";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBudgetSetService budgetSetService;
    @Autowired
    private IBudgetSetDetailService budgetSetDetailService;
    @Autowired
    private IBudgetSetQuotaService budgetSetQuotaService;
    @Autowired
    private IBudgetProjectChangeProService budgetProjectChangeProService;
    @Autowired
    private IGuidePriceDetailService guidePriceDetailService;
    @Autowired
    private ICategoryBrandApi categoryBrandApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PARAM_TEMP_MATERIAL_CODE = "P-QKse6304";
    private static final String PARAM_TEMP_LBOR_CODE = "P-7d32tl03";
    @Autowired
    private IBudgetProjectHistoryProService historyProService;

    @Override
    public BudgetProjectProVO queryDetail(Long id) {
        BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)this.budgetProjectProMapper.selectById(id));
        if (entity != null) {
            BudgetProjectProVO vo = (BudgetProjectProVO)BeanMapper.map((Object)((Object)entity), BudgetProjectProVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_id", new Parameter("eq", (Object)vo.getId()));
            List detailProEntityList = this.budgetProjectDetailProService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)detailProEntityList)) {
                List resultMapList = BeanMapper.mapList((Iterable)detailProEntityList, BudgetProjectDetailProVO.class);
                for (BudgetProjectDetailProVO cdEntity : resultMapList) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                Collections.sort(resultMapList, new BudgetDetailProComparatoeVo());
                vo.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            return vo;
        }
        return null;
    }

    @Override
    public List<BudgetProjectDetailReferenProVO> queryDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return this.budgetProjectProMapper.queryDetailList(page, wrapper, projectId, costType);
    }

    @Override
    public List<BudgetProjectDetailReferenProVO> queryOtherDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return this.budgetProjectProMapper.queryOtherDetailList(page, wrapper, projectId, costType);
    }

    @Override
    public BudgetProjectProQuantityAndMnyVO fetchQuantityAndMny(BudgetProjectProParamControlVO paramControlVO) {
        if (paramControlVO.getProjectId() == null) {
            return null;
        }
        BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = new BudgetProjectProQuantityAndMnyVO();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BudgetProjectProEntity::getProjectId, (Object)paramControlVO.getProjectId());
        lambdaQuery.in(BudgetProjectProEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)super.getOne((Wrapper)lambdaQuery));
        if (entity == null) {
            return null;
        }
        quantityAndMnyVO.setBudgetTaxMny(entity.getBudgetTaxMny());
        quantityAndMnyVO.setBudgetMny(entity.getBudgetMny());
        quantityAndMnyVO.setIndirectionTaxMny(entity.getIndirectionTaxMny());
        quantityAndMnyVO.setIndirectionMny(entity.getIndirectionMny());
        quantityAndMnyVO.setLaborTaxMny(entity.getLaborTaxMny());
        quantityAndMnyVO.setLaborMny(entity.getLaborMny());
        quantityAndMnyVO.setMaterialTaxMny(entity.getMaterialTaxMny());
        quantityAndMnyVO.setMaterialMny(entity.getMaterialMny());
        quantityAndMnyVO.setMajorTaxMny(entity.getMajorTaxMny());
        quantityAndMnyVO.setMajorMny(entity.getMajorMny());
        quantityAndMnyVO.setMechanicalTaxMny(entity.getMechanicalTaxMny());
        quantityAndMnyVO.setMechanicalMny(entity.getMechanicalMny());
        quantityAndMnyVO.setSporadicMaterialMny(entity.getSporadicMaterialMny());
        Map<Long, BudgetProjectDetailProVO> detailProMap = (paramControlVO.getCostType() == 2 || paramControlVO.getCostType() == 4) && CollectionUtils.isNotEmpty((Collection)paramControlVO.getIds()) ? this.budgetProjectDetailProMapper.fetchDetailProMapByQuantityAndMny(entity.getId(), paramControlVO.getCostType(), paramControlVO.getIds()) : this.budgetProjectDetailProMapper.fetchDetailProMap(entity.getId(), paramControlVO.getCostType());
        quantityAndMnyVO.setDetailProMap(detailProMap);
        return quantityAndMnyVO;
    }

    @Override
    public List<BudgetProjectDetailProVO> querySubDetailList(Page<BudgetProjectDetailProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return this.budgetProjectProMapper.querySubDetailList(page, wrapper, projectId, costType);
    }

    @Override
    public void pushCostSetting(Long budgetId) {
        ArrayList<SubjectEntity> subjectAndUpdateList = new ArrayList<SubjectEntity>();
        Map<Object, Object> subjectMap = new HashMap();
        BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)this.budgetProService.selectById(budgetId));
        List<BudgetProjectDetailProEntity> detailList = entity.getDetailList();
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"setting_id", (Object)budgetId);
        List subjectEntities = this.subjectService.list((Wrapper)objectQueryWrapper);
        if (CollectionUtils.isNotEmpty(detailList)) {
            if (CollectionUtils.isNotEmpty((Collection)subjectEntities)) {
                subjectMap = subjectEntities.stream().collect(Collectors.toMap(k -> k.getId(), k -> k));
                for (BudgetProjectDetailProEntity projectDetailProEntity : detailList) {
                    SubjectEntity subjectEntity = null;
                    if (subjectMap.containsKey(projectDetailProEntity.getId())) {
                        subjectEntity = (SubjectEntity)((Object)subjectMap.get(projectDetailProEntity.getId()));
                        subjectEntity.setParentId(projectDetailProEntity.getParentId());
                        subjectEntity.setVersion(subjectEntity.getVersion());
                    } else {
                        subjectEntity = new SubjectEntity();
                        subjectEntity.setSettingId(budgetId);
                        subjectEntity.setId(projectDetailProEntity.getId());
                        subjectEntity.setVersion(null);
                    }
                    subjectMap.remove(subjectEntity.getId());
                    subjectEntity.setCostType(projectDetailProEntity.getCostType());
                    subjectEntity.setParentId(projectDetailProEntity.getParentId());
                    subjectEntity.setTid(projectDetailProEntity.getId());
                    subjectEntity.setSubjectName(projectDetailProEntity.getSubjectName());
                    subjectEntity.setSubjectCode(projectDetailProEntity.getSubjectCode());
                    subjectEntity.setLeafFlag(projectDetailProEntity.getLeafFlag() == 1);
                    subjectEntity.setDetailIndex(projectDetailProEntity.getDetailIndex());
                    subjectEntity.setStatus(true);
                    subjectAndUpdateList.add(subjectEntity);
                }
            } else {
                for (BudgetProjectDetailProEntity detailProEntity : detailList) {
                    SubjectEntity subjectEntity = new SubjectEntity();
                    subjectEntity.setSettingId(budgetId);
                    subjectEntity.setCostType(detailProEntity.getCostType());
                    subjectEntity.setId(detailProEntity.getId());
                    subjectEntity.setParentId(detailProEntity.getParentId());
                    subjectEntity.setTid(detailProEntity.getId());
                    subjectEntity.setVersion(null);
                    subjectEntity.setSubjectName(detailProEntity.getSubjectName());
                    subjectEntity.setSubjectCode(detailProEntity.getSubjectCode());
                    subjectEntity.setLeafFlag(detailProEntity.getLeafFlag() == 1);
                    subjectEntity.setDetailIndex(detailProEntity.getDetailIndex());
                    subjectEntity.setStatus(true);
                    subjectAndUpdateList.add(subjectEntity);
                }
            }
            if (!subjectMap.isEmpty()) {
                List ids = subjectMap.keySet().stream().collect(Collectors.toList());
                this.subjectService.removeByIds(ids);
            }
            this.subjectService.saveOrUpdateBatch(subjectAndUpdateList, subjectAndUpdateList.size());
        } else if (CollectionUtils.isNotEmpty((Collection)subjectEntities)) {
            List ids = subjectEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.subjectService.removeByIds(ids);
        }
    }

    @Override
    public List<BudgetProjectDetailProVO> queryOnlySuject(Long projectId, Integer costType, Set<Long> subjectIds) {
        return this.budgetProjectProMapper.queryOnlySuject(projectId, costType, subjectIds);
    }

    @Override
    public Map<Long, BigDecimal> getBudgetProjectProQuantityByProjectId(Long projectId) {
        List<BudgetProjectProQuantityVO> list;
        Map<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        if (projectId != null && CollectionUtils.isNotEmpty(list = this.budgetProjectDetailProMapper.getBudgetProjectProQuantityByProjectId(projectId))) {
            map = list.stream().collect(Collectors.toMap(BudgetProjectProQuantityVO::getMaterialId, BudgetProjectProQuantityVO::getNum, (key1, key2) -> key2));
        }
        return map;
    }

    @Override
    public List<BudgetProjectDetailProVO> getBudgetProjectDetailProDataAndSum(Long projectId) {
        return this.budgetProjectProMapper.getBudgetProjectDetailProDataAndSum(projectId);
    }

    @Override
    public Long pushToPro(BudgetProjectVO budgetProjectVO) {
        LambdaQueryWrapper qry = new LambdaQueryWrapper();
        qry.eq(BudgetProjectProEntity::getProjectId, (Object)budgetProjectVO.getProjectId());
        BudgetProjectProEntity proEntity = (BudgetProjectProEntity)((Object)this.getOne((Wrapper)qry, false));
        if (null != proEntity) {
            if (null == proEntity.getSourceId()) {
                throw new BusinessException("\u5df2\u5b58\u5728\u81ea\u5236\u76ee\u6807\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u9884\u7b97\u8f6c\u6362\u751f\u6210!");
            }
            if (!(BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(proEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(proEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(proEntity.getBillState()))) {
                throw new BusinessException("\u8be5\u9879\u76ee\u76ee\u6807\u6210\u672c\u672a\u751f\u6548\uff0c\u8bf7\u5904\u7406\u540e\u751f\u6210!");
            }
            if (2 == proEntity.getChangeStatus()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u53d8\u66f4\u4e2d\uff0c\u8bf7\u5904\u7406\u540e\u751f\u6210!");
            }
        }
        Integer index = null;
        if (null == proEntity) {
            index = 0;
        } else {
            QueryWrapper query = Wrappers.query();
            query.eq((Object)"budget_id", (Object)proEntity.getId());
            query.isNull((Object)"parent_id");
            query.select(new String[]{"MAX(CONVERT(detail_index, UNSIGNED)) AS detail_index"});
            BudgetProjectDetailProEntity detailProEntity = (BudgetProjectDetailProEntity)((Object)this.budgetProjectDetailProMapper.selectOne((Wrapper)query));
            index = null != detailProEntity && StringUtils.isNotBlank((CharSequence)detailProEntity.getDetailIndex()) ? Integer.parseInt(detailProEntity.getDetailIndex()) : 0;
        }
        ArrayList<BudgetProjectDetailProEntity> entities = new ArrayList<BudgetProjectDetailProEntity>();
        Set setDetailSet = budgetProjectVO.getCheckList().stream().filter(x -> !ConvertResultEnum.\u5df2\u5ffd\u7565.getCode().equals(x.getResultState()) && null != x.getSetDetailId()).collect(Collectors.toList()).stream().map(BudgetProjectDetailVO::getSetDetailId).collect(Collectors.toSet());
        if (!setDetailSet.isEmpty()) {
            List setDetailEntities = (List)this.budgetSetDetailService.listByIds(new ArrayList(setDetailSet));
            Map<Long, BudgetSetDetailEntity> setdetailMap = setDetailEntities.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (x1, x2) -> x1));
            LambdaQueryWrapper setQuotaQry = new LambdaQueryWrapper();
            setQuotaQry.in(BudgetSetQuotaEntity::getSetDetailId, new ArrayList(setDetailSet));
            List setQuotaEntities = this.budgetSetQuotaService.list((Wrapper)setQuotaQry);
            HashMap<Long, List<BudgetSetQuotaEntity>> setQuotaMap = new HashMap<Long, List<BudgetSetQuotaEntity>>();
            ArrayList<Long> quotaIdList = new ArrayList<Long>();
            for (BudgetSetQuotaEntity quotaEntity : setQuotaEntities) {
                ArrayList<BudgetSetQuotaEntity> list = setQuotaMap.containsKey(quotaEntity.getSetDetailId()) ? (List)setQuotaMap.get(quotaEntity.getSetDetailId()) : new ArrayList<BudgetSetQuotaEntity>();
                list.add(quotaEntity);
                setQuotaMap.put(quotaEntity.getSetDetailId(), list);
                quotaIdList.add(quotaEntity.getQuotaId());
            }
            List quotaDetails = (List)this.quotaDetailService.listByIds(quotaIdList);
            Map<Long, QuotaDetailEntity> quotaDetailMap = quotaDetails.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (x1, x2) -> x1));
            LambdaQueryWrapper quotaMatQry = Wrappers.lambdaQuery();
            quotaMatQry.in(QuotaMatEntity::getQuotaDetailId, quotaIdList);
            List quotaMats = this.quotaMatService.list((Wrapper)quotaMatQry);
            Map<Long, List<QuotaMatEntity>> quotaMatMap = quotaMats.stream().collect(Collectors.groupingBy(QuotaMatEntity::getQuotaDetailId));
            Map<String, BigDecimal> guidePriceMap = this.guidePriceDetailService.queryGuidePriceDetailData();
            HashMap<Long, CategoryBrandVO> branchMap = new HashMap();
            CommonResponse response = this.categoryBrandApi.queryWhetherByCtyIds(new ArrayList());
            if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
                branchMap = ((List)response.getData()).stream().collect(Collectors.toMap(CategoryBrandVO::getCategoryId, Function.identity(), (key1, key2) -> key1));
            }
            CommonResponse paramRespone = this.paramConfigApi.getByCode("P-Fu572q01");
            List<BudgetProjectDetailProEntity> detailList = null;
            detailList = paramRespone.isSuccess() && null != paramRespone.getData() && ((ParamRegisterSetVO)paramRespone.getData()).getValueData().equals("2") ? this.budgetDetail(index, budgetProjectVO, setdetailMap, setQuotaMap, quotaDetailMap, quotaMatMap, guidePriceMap, branchMap) : this.noBudgetDetail(index, budgetProjectVO, setdetailMap, setQuotaMap, quotaDetailMap, quotaMatMap, guidePriceMap, branchMap);
            List resultMapList = BeanMapper.mapList(detailList, Map.class);
            List treeData = TreeNodeBUtil.createTreeData((List)resultMapList);
            this.gatherMny(null, treeData);
            this.treeToList(treeData, entities);
        }
        return this.makeTarget(entities, budgetProjectVO, proEntity);
    }

    private List<BudgetProjectDetailProEntity> budgetDetail(Integer index, BudgetProjectVO budgetProjectVO, Map<Long, BudgetSetDetailEntity> setdetailMap, Map<Long, List<BudgetSetQuotaEntity>> setQuotaMap, Map<Long, QuotaDetailEntity> quotaDetailMap, Map<Long, List<QuotaMatEntity>> quotaMatMap, Map<String, BigDecimal> guidePriceMap, Map<Long, CategoryBrandVO> branchMap) {
        ArrayList<BudgetProjectDetailProEntity> detailList = new ArrayList<BudgetProjectDetailProEntity>();
        HashMap<Long, Long> relationMap = new HashMap<Long, Long>();
        List checkList = budgetProjectVO.getCheckList();
        Collections.sort(checkList, new BudgetDetailComparatoeVo());
        for (BudgetProjectDetailVO detailVO : checkList) {
            BudgetProjectDetailProEntity detailProEntity;
            Object setDetailEntity;
            if (ConvertResultEnum.\u5df2\u5ffd\u7565.getCode().equals(detailVO.getResultState()) && detailVO.getLeafFlag().booleanValue()) continue;
            if (null != detailVO.getSetDetailId()) {
                setDetailEntity = setdetailMap.get(detailVO.getSetDetailId());
                List<BudgetSetQuotaEntity> setQuotas = setQuotaMap.get(detailVO.getSetDetailId());
                if (!CollectionUtils.isNotEmpty(setQuotas)) continue;
                BudgetProjectDetailProEntity detailProEntity2 = new BudgetProjectDetailProEntity();
                detailProEntity2.setDetailIndex(index + detailVO.getDetailIndex().substring(detailVO.getDetailIndex().indexOf(".")));
                detailProEntity2.setSourceId(budgetProjectVO.getId());
                detailProEntity2.setSourceDetailId(detailVO.getId());
                detailProEntity2.setBudgetType(budgetProjectVO.getBudgetType());
                detailProEntity2.setId(IdWorker.getId());
                detailProEntity2.setCode(detailVO.getCode());
                detailProEntity2.setName(detailVO.getName());
                detailProEntity2.setSpec(detailVO.getProjectFeature());
                detailProEntity2.setUnit(detailVO.getUnit());
                detailProEntity2.setNum(detailVO.getNum());
                detailProEntity2.setLeafFlag(0);
                detailProEntity2.setSubjectId(detailProEntity2.getId());
                detailProEntity2.setSubjectCode(detailProEntity2.getCode());
                detailProEntity2.setSubjectName(detailProEntity2.getName());
                detailProEntity2.setParentId((Long)relationMap.get(detailVO.getParentId()));
                detailList.add(detailProEntity2);
                for (int i = 1; i <= setQuotas.size(); ++i) {
                    BudgetSetQuotaEntity setQuotaEntity = setQuotas.get(i - 1);
                    QuotaDetailEntity quotaDetailEntity = quotaDetailMap.get(setQuotaEntity.getQuotaId());
                    List<QuotaMatEntity> matEntities = quotaMatMap.get(setQuotaEntity.getQuotaId());
                    detailList.addAll(this.convert(budgetProjectVO, (BudgetSetDetailEntity)((Object)setDetailEntity), setQuotaEntity, quotaDetailEntity, matEntities, i, detailVO, detailProEntity2, guidePriceMap, branchMap));
                }
                continue;
            }
            if (null == detailVO.getParentId()) {
                setDetailEntity = index;
                Integer n = index = Integer.valueOf(index + 1);
                detailProEntity = new BudgetProjectDetailProEntity();
                detailProEntity.setDetailIndex(String.valueOf(index));
                detailProEntity.setSourceId(budgetProjectVO.getId());
                detailProEntity.setSourceDetailId(detailVO.getId());
                detailProEntity.setBudgetType(budgetProjectVO.getBudgetType());
                detailProEntity.setId(IdWorker.getId());
                detailProEntity.setCode(detailVO.getCode());
                detailProEntity.setName(detailVO.getName());
                detailProEntity.setSpec(detailVO.getProjectFeature());
                detailProEntity.setUnit(detailVO.getUnit());
                detailProEntity.setNum(detailVO.getNum());
                detailProEntity.setLeafFlag(0);
                detailProEntity.setSubjectId(detailProEntity.getId());
                detailProEntity.setSubjectCode(detailProEntity.getCode());
                detailProEntity.setSubjectName(detailProEntity.getName());
                relationMap.put(detailVO.getId(), detailProEntity.getId());
                detailList.add(detailProEntity);
                continue;
            }
            if (!detailVO.getLeafFlag().booleanValue()) {
                detailProEntity = new BudgetProjectDetailProEntity();
                detailProEntity.setDetailIndex(index + detailVO.getDetailIndex().substring(detailVO.getDetailIndex().indexOf(".")));
                detailProEntity.setSourceId(budgetProjectVO.getId());
                detailProEntity.setSourceDetailId(detailVO.getId());
                detailProEntity.setBudgetType(budgetProjectVO.getBudgetType());
                detailProEntity.setId(IdWorker.getId());
                detailProEntity.setCode(detailVO.getCode());
                detailProEntity.setName(detailVO.getName());
                detailProEntity.setSpec(detailVO.getProjectFeature());
                detailProEntity.setUnit(detailVO.getUnit());
                detailProEntity.setNum(detailVO.getNum());
                detailProEntity.setLeafFlag(0);
                detailProEntity.setSubjectId(detailProEntity.getId());
                detailProEntity.setSubjectCode(detailProEntity.getCode());
                detailProEntity.setSubjectName(detailProEntity.getName());
                detailProEntity.setParentId((Long)relationMap.get(detailVO.getParentId()));
                relationMap.put(detailVO.getId(), detailProEntity.getId());
                detailList.add(detailProEntity);
                continue;
            }
            detailProEntity = new BudgetProjectDetailProEntity();
            detailProEntity.setDetailIndex(index + detailVO.getDetailIndex().substring(detailVO.getDetailIndex().indexOf(".")));
            detailProEntity.setSourceId(budgetProjectVO.getId());
            detailProEntity.setSourceDetailId(detailVO.getId());
            detailProEntity.setBudgetType(budgetProjectVO.getBudgetType());
            detailProEntity.setId(IdWorker.getId());
            detailProEntity.setCode(detailVO.getCode());
            detailProEntity.setName(detailVO.getName());
            detailProEntity.setSpec(detailVO.getProjectFeature());
            detailProEntity.setUnit(detailVO.getUnit());
            detailProEntity.setNum(detailVO.getNum());
            detailProEntity.setRate(BigDecimal.valueOf(9L));
            detailProEntity.setLeafFlag(1);
            detailProEntity.setSubjectId(detailProEntity.getId());
            detailProEntity.setSubjectCode(detailProEntity.getCode());
            detailProEntity.setSubjectName(detailProEntity.getName());
            detailProEntity.setParentId((Long)relationMap.get(detailVO.getParentId()));
            detailList.add(detailProEntity);
        }
        return detailList;
    }

    private List<BudgetProjectDetailProEntity> noBudgetDetail(Integer index, BudgetProjectVO budgetProjectVO, Map<Long, BudgetSetDetailEntity> setdetailMap, Map<Long, List<BudgetSetQuotaEntity>> setQuotaMap, Map<Long, QuotaDetailEntity> quotaDetailMap, Map<Long, List<QuotaMatEntity>> quotaMatMap, Map<String, BigDecimal> guidePriceMap, Map<Long, CategoryBrandVO> branchMap) {
        ArrayList<BudgetProjectDetailProEntity> detailList = new ArrayList<BudgetProjectDetailProEntity>();
        for (BudgetProjectDetailVO detailVO : budgetProjectVO.getCheckList()) {
            Object setDetailEntity;
            if (ConvertResultEnum.\u5df2\u5ffd\u7565.getCode().equals(detailVO.getResultState()) || !detailVO.getLeafFlag().booleanValue()) continue;
            if (null != detailVO.getSetDetailId()) {
                setDetailEntity = setdetailMap.get(detailVO.getSetDetailId());
                List<BudgetSetQuotaEntity> setQuotas = setQuotaMap.get(detailVO.getSetDetailId());
                if (!CollectionUtils.isNotEmpty(setQuotas)) continue;
                for (BudgetSetQuotaEntity setQuotaEntity : setQuotas) {
                    QuotaDetailEntity quotaDetailEntity = quotaDetailMap.get(setQuotaEntity.getQuotaId());
                    List<QuotaMatEntity> matEntities = quotaMatMap.get(setQuotaEntity.getQuotaId());
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                    detailList.addAll(this.convert(budgetProjectVO, (BudgetSetDetailEntity)((Object)setDetailEntity), setQuotaEntity, quotaDetailEntity, matEntities, index, detailVO, null, guidePriceMap, branchMap));
                }
                continue;
            }
            setDetailEntity = index;
            Integer n = index = Integer.valueOf(index + 1);
            BudgetProjectDetailProEntity detailProEntity = new BudgetProjectDetailProEntity();
            detailProEntity.setDetailIndex(String.valueOf(index));
            detailProEntity.setSourceId(budgetProjectVO.getId());
            detailProEntity.setSourceDetailId(detailVO.getId());
            detailProEntity.setBudgetType(budgetProjectVO.getBudgetType());
            detailProEntity.setId(IdWorker.getId());
            detailProEntity.setCode(detailVO.getCode());
            detailProEntity.setName(detailVO.getName());
            detailProEntity.setSpec(detailVO.getProjectFeature());
            detailProEntity.setUnit(detailVO.getUnit());
            detailProEntity.setNum(detailVO.getNum());
            detailProEntity.setRate(BigDecimal.valueOf(9L));
            detailProEntity.setLeafFlag(1);
            detailProEntity.setSubjectId(detailProEntity.getId());
            detailProEntity.setSubjectCode(detailProEntity.getCode());
            detailProEntity.setSubjectName(detailProEntity.getName());
            detailList.add(detailProEntity);
        }
        return detailList;
    }

    @Override
    public BudgetProjectProVO compareDetail(Long id, Boolean compareFirst, Integer compareIndex) {
        BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)this.selectById(id));
        BudgetProjectProVO vo = (BudgetProjectProVO)BeanMapper.map((Object)((Object)entity), BudgetProjectProVO.class);
        List detailList = vo.getDetailList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BudgetProjectHistoryProEntity::getBudgetId, (Object)id);
        if (compareFirst.booleanValue() || null != compareIndex) {
            queryWrapper.orderByAsc(BaseEntity::getCreateTime);
        } else {
            queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        }
        List list = this.historyProService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BudgetProjectHistoryProEntity budgetProjectHistoryProEntity = compareIndex != null && compareIndex > 0 && compareIndex <= list.size() ? (BudgetProjectHistoryProEntity)((Object)list.get(compareIndex - 1)) : (BudgetProjectHistoryProEntity)((Object)list.get(0));
            BudgetProjectHistoryProEntity budgetProjectHistory = (BudgetProjectHistoryProEntity)((Object)this.historyProService.selectById(budgetProjectHistoryProEntity.getId()));
            BudgetProjectHistoryProVO historyVO = (BudgetProjectHistoryProVO)BeanMapper.map((Object)((Object)budgetProjectHistory), BudgetProjectHistoryProVO.class);
            CompareDifferenceUtil.compareObj((Object)historyVO, (Object)vo);
            CompareDifferenceUtil.compareList((List)historyVO.getDetailList(), (List)vo.getDetailList(), (boolean)true);
        }
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            Collections.sort(detailList, new BudgetDetailProComparatoeVo());
            vo.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        return vo;
    }

    @Override
    public void beforeSaveCheck(List<BudgetProjectDetailProEntity> matchList) {
        if (CollectionUtils.isNotEmpty(matchList)) {
            ParamRegisterSetVO paramRegisterSetVO;
            String valueData;
            long count;
            ParamRegisterSetVO paramRegisterSetVO2;
            String valueData2;
            Boolean tempMaterialFlag = Boolean.FALSE;
            CommonResponse byCode = this.paramConfigApi.getByCode(PARAM_TEMP_MATERIAL_CODE);
            if (byCode.isSuccess() && null != byCode.getData() && StringUtils.isNotEmpty((CharSequence)(valueData2 = (paramRegisterSetVO2 = (ParamRegisterSetVO)byCode.getData()).getValueData()))) {
                tempMaterialFlag = valueData2.equals("\u662f");
            }
            if (!tempMaterialFlag.booleanValue() && (count = matchList.stream().filter(detailProEntity -> detailProEntity.getCostType() != null && detailProEntity.getCostType() == CostTypeEnum.MATERIAL_COST_TYPE.getType() && !"del".equals(detailProEntity.getRowState()) && detailProEntity.getMatchStatus() != null && !"1".equals(detailProEntity.getMatchStatus().toString())).count()) > 0L) {
                throw new BusinessException("\u6821\u9a8c\u5931\u8d25\uff0c\u53c2\u6570\u3010\u4e34\u65f6\u7269\u6599\u6863\u6848\u662f\u5426\u5f00\u542f\u3011\u672a\u5f00\u542f\uff0c\u8bf7\u5c06\u672a\u5339\u914d\u7684\u6863\u6848\u7cbe\u786e\u66ff\u6362\u540e\u91cd\u65b0\u4fdd\u5b58\uff01");
            }
            Boolean tempLaborFlag = Boolean.FALSE;
            CommonResponse byCodeLabor = this.paramConfigApi.getByCode(PARAM_TEMP_LBOR_CODE);
            if (byCodeLabor.isSuccess() && null != byCodeLabor.getData() && StringUtils.isNotEmpty((CharSequence)(valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCodeLabor.getData()).getValueData()))) {
                tempLaborFlag = valueData.equals("\u662f");
            }
            if (!tempLaborFlag.booleanValue()) {
                for (BudgetProjectDetailProEntity detailProEntity2 : matchList) {
                    ArrayList<String> detailIndexList = new ArrayList<String>();
                    if (detailProEntity2.getSourceId() == null && detailProEntity2.getCostType() != null && detailProEntity2.getCostType() == CostTypeEnum.LABOR_COST_TYPE.getType() && !"del".equals(detailProEntity2.getRowState())) {
                        detailIndexList.add(detailProEntity2.getDetailIndex());
                    }
                    if (detailIndexList.isEmpty()) continue;
                    String detailIndexStr = String.join((CharSequence)",", detailIndexList);
                    throw new BusinessException("\u6821\u9a8c\u5931\u8d25(\u6709" + detailIndexList.size() + "\u6761\u65b0\u589e\u4eba\u5de5\u8d39\u4e34\u65f6\u5b9a\u989d)\uff0c\u5e8f\u53f7\u4e3a[ " + detailIndexStr + " ]\uff0c\u53c2\u6570\u3010\u4e34\u65f6\u5b9a\u989d\u5e93\u662f\u5426\u5f00\u542f\u3011\u672a\u5f00\u542f\uff0c\u8bf7\u5c06\u65b0\u589e\u4e34\u65f6\u5b9a\u989d\u5904\u7406\u540e\u91cd\u65b0\u64cd\u4f5c\uff01");
                }
            }
        }
    }

    private Long makeTarget(List<BudgetProjectDetailProEntity> detailList, BudgetProjectVO budgetVO, BudgetProjectProEntity proEntity) {
        Long targetId = null;
        if (null == proEntity) {
            proEntity = new BudgetProjectProEntity();
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)budgetVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            proEntity.setBillCode((String)billCode.getData());
            proEntity.setSourceId(budgetVO.getId());
            proEntity.setTaxRate(BigDecimal.valueOf(9L));
            proEntity.setProjectId(budgetVO.getProjectId());
            proEntity.setProjectName(budgetVO.getProjectName());
            proEntity.setOrgId(budgetVO.getOrgId());
            proEntity.setOrgName(budgetVO.getOrgName());
            proEntity.setEmployeeId(budgetVO.getEmployeeId());
            proEntity.setEmployeeName(budgetVO.getEmployeeName());
            proEntity.setDepartmentId(budgetVO.getDepartmentId());
            proEntity.setDepartmentName(budgetVO.getDepartmentName());
            proEntity.setChangeStatus(1);
            proEntity.setDetailList(detailList);
            this.fullMny(proEntity);
            this.saveOrUpdate((Object)proEntity, false);
            targetId = proEntity.getId();
        } else {
            BudgetProjectChangeProVO budgetProjectChangeProVO = this.budgetProjectChangeProService.queryDetailChange(proEntity.getId(), false);
            BudgetProjectChangeProEntity entity = (BudgetProjectChangeProEntity)((Object)BeanMapper.map((Object)budgetProjectChangeProVO, BudgetProjectChangeProEntity.class));
            BillCodeParam billCodeParam = BillCodeParam.build((String)CHANGE_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)budgetProjectChangeProVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            Long mainId = IdWorker.getId();
            entity.setId(mainId);
            entity.setSourceId(budgetVO.getId());
            List<BudgetProjectDetailChangeProEntity> changeDetailList = entity.getDetailList();
            if (CollectionUtils.isNotEmpty(changeDetailList)) {
                HashMap idMap = new HashMap();
                for (BudgetProjectDetailChangeProEntity changeProEntity : changeDetailList) {
                    changeProEntity.setBudgetChangeId(mainId);
                    changeProEntity.setId(IdWorker.getId());
                    idMap.put(changeProEntity.getTid(), changeProEntity.getId());
                }
                for (BudgetProjectDetailChangeProEntity cdEntity : changeDetailList) {
                    if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
            }
            for (BudgetProjectDetailProEntity detailProEntity : detailList) {
                BudgetProjectDetailChangeProEntity changeProEntity;
                changeProEntity = (BudgetProjectDetailChangeProEntity)((Object)BeanMapper.map((Object)((Object)detailProEntity), BudgetProjectDetailChangeProEntity.class));
                changeProEntity.setBudgetChangeId(mainId);
                changeDetailList.add(changeProEntity);
            }
            this.fullMny(entity);
            this.budgetProjectChangeProService.saveOrUpdate((Object)entity, false);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(BudgetProjectProEntity::getChangeId, (Object)entity.getId());
            updateWrapper.set(BudgetProjectProEntity::getChangeStatus, (Object)2);
            updateWrapper.set(BudgetProjectProEntity::getChangeCode, (Object)entity.getBillCode());
            updateWrapper.set(BudgetProjectProEntity::getChangeVersion, (Object)entity.getVersion());
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getBudgetId());
            this.budgetProService.update((Wrapper)updateWrapper);
            targetId = entity.getBudgetId();
        }
        return targetId;
    }

    private void fullMny(BudgetProjectChangeProEntity proEntity) {
        BigDecimal budgetMny = BigDecimal.ZERO;
        BigDecimal budgetTaxMny = BigDecimal.ZERO;
        BigDecimal laborMny = BigDecimal.ZERO;
        BigDecimal laborTaxMny = BigDecimal.ZERO;
        BigDecimal materialMny = BigDecimal.ZERO;
        BigDecimal materialTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(proEntity.getDetailList())) {
            for (BudgetProjectDetailChangeProEntity detailProEntity : proEntity.getDetailList()) {
                if (null != detailProEntity.getParentId()) continue;
                budgetMny = ComputeUtil.safeAdd((BigDecimal)budgetMny, (BigDecimal)detailProEntity.getMny());
                budgetTaxMny = ComputeUtil.safeAdd((BigDecimal)budgetTaxMny, (BigDecimal)detailProEntity.getTaxMny());
                laborMny = ComputeUtil.safeAdd((BigDecimal)laborMny, (BigDecimal)detailProEntity.getLaborMnyCost());
                laborTaxMny = ComputeUtil.safeAdd((BigDecimal)laborTaxMny, (BigDecimal)detailProEntity.getLaborTaxMnyCost());
                materialMny = ComputeUtil.safeAdd((BigDecimal)materialMny, (BigDecimal)detailProEntity.getMaterialMnyCost());
                materialTaxMny = ComputeUtil.safeAdd((BigDecimal)materialTaxMny, (BigDecimal)detailProEntity.getMaterialTaxMnyCost());
            }
        }
        proEntity.setBudgetMny(budgetMny);
        proEntity.setBudgetTaxMny(budgetTaxMny);
        proEntity.setLaborMny(laborMny);
        proEntity.setLaborTaxMny(laborTaxMny);
        proEntity.setMaterialMny(materialMny);
        proEntity.setMaterialTaxMny(materialTaxMny);
    }

    private void fullMny(BudgetProjectProEntity proEntity) {
        BigDecimal budgetMny = BigDecimal.ZERO;
        BigDecimal budgetTaxMny = BigDecimal.ZERO;
        BigDecimal laborMny = BigDecimal.ZERO;
        BigDecimal laborTaxMny = BigDecimal.ZERO;
        BigDecimal materialMny = BigDecimal.ZERO;
        BigDecimal materialTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(proEntity.getDetailList())) {
            for (BudgetProjectDetailProEntity detailProEntity : proEntity.getDetailList()) {
                if (null != detailProEntity.getParentId()) continue;
                budgetMny = ComputeUtil.safeAdd((BigDecimal)budgetMny, (BigDecimal)detailProEntity.getMny());
                budgetTaxMny = ComputeUtil.safeAdd((BigDecimal)budgetTaxMny, (BigDecimal)detailProEntity.getTaxMny());
                laborMny = ComputeUtil.safeAdd((BigDecimal)laborMny, (BigDecimal)detailProEntity.getLaborMnyCost());
                laborTaxMny = ComputeUtil.safeAdd((BigDecimal)laborTaxMny, (BigDecimal)detailProEntity.getLaborTaxMnyCost());
                materialMny = ComputeUtil.safeAdd((BigDecimal)materialMny, (BigDecimal)detailProEntity.getMaterialMnyCost());
                materialTaxMny = ComputeUtil.safeAdd((BigDecimal)materialTaxMny, (BigDecimal)detailProEntity.getMaterialTaxMnyCost());
            }
        }
        proEntity.setBudgetMny(budgetMny);
        proEntity.setBudgetTaxMny(budgetTaxMny);
        proEntity.setLaborMny(laborMny);
        proEntity.setLaborTaxMny(laborTaxMny);
        proEntity.setMaterialMny(materialMny);
        proEntity.setMaterialTaxMny(materialTaxMny);
    }

    private List<BudgetProjectDetailProEntity> convert(BudgetProjectVO budgetProjectVO, BudgetSetDetailEntity setDetailEntity, BudgetSetQuotaEntity setQuotaEntity, QuotaDetailEntity quotaDetailEntity, List<QuotaMatEntity> quotaMatList, Integer index, BudgetProjectDetailVO detailVO, BudgetProjectDetailProEntity detailProEntity, Map<String, BigDecimal> guidePriceMap, Map<Long, CategoryBrandVO> branchMap) {
        LinkedList<BudgetProjectDetailProEntity> result = new LinkedList<BudgetProjectDetailProEntity>();
        if (CollectionUtils.isNotEmpty(quotaMatList)) {
            BudgetProjectDetailProEntity parent = new BudgetProjectDetailProEntity();
            parent.setDetailIndex(null == detailProEntity ? String.valueOf(index) : detailProEntity.getDetailIndex() + "." + index);
            parent.setSourceId(budgetProjectVO.getId());
            parent.setSourceDetailId(detailVO.getId());
            parent.setBudgetType(budgetProjectVO.getBudgetType());
            parent.setId(IdWorker.getId());
            parent.setCode(quotaDetailEntity.getDetailCode());
            parent.setName(quotaDetailEntity.getDetailName());
            parent.setSpec(detailVO.getProjectFeature());
            parent.setUnit(detailVO.getUnit());
            parent.setNum(detailVO.getNum());
            parent.setLeafFlag(0);
            parent.setSubjectId(parent.getId());
            parent.setSubjectCode(parent.getCode());
            parent.setSubjectName(parent.getName());
            parent.setParentId(null == detailProEntity ? null : detailProEntity.getId());
            int childIndex = 1;
            LinkedList<BudgetProjectDetailProEntity> matList = new LinkedList<BudgetProjectDetailProEntity>();
            for (QuotaMatEntity matEntity : quotaMatList) {
                BudgetProjectDetailProEntity material = new BudgetProjectDetailProEntity();
                material.setId(IdWorker.getId());
                material.setDetailIndex(parent.getDetailIndex() + "." + childIndex);
                material.setSourceId(budgetProjectVO.getId());
                material.setSourceDetailId(detailVO.getId());
                material.setBudgetType(budgetProjectVO.getBudgetType());
                material.setParentId(parent.getId());
                material.setCategoryId(matEntity.getCategoryId());
                material.setCategoryName(matEntity.getCategoryName());
                material.setMaterialId(matEntity.getMaterialId());
                material.setMaterialName(matEntity.getMaterialName());
                material.setCode(matEntity.getMaterialCode());
                material.setName(matEntity.getMaterialName());
                material.setCostType(2);
                material.setCostTypeName("\u6750\u6599\u8d39");
                material.setSpec(matEntity.getMaterialSpec());
                material.setUnit(matEntity.getMaterialUnit());
                BigDecimal convertRate = null == matEntity.getConvertRate() ? BigDecimal.ONE : matEntity.getConvertRate();
                material.setNum(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailVO.getNum(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)setQuotaEntity.getQuotaNum(), (BigDecimal)setDetailEntity.getDetailNum())), (BigDecimal)convertRate));
                BigDecimal lossRate = null == matEntity.getLossRate() ? BigDecimal.ONE : matEntity.getLossRate();
                material.setLossRate(lossRate);
                material.setRate(BigDecimal.valueOf(9L));
                CategoryBrandVO brandVO = branchMap.get(material.getCategoryId());
                if (null != brandVO) {
                    material.setBrandId(brandVO.getBrandId());
                    material.setBrandName(brandVO.getBrandName());
                }
                BigDecimal guidePrice = guidePriceMap.get(material.getMaterialId().toString() + (null == material.getBrandId() ? null : material.getBrandId().toString()));
                material.setGuidePrice(guidePrice);
                material.setPrice(guidePrice);
                material.setTaxPrice(ComputeUtil.safeMultiply((BigDecimal)material.getPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.ONE, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)material.getRate(), (BigDecimal)BigDecimal.valueOf(100L)))));
                material.setMaterialMnyCost(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)material.getNum(), (BigDecimal)material.getPrice()), (BigDecimal)lossRate));
                material.setMaterialTaxMnyCost(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)material.getNum(), (BigDecimal)material.getTaxPrice()), (BigDecimal)lossRate));
                material.setMny(material.getMaterialMnyCost());
                material.setTaxMny(material.getMaterialTaxMnyCost());
                material.setLeafFlag(1);
                material.setSubjectId(material.getId());
                material.setSubjectCode(material.getCode());
                material.setSubjectName(material.getName());
                matList.add(material);
                ++childIndex;
            }
            BudgetProjectDetailProEntity labor = new BudgetProjectDetailProEntity();
            labor.setId(IdWorker.getId());
            labor.setDetailIndex(parent.getDetailIndex() + "." + childIndex);
            labor.setSourceId(budgetProjectVO.getId());
            labor.setSourceDetailId(detailVO.getId());
            labor.setBudgetType(budgetProjectVO.getBudgetType());
            labor.setParentId(parent.getId());
            labor.setCode(quotaDetailEntity.getDetailCode());
            labor.setName(quotaDetailEntity.getDetailName());
            labor.setCostType(1);
            labor.setCostTypeName("\u4eba\u5de5\u8d39");
            labor.setSpec(quotaDetailEntity.getDescription());
            labor.setUnit(quotaDetailEntity.getDetailUnit());
            labor.setRate(BigDecimal.valueOf(9L));
            labor.setNum(ComputeUtil.safeMultiply((BigDecimal)detailVO.getNum(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)setQuotaEntity.getQuotaNum(), (BigDecimal)setDetailEntity.getDetailNum())));
            labor.setPrice(quotaDetailEntity.getLaborPrice());
            labor.setTaxPrice(ComputeUtil.safeMultiply((BigDecimal)labor.getPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.ONE, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)labor.getRate(), (BigDecimal)BigDecimal.valueOf(100L)))));
            labor.setLaborMnyCost(ComputeUtil.safeMultiply((BigDecimal)labor.getNum(), (BigDecimal)labor.getPrice()));
            labor.setLaborTaxMnyCost(ComputeUtil.safeMultiply((BigDecimal)labor.getNum(), (BigDecimal)labor.getTaxPrice()));
            labor.setMny(labor.getLaborMnyCost());
            labor.setTaxMny(labor.getLaborTaxMnyCost());
            labor.setLeafFlag(1);
            labor.setSubjectId(labor.getId());
            labor.setSubjectCode(labor.getCode());
            labor.setSubjectName(labor.getName());
            result.add(parent);
            result.addAll(matList);
            result.add(labor);
        } else {
            BudgetProjectDetailProEntity labor = new BudgetProjectDetailProEntity();
            labor.setId(IdWorker.getId());
            labor.setDetailIndex(null == detailProEntity ? String.valueOf(index) : detailProEntity.getDetailIndex() + "." + index);
            labor.setSourceId(budgetProjectVO.getId());
            labor.setSourceDetailId(detailVO.getId());
            labor.setBudgetType(budgetProjectVO.getBudgetType());
            labor.setCode(quotaDetailEntity.getDetailCode());
            labor.setName(quotaDetailEntity.getDetailName());
            labor.setCostType(1);
            labor.setCostTypeName("\u4eba\u5de5\u8d39");
            labor.setSpec(quotaDetailEntity.getDescription());
            labor.setUnit(quotaDetailEntity.getDetailUnit());
            labor.setRate(BigDecimal.valueOf(9L));
            labor.setNum(ComputeUtil.safeMultiply((BigDecimal)detailVO.getNum(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)setQuotaEntity.getQuotaNum(), (BigDecimal)setDetailEntity.getDetailNum())));
            labor.setPrice(quotaDetailEntity.getLaborPrice());
            labor.setTaxPrice(ComputeUtil.safeMultiply((BigDecimal)labor.getPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.ONE, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)labor.getRate(), (BigDecimal)BigDecimal.valueOf(100L)))));
            labor.setLaborMnyCost(ComputeUtil.safeMultiply((BigDecimal)labor.getNum(), (BigDecimal)labor.getPrice()));
            labor.setLaborTaxMnyCost(ComputeUtil.safeMultiply((BigDecimal)labor.getNum(), (BigDecimal)labor.getTaxPrice()));
            labor.setMny(labor.getLaborMnyCost());
            labor.setTaxMny(labor.getLaborTaxMnyCost());
            labor.setLeafFlag(1);
            labor.setParentId(null == detailProEntity ? null : detailProEntity.getId());
            labor.setSubjectId(labor.getId());
            labor.setSubjectCode(labor.getCode());
            labor.setSubjectName(labor.getName());
            result.add(labor);
        }
        return result;
    }

    private void gatherMny(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal mny = null;
        BigDecimal taxMny = null;
        BigDecimal materialMnyCost = null;
        BigDecimal materialTaxMnyCost = null;
        BigDecimal laborMnyCost = null;
        BigDecimal laborTaxMnyCost = null;
        BigDecimal indirectionMnyCost = null;
        BigDecimal indirectionTaxMnyCost = null;
        BigDecimal mechanicalMnyCost = null;
        BigDecimal mechanicalTaxMnyCost = null;
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.gatherMny(ypd, (List)ypd.get("children"));
            }
            mny = ComputeUtil.safeAdd(mny, (BigDecimal)this.getBigDecimalValue(ypd, "mny"));
            taxMny = ComputeUtil.safeAdd(taxMny, (BigDecimal)this.getBigDecimalValue(ypd, "taxMny"));
            materialMnyCost = ComputeUtil.safeAdd(materialMnyCost, (BigDecimal)this.getBigDecimalValue(ypd, "materialMnyCost"));
            materialTaxMnyCost = ComputeUtil.safeAdd(materialTaxMnyCost, (BigDecimal)this.getBigDecimalValue(ypd, "materialTaxMnyCost"));
            laborMnyCost = ComputeUtil.safeAdd(laborMnyCost, (BigDecimal)this.getBigDecimalValue(ypd, "laborMnyCost"));
            laborTaxMnyCost = ComputeUtil.safeAdd(laborTaxMnyCost, (BigDecimal)this.getBigDecimalValue(ypd, "laborTaxMnyCost"));
            indirectionMnyCost = ComputeUtil.safeAdd(indirectionMnyCost, (BigDecimal)this.getBigDecimalValue(ypd, "indirectionMnyCost"));
            indirectionTaxMnyCost = ComputeUtil.safeAdd(indirectionTaxMnyCost, (BigDecimal)this.getBigDecimalValue(ypd, "indirectionTaxMnyCost"));
            mechanicalMnyCost = ComputeUtil.safeAdd(mechanicalMnyCost, (BigDecimal)this.getBigDecimalValue(ypd, "mechanicalMnyCost"));
            mechanicalTaxMnyCost = ComputeUtil.safeAdd(mechanicalTaxMnyCost, (BigDecimal)this.getBigDecimalValue(ypd, "mechanicalTaxMnyCost"));
        }
        if (now != null) {
            now.put("mny", mny);
            now.put("taxMny", taxMny);
            now.put("materialMnyCost", materialMnyCost);
            now.put("materialTaxMnyCost", materialTaxMnyCost);
            now.put("laborMnyCost", laborMnyCost);
            now.put("laborTaxMnyCost", laborTaxMnyCost);
            now.put("indirectionMnyCost", indirectionMnyCost);
            now.put("indirectionTaxMnyCost", indirectionTaxMnyCost);
            now.put("mechanicalMnyCost", mechanicalMnyCost);
            now.put("mechanicalTaxMnyCost", mechanicalTaxMnyCost);
        }
    }

    private BigDecimal getBigDecimalValue(Map<String, Object> ypd, String code) {
        return ypd.get(code) == null ? null : (BigDecimal)ypd.get(code);
    }

    private void treeToList(List<Map<String, Object>> treeData, List<BudgetProjectDetailProEntity> entities) {
        for (Map<String, Object> ypd : treeData) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((BudgetProjectDetailProEntity)((Object)BeanMapper.map(ypd, BudgetProjectDetailProEntity.class)));
        }
    }
}

