/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.bean.CostDocumentsDetailEntity;
import com.ejianc.business.cost.bean.CostDocumentsEntity;
import com.ejianc.business.cost.mapper.CostDocumentsMapper;
import com.ejianc.business.cost.service.ICostDocumentsService;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="costDocumentsService")
public class CostDocumentsServiceImpl
extends BaseServiceImpl<CostDocumentsMapper, CostDocumentsEntity>
implements ICostDocumentsService {
    @Autowired
    private SessionManager sessionManager;
    private static Logger logger = LoggerFactory.getLogger((String)CostDocumentsServiceImpl.class.getName());
    @Autowired
    private ICostDetailApi iCostDetailApi;

    @Override
    public void processCost(CostDocumentsEntity entity) {
        if (ListUtil.isNotEmpty(entity.getCostDocumentsDetailList())) {
            ArrayList<CostDetailVO> list = new ArrayList<CostDetailVO>();
            boolean canPush = true;
            for (int i = 0; i < entity.getCostDocumentsDetailList().size(); ++i) {
                CostDocumentsDetailEntity sub = entity.getCostDocumentsDetailList().get(i);
                if (null == sub.getSubjectId()) {
                    canPush = false;
                }
                CostDetailVO c = new CostDetailVO();
                c.setSubjectId(sub.getSubjectId());
                c.setSourceId(entity.getId());
                c.setSourceDetailId(sub.getId());
                c.setProjectId(entity.getProjectId());
                c.setHappenTaxMny(sub.getMny() == null ? new BigDecimal("0.00") : sub.getMny());
                c.setHappenMny(sub.getMny() == null ? new BigDecimal("0.00") : sub.getMny());
                c.setHappenDate(entity.getCostDate());
                c.setMemo(sub.getRemark());
                c.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                c.setSourceType("COST_DOC");
                c.setSourceTabType("COST_DOC_DETAIL");
                String period = "";
                if (entity.getCostDate() != null) {
                    SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM");
                    period = ft.format(entity.getCostDate());
                }
                if ("01".equals(sub.getCostAttributeCode())) {
                    c.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
                    c.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName());
                } else if ("02".equals(sub.getCostAttributeCode())) {
                    c.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
                    c.setCostTypeName(CostTypeEnum.MECHANICAL_COST_TYPE.getName());
                }
                c.setPeriod(period);
                c.setShareFlag(Integer.valueOf(0));
                c.setSourceBillCode(entity.getBillCode());
                c.setSourceBillName("\u6210\u672c\u5355\u636e");
                c.setSourceBillUrl("/ejc-cost-frontend/#/costDocuments/card?id=" + entity.getId());
                list.add(c);
            }
            logger.info("list=============>\uff1a" + JSONObject.toJSONString(list));
            CommonResponse response = this.iCostDetailApi.saveSubject(list);
            logger.info("\u63a8\u9001\u6210\u672c\u6210\u672c\u5355\u636e\u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            entity.setRelationFlag(canPush ? "1" : "0");
        } else {
            this.iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }
}

