package com.ejianc.business.budget.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;

/**
 * @description: HomeStatisticController
 * @author songlx
 * @date 2024/11/11
 * @version 1.0
 */
@Controller
@RequestMapping("homeStatistic")
public class HomeStatisticController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBudgetProjectProService service;


    /**
     * @Description 合同额信息管理
     */
    @RequestMapping(value = "/targetCount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Integer> targetCount() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(Calendar.YEAR);
        QueryWrapper<BudgetProjectProEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.eq("YEAR ( create_time )", year);
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        return CommonResponse.success("目标成本项目数", service.count(queryWrapper));
    }



}
